/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.io.Serializable;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.casefile.CaseFile;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItemArray;
import org.cafienne.cmmn.instance.casefile.CaseFileItemCollection;
import org.cafienne.cmmn.instance.casefile.InvalidPathException;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;

public class Path
implements Serializable {
    public final String name;
    public final int index;
    private final String originalPath;
    private final Path parent;
    private final Path root;
    private final Path child;
    private final int depth;

    public Path(String string) throws InvalidPathException {
        this(Path.convertRawPath(string, true), string);
    }

    public static Path untrimmed(String string) throws InvalidPathException {
        return new Path(Path.convertRawPath(string, false), string);
    }

    public Path(CaseFileItemDefinition caseFileItemDefinition) {
        this(caseFileItemDefinition, null);
    }

    public Path(CaseFileItem caseFileItem) {
        this(caseFileItem, null);
    }

    private Path(CaseFileItemDefinition caseFileItemDefinition, Path path) {
        this.name = caseFileItemDefinition.getName();
        this.index = -1;
        this.child = path;
        if (caseFileItemDefinition.getParentElement() instanceof CaseFileDefinition) {
            this.parent = null;
            this.root = this;
            this.depth = 0;
        } else {
            this.parent = new Path((CaseFileItemDefinition)caseFileItemDefinition.getParentElement(), this);
            this.root = this.parent.root;
            this.depth = this.parent.depth + 1;
        }
        this.originalPath = this.toString();
    }

    private Path(CaseFileItem caseFileItem, Path path) {
        this.name = ((CaseFileItemDefinition)caseFileItem.getDefinition()).getName();
        this.index = caseFileItem.getIndex();
        this.child = path;
        CaseFileItem caseFileItem2 = caseFileItem.getParent();
        if (caseFileItem2 == null) {
            this.parent = null;
            this.root = this;
            this.depth = 0;
        } else {
            this.parent = new Path(caseFileItem2, this);
            this.root = this.parent.root;
            this.depth = this.parent.depth + 1;
        }
        this.originalPath = this.toString();
    }

    public Path(PlanItem<?> planItem) {
        this(planItem, null);
    }

    public Path(Path path, ItemDefinition itemDefinition, int n) {
        this.parent = path;
        this.root = this.parent.root;
        this.child = null;
        this.depth = this.parent.depth + 1;
        this.name = itemDefinition.getName();
        this.index = n;
        this.originalPath = this.toString();
    }

    private Path(PlanItem<?> planItem, Path path) {
        this.name = planItem.getName();
        this.index = planItem.getItemDefinition().getPlanItemControl().getRepetitionRule().isDefault() ? -1 : planItem.getIndex();
        this.child = path;
        Stage<?> stage = planItem.getStage();
        if (stage == null) {
            this.parent = null;
            this.root = this;
            this.depth = 0;
        } else {
            this.parent = new Path(stage, this);
            this.root = this.parent.root;
            this.depth = this.parent.depth + 1;
        }
        this.originalPath = this.toString();
    }

    private Path(Path path, Path path2, Path path3, int n, int n2) {
        this.name = path.name;
        this.depth = path.depth;
        this.root = path2 == null ? this : path2;
        this.parent = path3;
        if (path.child == null || path.depth == n) {
            this.index = n2;
            this.child = null;
        } else {
            this.index = path.index;
            this.child = new Path(path.child, this.root, this, n, n2);
        }
        this.originalPath = this.toString();
    }

    private Path(String[] stringArray, String string) {
        this(stringArray, null, stringArray.length - 1, string);
    }

    private Path(String[] stringArray, Path path, int n, String string) {
        this.child = path;
        this.depth = n;
        String string2 = stringArray[n];
        int n2 = string2.indexOf("[");
        this.index = this.parseIndex(string2, string, n2);
        this.name = string2.substring(0, n2 >= 0 ? n2 : string2.length());
        this.parent = n > 0 ? new Path(stringArray, this, n - 1, string) : null;
        this.root = this.parent == null ? this : this.parent.root;
        this.originalPath = string != null ? string : this.toString();
    }

    private int parseIndex(String string, String string2, int n) {
        if (n == 0) {
            throw new InvalidPathException("Missing name part in path, cannot start with an opening bracket '" + string2 + "'");
        }
        if (n < 0) {
            return -1;
        }
        if (!string.endsWith("]")) {
            throw new InvalidPathException("Path should end with a closing bracket, as it has an opening bracket '" + string2 + "'");
        }
        String string3 = string.substring(n + 1, string.length() - 1);
        try {
            int n2 = Integer.parseInt(string3);
            if (n2 < 0) {
                throw new InvalidPathException("'" + string3 + "' is not a valid index. Path index may not be negative '" + string2 + "'");
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPathException("'" + string3 + "' is not a valid index in path '" + string2 + "'");
        }
    }

    public <C extends CaseFileItemCollection<?>> C resolve(Case case_) throws InvalidPathException {
        CaseFile caseFile = case_.getCaseFile();
        if (this.isEmpty()) {
            return (C)caseFile;
        }
        return this.root.resolve(caseFile);
    }

    private <C extends CaseFileItemCollection<?>> C resolve(CaseFileItemCollection<?> caseFileItemCollection) throws InvalidPathException {
        if (this.isEmpty()) {
            return (C)caseFileItemCollection;
        }
        CaseFileItem caseFileItem = caseFileItemCollection.getItem(this.name);
        if (caseFileItem == null) {
            throw new InvalidPathException("The path '" + this.originalPath + "' is invalid, since the part '" + this.name + "' is not defined in the case file");
        }
        CaseFileItem caseFileItem2 = this.resolveOptionalArrayItem(caseFileItem);
        if (this.child != null) {
            return this.child.resolve(caseFileItem2);
        }
        return (C)caseFileItem2;
    }

    private CaseFileItem resolveOptionalArrayItem(CaseFileItem caseFileItem) {
        if (this.isArrayElement()) {
            if (caseFileItem.isArray()) {
                CaseFileItemArray caseFileItemArray = (CaseFileItemArray)caseFileItem.getContainer();
                if (caseFileItem.getCaseInstance().recoveryRunning()) {
                    return caseFileItemArray.getArrayElement(this.index);
                }
                if (caseFileItemArray.size() < this.index) {
                    throw new InvalidPathException("The array " + caseFileItemArray.getPath() + " has only " + caseFileItemArray.size() + " items; cannot access " + this.originalPath);
                }
                if (caseFileItemArray.size() == this.index) {
                    throw new InvalidPathException("The array " + caseFileItemArray.getPath() + " has only " + caseFileItemArray.size() + " items; cannot access " + this.originalPath + " (Note: index starts at 0 instead of 1)");
                }
                return caseFileItemArray.get(this.index);
            }
            throw new InvalidPathException("The path '" + this.originalPath + "' is invalid because the CaseFileItem is not of type array");
        }
        return caseFileItem;
    }

    public ValueMap resolveParent(ValueMap valueMap) {
        Path path = this.getParent();
        if (path.isEmpty()) {
            return valueMap;
        }
        return path.root.travel(valueMap);
    }

    private ValueMap travel(ValueMap valueMap) {
        ValueMap valueMap2 = this.getCurrentValue(valueMap);
        if (this.child == null) {
            return valueMap2;
        }
        return this.child.travel(valueMap2);
    }

    private ValueMap getCurrentValue(ValueMap valueMap) {
        if (this.isArrayElement()) {
            ValueList valueList = valueMap.withArray(this.name);
            if (valueList.size() > this.index) {
                Object object = valueList.get(this.index);
                if (((Value)object).isMap()) {
                    return ((Value)object).asMap();
                }
                ValueMap valueMap2 = new ValueMap();
                valueList.set(this.index, valueMap2);
                return valueMap2;
            }
            for (int i = valueList.size(); i < this.index; ++i) {
                valueList.add(Value.NULL);
            }
            ValueMap valueMap3 = new ValueMap();
            valueList.add(valueMap3);
            return valueMap3;
        }
        return valueMap.with(this.name);
    }

    public String toString() {
        if (this.parent != null) {
            return this.parent + "/" + this.getPart();
        }
        return this.getPart();
    }

    public boolean isEmpty() {
        return this.name.isEmpty();
    }

    public String getPart() {
        return this.isArrayElement() ? this.name + "[" + this.index + "]" : this.name;
    }

    public Path getContainer() {
        return new Path(this.root, null, null, this.depth, -1);
    }

    public Path getParent() {
        if (this.parent == null) {
            return new Path("");
        }
        return new Path(this.root, null, null, this.depth - 1, this.parent.index);
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isArrayElement() {
        return this.index >= 0;
    }

    public boolean matches(Path path) {
        return this.match(this.leaf(), path.leaf());
    }

    public boolean hasChild(Path path) {
        if (this.depth >= path.depth) {
            return false;
        }
        while (path.depth > this.depth) {
            path = path.parent;
        }
        return this.match(this, path);
    }

    public boolean isArrayElementOf(Path path) {
        return this.depth == path.depth && this.isArrayElement() && !path.isArrayElement() && this.name.equals(path.name) && this.match(this.parent, path.parent);
    }

    private boolean match(Path path, Path path2) {
        if (path == null && path2 == null) {
            return true;
        }
        if (path.depth != path2.depth) {
            return false;
        }
        if (!path.name.equals(path2.name)) {
            return false;
        }
        if (path.index != path2.index) {
            return false;
        }
        return this.match(path.parent, path2.parent);
    }

    private Path leaf() {
        if (this.child == null) {
            return this;
        }
        return this.child.leaf();
    }

    private static String[] convertRawPath(String string, boolean bl) throws InvalidPathException {
        if (string == null) {
            throw new InvalidPathException("Missing path parameter");
        }
        if (string.contains("//")) {
            throw new InvalidPathException("Path should not contain empty elements '//' " + string);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = string.split("/");
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return stringArray;
    }
}

