/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.cmmn.actorapi.event.CaseAppliedPlatformUpdate;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.PlanFragmentDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.PlanningTableDefinition;
import org.cafienne.cmmn.definition.StageDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.DiscretionaryItem;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.StateMachine;
import org.cafienne.cmmn.instance.TaskStage;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.util.Guid;
import org.w3c.dom.Element;

public class Stage<T extends StageDefinition>
extends TaskStage<T> {
    private final Collection<PlanItem<?>> planItems = new ArrayList();

    public Stage(String string, int n, ItemDefinition itemDefinition, T t, Stage<?> stage, Case case_) {
        this(string, n, itemDefinition, t, stage, case_, StateMachine.TaskStage);
    }

    protected Stage(String string, int n, ItemDefinition itemDefinition, T t, Stage<?> stage, Case case_, StateMachine stateMachine) {
        super(string, n, itemDefinition, t, case_, stage, stateMachine);
    }

    void register(PlanItem<?> planItem3) {
        if (this.getCaseInstance().recoveryRunning() && planItem3.getIndex() > 0) {
            this.planItems.stream().filter(planItem2 -> ((PlanItemDefinitionDefinition)planItem2.getDefinition()).equals(planItem3.getDefinition()) && planItem2.getIndex() + 1 == planItem3.getIndex()).forEach(planItem -> planItem.getEntryCriteria().release());
        }
        this.planItems.add(planItem3);
    }

    public Collection<PlanItem<?>> getPlanItems() {
        return this.planItems;
    }

    void planChild(DiscretionaryItem discretionaryItem, String string) {
        int n = Long.valueOf(this.planItems.stream().filter(planItem -> planItem.getItemDefinition().equals(discretionaryItem.getDefinition())).count()).intValue();
        this.addChild((ItemDefinition)discretionaryItem.getDefinition(), string, n, true);
    }

    PlanItem<?> repeatChild(PlanItem<?> planItem) {
        String string = new Guid().toString();
        ItemDefinition itemDefinition = planItem.getItemDefinition();
        int n = (int)this.getPlanItems().stream().map(PlanItem::getItemDefinition).filter(itemDefinition2 -> itemDefinition2.equals(itemDefinition)).count();
        this.addDebugInfo(() -> planItem + ": creating repeat item with index " + n + " and id " + string, new Object[0]);
        return this.addChild(itemDefinition, string, n, true);
    }

    private PlanItem<?> addChild(ItemDefinition itemDefinition, String string, int n, boolean bl) {
        if (this.getCaseInstance().recoveryRunning()) {
            return null;
        }
        PlanItemCreated planItemCreated = this.addEvent(new PlanItemCreated(this, itemDefinition, string, n));
        if (bl && this.getState().isActive()) {
            planItemCreated.getCreatedPlanItem().create();
        }
        return planItemCreated.getCreatedPlanItem();
    }

    private void instantiateChild(PlanItemDefinition planItemDefinition) {
        this.addChild(planItemDefinition, new Guid().toString(), 0, false);
    }

    private void createNullItems() {
        if (this.planItems.size() > 0) {
            this.addDebugInfo(() -> "Stage[" + this.getName() + "]: instantiating " + this.planItems.size() + " children having Null state. These are probably discretionary items that have been planned before the stage became active", new Object[0]);
            this.planItems.forEach(planItem -> this.addDebugInfo(() -> "Item[" + planItem.getName() + "." + planItem.getIndex() + "] in state " + planItem.getState(), new Object[0]));
        }
        this.planItems.stream().filter(planItem -> planItem.getState().isNull()).forEach(PlanItem::create);
    }

    @Override
    protected void startInstance() {
        ((StageDefinition)this.getDefinition()).getPlanItems().forEach(this::instantiateChild);
        this.createNullItems();
        if (this.getPlanItems().isEmpty()) {
            this.tryCompletion(new PlanItemTransitioned(this, State.Completed, State.Active, Transition.Complete));
        }
    }

    @Override
    protected void suspendInstance() {
        this.propagateTransition(Transition.ParentSuspend);
    }

    @Override
    protected void resumeInstance() {
        this.propagateTransition(Transition.ParentResume);
        this.createNullItems();
    }

    @Override
    protected void reactivateInstance() {
        super.reactivateInstance();
        this.createNullItems();
    }

    @Override
    protected void terminateInstance() {
        this.disconnectChildren(true);
    }

    @Override
    protected void completeInstance() {
        this.disconnectChildren(false);
    }

    void tryCompletion(PlanItemTransitioned planItemTransitioned) {
        if (this.getState().isSemiTerminal()) {
            this.addDebugInfo(() -> "---- " + this + " is in state " + this.getState() + ", hence skipping completion check for event " + planItemTransitioned, new Object[0]);
            return;
        }
        this.addDebugInfo(() -> "*** " + this + ": checking completion because of " + planItemTransitioned, new Object[0]);
        if (this.isCompletionAllowed(false)) {
            this.addDebugInfo(() -> "*** " + this + ": triggering stage completion", new Object[0]);
            this.makeTransition(Transition.Complete);
        }
    }

    private boolean isCompletionAllowed(boolean bl) {
        this.addDebugInfo(() -> {
            String string = this.getPlanItems().stream().map(planItem -> "\n*   - " + planItem.toDescription()).collect(Collectors.toList()).toString();
            return "*   checking " + this.planItems.size() + " plan items for completion:" + string;
        }, new Object[0]);
        for (PlanItem<?> planItem : this.planItems) {
            if (planItem.getState().isActive()) {
                this.addDebugInfo(() -> "*** " + this + " cannot auto complete, because '" + planItem.toDescription() + "' is still Active", new Object[0]);
                return false;
            }
            if (planItem.getState().isSemiTerminal()) continue;
            if (((StageDefinition)this.getDefinition()).autoCompletes() || bl) {
                if (!planItem.isRequired()) continue;
                this.addDebugInfo(() -> "*** " + this + " cannot auto complete, because " + planItem.toDescription() + " is required and has state " + planItem.getState(), new Object[0]);
                return false;
            }
            this.addDebugInfo(() -> "*** " + this + " cannot auto complete, because " + planItem.toDescription() + " has state " + planItem.getState(), new Object[0]);
            return false;
        }
        if (!((StageDefinition)this.getDefinition()).autoCompletes() && !bl && this.hasDiscretionaryItems()) {
            this.addDebugInfo(() -> "*** " + this + " cannot auto complete, because there are still discretionary items", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void validateTransition(Transition transition) {
        super.validateTransition(transition);
        if (transition == Transition.Complete && !this.isCompletionAllowed(true)) {
            throw new InvalidCommandException("Cannot complete the stage as there are active items remaining");
        }
    }

    @Override
    protected boolean hasDiscretionaryItems() {
        PlanningTableDefinition planningTableDefinition = ((StageDefinition)this.getDefinition()).getPlanningTable();
        if (planningTableDefinition != null && planningTableDefinition.hasItems(this)) {
            return true;
        }
        for (PlanItem<?> planItem : this.getPlanItems()) {
            if (!planItem.hasDiscretionaryItems()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void retrieveDiscretionaryItems(Collection<DiscretionaryItem> collection) {
        PlanningTableDefinition planningTableDefinition = ((StageDefinition)this.getDefinition()).getPlanningTable();
        if (planningTableDefinition != null) {
            this.addDebugInfo(() -> "Iterating planning table items in " + this, new Object[0]);
            planningTableDefinition.evaluate(this, collection);
        }
        this.getPlanItems().forEach(planItem -> planItem.retrieveDiscretionaryItems(collection));
    }

    private void disconnectChildren(boolean bl) {
        for (PlanItem<?> planItem : this.planItems) {
            if (bl) {
                planItem.makeTransition(planItem.getTerminationTransition());
            }
            planItem.getEntryCriteria().release();
            planItem.getExitCriteria().release();
        }
    }

    private void propagateTransition(Transition transition) {
        for (PlanItem<?> planItem : this.planItems) {
            planItem.makeTransition(transition);
        }
    }

    @Override
    protected void dumpImplementationToXML(Element element) {
        super.dumpImplementationToXML(element);
        for (PlanItem<?> planItem : this.planItems) {
            planItem.dumpMemoryStateToXML(element);
        }
        if (((StageDefinition)this.getDefinition()).getPlanningTable() != null) {
            element.appendChild(element.getOwnerDocument().createComment(" Planning table "));
            ((StageDefinition)this.getDefinition()).getPlanningTable().dumpMemoryStateToXML(element, this);
        }
    }

    public boolean contains(PlanItem<?> planItem) {
        if (planItem == null) {
            return false;
        }
        Stage<?> stage = planItem.getStage();
        if (stage == null) {
            return false;
        }
        if (stage == this) {
            return true;
        }
        return this.contains(stage);
    }

    @Override
    public void updateState(CaseAppliedPlatformUpdate caseAppliedPlatformUpdate) {
        this.planItems.forEach(planItem -> planItem.updateState(caseAppliedPlatformUpdate));
    }

    @Override
    public void migrateItemDefinition(ItemDefinition itemDefinition, T t) {
        super.migrateItemDefinition(itemDefinition, t);
        new ArrayList(this.planItems).forEach((Consumer<PlanItem<?>>)((Consumer<PlanItem>)this::migrateChild));
        if (this.getState().isAlive()) {
            ((PlanFragmentDefinition)t).getPlanItems().stream().filter(this::doesNotHaveChild).forEach(this::instantiateChild);
            this.createNullItems();
        }
    }

    private void migrateChild(PlanItem<?> planItem) {
        String string = planItem.getItemDefinition().getId();
        String string2 = planItem.getItemDefinition().getName();
        CMMNElementDefinition cMMNElementDefinition = ((StageDefinition)this.getDefinition()).getPlanItem(string);
        if (cMMNElementDefinition == null && (cMMNElementDefinition = ((StageDefinition)this.getDefinition()).getPlanItem(string2)) == null && (cMMNElementDefinition = ((StageDefinition)this.getDefinition()).getDiscretionaryItem(string)) == null) {
            cMMNElementDefinition = ((StageDefinition)this.getDefinition()).getDiscretionaryItem(string2);
        }
        if (cMMNElementDefinition != null) {
            this.migrateChild(planItem, (ItemDefinition)((Object)cMMNElementDefinition));
        } else {
            this.dropChild(planItem);
        }
    }

    private boolean doesNotHaveChild(PlanItemDefinition planItemDefinition) {
        boolean bl = this.getPlanItems().stream().noneMatch(planItem -> planItem.getItemDefinition().getId().equals(planItemDefinition.getId()) || planItem.getName().equals(planItemDefinition.getName()));
        if (bl) {
            this.addDebugInfo(() -> this + ": migration found a new child definition " + planItemDefinition.getName() + " of type " + planItemDefinition.getType(), new Object[0]);
        }
        return bl;
    }

    private void dropChild(PlanItem<?> planItem) {
        if (this.getCaseInstance().recoveryRunning()) {
            return;
        }
        planItem.lostDefinition();
    }

    @Override
    protected void lostDefinition() {
        new ArrayList(this.planItems).forEach((Consumer<PlanItem<?>>)((Consumer<PlanItem>)PlanItem::lostDefinition));
        super.lostDefinition();
    }

    private void migrateChild(PlanItem planItem, ItemDefinition itemDefinition) {
        this.addDebugInfo(() -> this + ": migrating child " + planItem + " to a new definition", new Object[0]);
        Object t = planItem.getDefinition();
        PlanItemDefinitionDefinition planItemDefinitionDefinition = itemDefinition.getPlanItemDefinition();
        if (t.getClass().isAssignableFrom(planItemDefinitionDefinition.getClass())) {
            planItem.migrateItemDefinition(itemDefinition, planItemDefinitionDefinition);
        } else {
            this.addDebugInfo(() -> "Not possible to migrate from " + t.getType() + " to " + planItemDefinitionDefinition.getType(), new Object[0]);
        }
    }

    void removeDroppedPlanItem(PlanItem<?> planItem) {
        this.planItems.remove(planItem);
    }
}

