/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.util.HashMap;
import java.util.Map;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.Transition;

class StateMachine {
    private final Map<State, Map<Transition, Target>> transitions = new HashMap<State, Map<Transition, Target>>();
    private final Map<State, Target> states = new HashMap<State, Target>();
    final Transition exitTransition;
    final Transition terminationTransition;
    static final StateMachine EventMilestone = new StateMachine(Transition.Exit, Transition.ParentTerminate);
    static final StateMachine TaskStage;
    static final StateMachine CasePlan;

    private StateMachine(Transition transition, Transition transition2) {
        this.exitTransition = transition;
        this.terminationTransition = transition2;
        for (State state : State.values()) {
            this.getTarget(state);
            this.getTransitions(state);
        }
    }

    private void addTransition(Transition transition, State state, State ... stateArray) {
        for (State state2 : stateArray) {
            Map<Transition, Target> map = this.getTransitions(state2);
            map.put(transition, this.getTarget(state));
        }
    }

    private void setAction(State state, Action action) {
        this.getTarget((State)state).action = action;
    }

    private Target getTarget(State state) {
        Target target = this.states.get((Object)state);
        if (target == null) {
            target = new Target(state);
            this.states.put(state, target);
        }
        return target;
    }

    private Map<Transition, Target> getTransitions(State state) {
        Map<Transition, Target> map = this.transitions.get((Object)state);
        if (map == null) {
            map = new HashMap<Transition, Target>();
            this.transitions.put(state, map);
        }
        return map;
    }

    PlanItemTransitioned transition(PlanItem<?> planItem, Transition transition) {
        State state = planItem.getState();
        Map<Transition, Target> map = this.transitions.get((Object)state);
        Target target = map.get((Object)transition);
        if (target != null) {
            if (target.state == null) {
                target = this.getTarget(planItem.getHistoryState());
            }
            return new PlanItemTransitioned(planItem, target.state, state, transition);
        }
        return null;
    }

    Action getAction(State state) {
        return this.getTarget((State)state).action;
    }

    static {
        EventMilestone.addTransition(Transition.Create, State.Available, State.Null);
        EventMilestone.addTransition(Transition.Suspend, State.Suspended, State.Available);
        EventMilestone.addTransition(Transition.ParentSuspend, State.Suspended, State.Available);
        EventMilestone.addTransition(Transition.Terminate, State.Terminated, State.Available);
        EventMilestone.addTransition(Transition.Occur, State.Completed, State.Available);
        EventMilestone.addTransition(Transition.Resume, State.Available, State.Suspended);
        EventMilestone.addTransition(Transition.ParentResume, State.Available, State.Suspended);
        EventMilestone.addTransition(Transition.ParentTerminate, State.Terminated, State.Available, State.Suspended);
        EventMilestone.setAction(State.Completed, (planItem, transition) -> planItem.completeInstance());
        EventMilestone.setAction(State.Terminated, (planItem, transition) -> planItem.terminateInstance());
        EventMilestone.setAction(State.Suspended, (planItem, transition) -> planItem.suspendInstance());
        EventMilestone.setAction(State.Available, (planItem, transition) -> {
            if (transition == Transition.Create) {
                planItem.createInstance();
            } else if (transition == Transition.Resume || transition == Transition.ParentResume) {
                planItem.resumeInstance();
            }
        });
        TaskStage = new StateMachine(Transition.Exit, Transition.Exit);
        TaskStage.addTransition(Transition.Create, State.Available, State.Null);
        TaskStage.addTransition(Transition.Enable, State.Enabled, State.Available);
        TaskStage.addTransition(Transition.Start, State.Active, State.Available);
        TaskStage.addTransition(Transition.Disable, State.Disabled, State.Enabled);
        TaskStage.addTransition(Transition.ManualStart, State.Active, State.Enabled);
        TaskStage.addTransition(Transition.Suspend, State.Suspended, State.Active);
        TaskStage.addTransition(Transition.Fault, State.Failed, State.Active);
        TaskStage.addTransition(Transition.Complete, State.Completed, State.Active);
        TaskStage.addTransition(Transition.Terminate, State.Terminated, State.Active);
        TaskStage.addTransition(Transition.Exit, State.Terminated, State.Available, State.Active, State.Enabled, State.Disabled, State.Suspended, State.Failed);
        TaskStage.addTransition(Transition.Resume, State.Active, State.Suspended);
        TaskStage.addTransition(Transition.Reactivate, State.Active, State.Failed);
        TaskStage.addTransition(Transition.Reenable, State.Enabled, State.Disabled);
        TaskStage.addTransition(Transition.ParentSuspend, State.Suspended, State.Available, State.Active, State.Enabled, State.Disabled);
        TaskStage.addTransition(Transition.ParentResume, null, State.Suspended);
        TaskStage.setAction(State.Available, (planItem, transition) -> planItem.createInstance());
        TaskStage.setAction(State.Active, (planItem, transition) -> {
            if (transition == Transition.Start || transition == Transition.ManualStart) {
                planItem.startInstance();
            } else if (transition == Transition.Resume || transition == Transition.ParentResume) {
                planItem.resumeInstance();
            } else if (transition == Transition.Reactivate) {
                planItem.reactivateInstance();
            }
        });
        TaskStage.setAction(State.Enabled, (planItem, transition) -> planItem.makeTransition(Transition.Start));
        TaskStage.setAction(State.Suspended, (planItem, transition) -> planItem.suspendInstance());
        TaskStage.setAction(State.Completed, (planItem, transition) -> {
            planItem.completeInstance();
            if (planItem.getEntryCriteria().isEmpty()) {
                planItem.repeat("the item completed");
            }
        });
        TaskStage.setAction(State.Terminated, (planItem, transition) -> {
            planItem.terminateInstance();
            if (planItem.getEntryCriteria().isEmpty()) {
                planItem.repeat("the item terminated");
            }
        });
        TaskStage.setAction(State.Failed, (planItem, transition) -> planItem.failInstance());
        CasePlan = new StateMachine(Transition.Terminate, Transition.Exit);
        CasePlan.addTransition(Transition.Create, State.Active, State.Null);
        CasePlan.addTransition(Transition.Suspend, State.Suspended, State.Active);
        CasePlan.addTransition(Transition.Terminate, State.Terminated, State.Active);
        CasePlan.addTransition(Transition.Complete, State.Completed, State.Active);
        CasePlan.addTransition(Transition.Fault, State.Failed, State.Active);
        CasePlan.addTransition(Transition.Reactivate, State.Active, State.Completed, State.Terminated, State.Failed, State.Suspended);
        CasePlan.addTransition(Transition.Close, State.Closed, State.Completed, State.Terminated, State.Failed, State.Suspended);
        CasePlan.setAction(State.Suspended, (planItem, transition) -> planItem.suspendInstance());
        CasePlan.setAction(State.Completed, (planItem, transition) -> planItem.completeInstance());
        CasePlan.setAction(State.Terminated, (planItem, transition) -> planItem.terminateInstance());
        CasePlan.setAction(State.Failed, (planItem, transition) -> planItem.failInstance());
        CasePlan.setAction(State.Active, (planItem, transition) -> {
            if (transition == Transition.Create) {
                planItem.startInstance();
            } else {
                planItem.resumeInstance();
            }
        });
    }

    private class Target {
        private final State state;
        private Action action;

        private Target(State state) {
            this.state = state;
            this.action = (planItem, transition) -> {};
        }
    }

    @FunctionalInterface
    static interface Action {
        public void execute(PlanItem<?> var1, Transition var2);
    }
}

