/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.casefile;

import java.util.List;
import java.util.Map;
import org.cafienne.cmmn.definition.casefile.CaseFileDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileError;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItemCollection;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CaseFile
extends CaseFileItemCollection<CaseFileDefinition> {
    public CaseFile(Case case_, CaseFileDefinition caseFileDefinition) {
        super(case_, caseFileDefinition, null);
    }

    public List<CaseFileItem> getCaseFileItems() {
        return this.getItems();
    }

    private ValueMap validateValueMap(Value<?> value) {
        if (value.isMap()) {
            value.asMap().fieldNames().forEachRemaining(string -> {
                if (this.getItem((String)string) == null) {
                    throw new CaseFileError("A case file item with name '" + string + "' is not defined");
                }
            });
            return value.asMap();
        }
        throw new CaseFileError("Operations on entire case file need a JSON object structure");
    }

    @Override
    public void createContent(Value<?> value) {
        ((Map)this.validateValueMap(value).getValue()).entrySet().forEach(entry -> this.getItem((String)entry.getKey()).createContent((Value)entry.getValue()));
    }

    @Override
    public void deleteContent() {
        this.getItems().forEach(CaseFileItem::deleteContent);
    }

    @Override
    public void replaceContent(Value<?> value) {
        ValueMap valueMap = this.validateValueMap(value);
        ((Map)valueMap.getValue()).entrySet().forEach(entry -> this.getItem((String)entry.getKey()).replaceContent((Value)entry.getValue()));
        this.removeReplacedItems(valueMap);
    }

    @Override
    public void updateContent(Value<?> value) {
        ((Map)this.validateValueMap(value).getValue()).entrySet().forEach(entry -> this.getItem((String)entry.getKey()).updateContent((Value)entry.getValue()));
    }

    @Override
    public void validateTransition(CaseFileItemTransition caseFileItemTransition, Value<?> value) {
        if (caseFileItemTransition == CaseFileItemTransition.Delete) {
            return;
        }
        ((Map)this.validateValueMap(value).getValue()).entrySet().stream().forEach(entry -> {
            String string = (String)entry.getKey();
            Value value = (Value)entry.getValue();
            CaseFileItem caseFileItem = this.getItem(string);
            if (caseFileItem == null) {
                throw new CaseFileError("Item '" + string + "' is not found in the Case File definition");
            }
            caseFileItem.validateTransition(caseFileItemTransition, value);
        });
    }

    public ValueMap toJson() {
        ValueMap valueMap = new ValueMap();
        this.getItems().forEach(caseFileItem -> valueMap.put(caseFileItem.getName(), caseFileItem.getValue()));
        return valueMap;
    }

    public void dumpMemoryStateToXML(Element element) {
        Element element2 = element.getOwnerDocument().createElement("CaseFile");
        element.appendChild(element2);
        this.getCaseFileItems().forEach(caseFileItem -> caseFileItem.dumpMemoryStateToXML(element2));
    }

    @Override
    public void migrateDefinition(CaseFileDefinition caseFileDefinition) {
        this.addDebugInfo(() -> "\nMigrating Case File", new Object[0]);
        super.migrateDefinition(caseFileDefinition);
        this.addDebugInfo(() -> "Completed Case File migration\n", new Object[0]);
    }

    @Override
    public String toString() {
        Document document;
        try {
            document = XMLHelper.loadXML("<CaseFile />");
            this.dumpMemoryStateToXML(document.getDocumentElement());
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot parse xml???", exception);
        }
        String string = XMLHelper.printXMLNode(document.getDocumentElement().getFirstChild());
        return string;
    }
}

