/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.casefile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cafienne.cmmn.actorapi.event.file.BusinessIdentifierEvent;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemCreated;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemDeleted;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemReplaced;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemTransitioned;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemUpdated;
import org.cafienne.cmmn.actorapi.event.migration.CaseFileItemDropped;
import org.cafienne.cmmn.actorapi.event.migration.CaseFileItemMigrated;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileError;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.definition.casefile.PropertyDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.casefile.BootstrapCaseFileTransitionPublisher;
import org.cafienne.cmmn.instance.casefile.BusinessIdentifier;
import org.cafienne.cmmn.instance.casefile.CaseFileItemArray;
import org.cafienne.cmmn.instance.casefile.CaseFileItemCollection;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.cafienne.cmmn.instance.casefile.CaseFileTransitionPublisher;
import org.cafienne.cmmn.instance.sentry.CaseFileItemOnPart;
import org.cafienne.cmmn.instance.sentry.TransitionGenerator;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.w3c.dom.Element;

public class CaseFileItem
extends CaseFileItemCollection<CaseFileItemDefinition>
implements TransitionGenerator<CaseFileItemTransitioned> {
    protected CaseFileTransitionPublisher transitionPublisher;
    private State state = State.Null;
    private CaseFileItemTransition lastTransition;
    private Value<?> value = Value.NULL;
    private final Map<String, BusinessIdentifier> businessIdentifiers = new HashMap<String, BusinessIdentifier>();
    private final CaseFileItem parent;
    private final CaseFileItem container;
    private int indexInArray;
    private final boolean isArray;

    private CaseFileItem(Case case_, CaseFileItemDefinition caseFileItemDefinition, CaseFileItemCollection<?> caseFileItemCollection, CaseFileItemArray caseFileItemArray, int n, boolean bl) {
        super(case_, caseFileItemDefinition, caseFileItemCollection);
        this.parent = caseFileItemCollection instanceof CaseFileItem ? (CaseFileItem)caseFileItemCollection : null;
        this.container = caseFileItemArray == null ? this : caseFileItemArray;
        this.indexInArray = n;
        this.transitionPublisher = this.createTransitionPublisher();
        this.isArray = bl;
        for (PropertyDefinition propertyDefinition : caseFileItemDefinition.getBusinessIdentifiers()) {
            this.businessIdentifiers.put(propertyDefinition.getName(), new BusinessIdentifier(this, propertyDefinition));
        }
        this.getCaseInstance().getSentryNetwork().connect(this);
    }

    protected CaseFileItem(CaseFileItemArray caseFileItemArray, int n) {
        this(caseFileItemArray.getCaseInstance(), (CaseFileItemDefinition)caseFileItemArray.getDefinition(), caseFileItemArray.getParent(), caseFileItemArray, n, false);
    }

    protected CaseFileItem(CaseFileItemDefinition caseFileItemDefinition, Case case_, CaseFileItemCollection<?> caseFileItemCollection) {
        this(case_, caseFileItemDefinition, caseFileItemCollection, null, -1, true);
    }

    public CaseFileItem(Case case_, CaseFileItemDefinition caseFileItemDefinition, CaseFileItemCollection<?> caseFileItemCollection) {
        this(case_, caseFileItemDefinition, caseFileItemCollection, null, -1, false);
    }

    @Override
    public void releaseBootstrapEvents() {
        this.transitionPublisher = new CaseFileTransitionPublisher(this.getPublisher());
        super.releaseBootstrapEvents();
    }

    private CaseFileTransitionPublisher createTransitionPublisher() {
        if (this.getCaseInstance().getCasePlan() == null) {
            if (this.container.getPublisher() == null) {
                this.container.transitionPublisher = new BootstrapCaseFileTransitionPublisher(this.container);
            }
            return this.container.getPublisher();
        }
        return new CaseFileTransitionPublisher(this);
    }

    public CaseFileItem getParent() {
        return this.parent;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public <C extends CaseFileItem> C getContainer() {
        return (C)this.container;
    }

    public void connectOnPart(CaseFileItemOnPart caseFileItemOnPart) {
        this.getPublisher().connectOnPart(caseFileItemOnPart);
    }

    public void releaseOnPart(CaseFileItemOnPart caseFileItemOnPart) {
        this.getPublisher().releaseOnPart(caseFileItemOnPart);
    }

    private void addCaseFileEvent(CaseFileItemTransitioned caseFileItemTransitioned) {
        if (caseFileItemTransitioned.getValue().isMap()) {
            this.businessIdentifiers.values().forEach(businessIdentifier -> businessIdentifier.update(caseFileItemTransitioned.getValue().asMap()));
        }
        super.addEvent(caseFileItemTransitioned);
    }

    private void addDeletedEvent(CaseFileItemDeleted caseFileItemDeleted) {
        this.businessIdentifiers.values().forEach(BusinessIdentifier::clear);
        super.addEvent(caseFileItemDeleted);
    }

    public void publishTransition(CaseFileItemTransitioned caseFileItemTransitioned) {
        this.addDebugInfo(() -> "CaseFile[" + this.getName() + "]: updating CaseFileItem state based on CaseFileEvent", new Object[0]);
        this.getPublisher().addEvent(caseFileItemTransitioned);
    }

    @Override
    public void updateStandardEvent(CaseFileItemTransitioned caseFileItemTransitioned) {
        CaseFileItem caseFileItem = this instanceof CaseFileItemArray ? ((CaseFileItemArray)this).get(caseFileItemTransitioned.getIndex()) : this;
        caseFileItem.setState(caseFileItemTransitioned.getState());
        caseFileItem.indexInArray = caseFileItemTransitioned.getIndex();
        caseFileItem.lastTransition = caseFileItemTransitioned.getTransition();
        caseFileItem.setValue(caseFileItemTransitioned.getValue());
    }

    public void publishTransition(BusinessIdentifierEvent businessIdentifierEvent) {
        this.businessIdentifiers.get(businessIdentifierEvent.name).updateState(businessIdentifierEvent);
    }

    public void informConnectedEntryCriteria(CaseFileItemTransitioned caseFileItemTransitioned) {
        this.getPublisher().informEntryCriteria(caseFileItemTransitioned);
    }

    public void informConnectedExitCriteria(CaseFileItemTransitioned caseFileItemTransitioned) {
        this.getPublisher().informExitCriteria(caseFileItemTransitioned);
        this.addDebugInfo(() -> this.getDescription() + ": Completed behavior for transition " + caseFileItemTransitioned.getTransition(), new Object[0]);
    }

    @Override
    public void createContent(Value<?> value2) {
        this.generateContentWarnings(value2, "Create");
        this.addCaseFileEvent(new CaseFileItemCreated(this, value2));
        if (value2.isMap()) {
            ((Map)value2.asMap().getValue()).forEach((string, value) -> {
                CaseFileItem caseFileItem = this.getItem((String)string);
                if (caseFileItem != null) {
                    caseFileItem.createContent(value.cloneValueNode());
                }
            });
        }
    }

    @Override
    public void replaceContent(Value<?> value) {
        if (value.equals(this.value)) {
            this.addDebugInfo(() -> "Replace on CaseFileItem[" + this.getPath() + "] does not contain changes", new Object[0]);
            return;
        }
        this.generateContentWarnings(value, "Replace");
        if (value == Value.NULL) {
            ((CaseFileItemDefinition)this.getDefinition()).getChildren().forEach(caseFileItemDefinition -> {
                CaseFileItem caseFileItem = this.getItem(caseFileItemDefinition.getName());
                if (caseFileItem.getState().isAvailable()) {
                    caseFileItem.deleteContent();
                }
            });
        } else if (value.isMap()) {
            ValueMap valueMap = value.asMap();
            ((CaseFileItemDefinition)this.getDefinition()).getChildren().forEach(caseFileItemDefinition -> {
                String string = caseFileItemDefinition.getName();
                if (valueMap.has(string)) {
                    Value<?> value = valueMap.get(string);
                    CaseFileItem caseFileItem = this.getItem(string);
                    if (caseFileItem.getState().isAvailable()) {
                        caseFileItem.replaceContent(value);
                    } else if (caseFileItem.getState().isNull() && valueMap.has(string)) {
                        caseFileItem.createContent(valueMap.get(string));
                    }
                }
            });
            this.removeReplacedItems(valueMap);
        }
        this.addCaseFileEvent(new CaseFileItemReplaced(this, value));
    }

    private void generateContentWarnings(Value<?> value, String string) {
        this.addDebugInfo(() -> {
            if (value.isMap()) {
                List list = ((Map)value.asMap().getValue()).keySet().stream().filter(this::isUndefined).collect(Collectors.toList());
                if (list.size() == 1) {
                    return string + " on CaseFileItem[" + this.getPath() + "] contains undefined property '" + (String)list.get(0) + "'";
                }
                if (list.size() > 1) {
                    return string + " on CaseFileItem[" + this.getPath() + "] contains undefined properties " + list.stream().map(string -> "'" + string + "'").collect(Collectors.joining(", "));
                }
            } else if (((CaseFileItemDefinition)this.getDefinition()).getCaseFileItemDefinition().getProperties().size() > 0) {
                return string + " on CaseFileItem[" + this.getPath() + "] is done with a value of type " + value.getValue().getClass().getSimpleName() + "; a Map<Name,Value> is expected instead.";
            }
            return "";
        }, new Object[0]);
    }

    @Override
    public void updateContent(Value<?> value2) {
        if (this.value.isSupersetOf(value2)) {
            this.addDebugInfo(() -> "Update on CaseFileItem[" + this.getPath() + "] does not contain changes", new Object[0]);
            return;
        }
        if (this.getState().isNull()) {
            this.createContent(value2);
            return;
        }
        if (!value2.isMap() || !this.value.isMap()) {
            this.addDebugInfo(() -> {
                if (value2.isMap()) {
                    return "Update on CaseFileItem[" + this.getPath() + "] overwrites value of type " + this.value.getClass().getSimpleName() + " with a ValueMap";
                }
                if (value2.isList() && this.container != this) {
                    return "Update on CaseFileItem[" + this.getPath() + "] is overwritten with a list. This seems to be an error on passing the path, but it is accepted";
                }
                if (!((CaseFileItemDefinition)this.getDefinition()).getCaseFileItemDefinition().getProperties().isEmpty()) {
                    return "Update on CaseFileItem[" + this.getPath() + "] overwrites existing properties with a single " + this.value.getClass().getSimpleName() + ". This seems to be an error, but it is accepted";
                }
                return "Update on CaseFileItem[" + this.getPath() + "] overwrites a " + this.value.getClass().getSimpleName() + " with a " + value2.getClass().getSimpleName();
            }, new Object[0]);
            Value<?> value3 = this.value.cloneValueNode().merge(value2);
            this.addCaseFileEvent(new CaseFileItemUpdated(this, value3));
            return;
        }
        ValueMap valueMap = value2.asMap();
        ValueMap valueMap2 = this.value.asMap();
        ((CaseFileItemDefinition)this.getDefinition()).getChildren().stream().map(XMLElementDefinition::getName).forEach(string -> {
            if (valueMap.has(string)) {
                Value<?> value = valueMap.get(string);
                CaseFileItem caseFileItem = this.getItem((String)string);
                Value<?> value2 = caseFileItem.getValue();
                if (!value2.isSupersetOf(value)) {
                    caseFileItem.updateContent(value);
                }
            }
        });
        ValueMap valueMap3 = new ValueMap();
        ((Map)valueMap.getValue()).forEach((string, value) -> {
            if (this.getItem((String)string) != null) {
                return;
            }
            Value<?> value2 = valueMap2.get(string);
            if (!value2.isSupersetOf((Value<?>)value)) {
                if (((CaseFileItemDefinition)this.getDefinition()).getCaseFileItemDefinition().getProperties().get(string) == null) {
                    this.addDebugInfo(() -> "Update on CaseFileItem[" + this.getPath() + "] contains property '" + string + "'. This property is NOT DEFINED in the CaseDefinition", new Object[0]);
                }
                valueMap3.put(string, (Value<?>)value);
            }
        });
        if (!((Map)valueMap3.getValue()).isEmpty()) {
            this.addDebugInfo(() -> "Update on CaseFileItem[" + this.getPath() + "] contains changes in properties " + ((Map)valueMap3.getValue()).keySet().stream().map(string -> "'" + string + "'").collect(Collectors.joining(", ")), new Object[0]);
            ValueMap valueMap4 = this.value.cloneValueNode().merge(valueMap3);
            this.addCaseFileEvent(new CaseFileItemUpdated(this, valueMap4));
        } else {
            this.addDebugInfo(() -> "Update on CaseFileItem[" + this.getPath() + "] has no property changes", new Object[0]);
        }
    }

    @Override
    public void deleteContent() {
        this.getItems().stream().filter(caseFileItem -> caseFileItem.getState().isAvailable()).forEach(CaseFileItem::deleteContent);
        if (this.getState() != State.Discarded) {
            this.addDeletedEvent(new CaseFileItemDeleted(this));
        }
    }

    protected void setValue(Value<?> value) {
        this.addDebugInfo(() -> "Setting case file item [" + this.getPath() + "] value to: ", value);
        this.value.clearOwner();
        this.value = value;
        this.value.setOwner(this);
        this.container.itemChanged(this);
        this.propagateValueChangeToParent(this.getName(), this.container.getValue());
    }

    protected void itemChanged(CaseFileItem caseFileItem) {
    }

    protected void itemRemoved(int n) {
    }

    private void propagateValueChangeToParent(String string, Value<?> value) {
        if (this.parent != null) {
            if (this.parent.value == null || this.parent.value == Value.NULL) {
                this.addDebugInfo(() -> "Creating a location in parent " + this.parent.getPath() + " to store the newly changed child " + this.getName(), new Object[0]);
                this.parent.setValue(new ValueMap(string, value));
            } else if (this.parent.value.isMap()) {
                ValueMap valueMap = this.parent.value.asMap();
                if (valueMap.get(string) != value) {
                    valueMap.put(string, value);
                }
            } else {
                this.addDebugInfo(() -> "Cannot propagate change in " + this.getPath() + " into parent, because it's value is not a ValueMap but a " + this.parent.value.getClass().getName(), new Object[0]);
            }
        }
    }

    public Value<?> getValue() {
        return this.value;
    }

    public CaseFileItemTransition getLastTransition() {
        return this.lastTransition;
    }

    @Override
    public Path getPath() {
        return new Path(this);
    }

    @Override
    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public CaseFileTransitionPublisher getPublisher() {
        return this.transitionPublisher;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    public void dumpMemoryStateToXML(Element element) {
        Element element2 = element.getOwnerDocument().createElement("CaseFileItem");
        element.appendChild(element2);
        element2.setAttribute("name", ((CaseFileItemDefinition)this.getDefinition()).getName());
        element2.setAttribute("transition", "" + this.lastTransition);
        if (this.indexInArray >= 0) {
            element2.setAttribute("index", "" + this.indexInArray);
        }
        Element element3 = element.getOwnerDocument().createElement("Content");
        element2.appendChild(element3);
        this.value.dumpMemoryStateToXML(element3);
        this.getItems().forEach(caseFileItem -> caseFileItem.dumpMemoryStateToXML(element2));
    }

    public CaseFileItem getCurrent() {
        return this;
    }

    @Override
    public int getIndex() {
        return this.indexInArray;
    }

    @Override
    public void validateTransition(CaseFileItemTransition caseFileItemTransition, Value<?> value) {
        if (this.parent != null && (this.parent.getState().isDiscarded() || this.parent.getState().isNull())) {
            throw new CaseFileError(caseFileItemTransition + "CaseFileItem[" + this.getPath() + "] cannot be done because the parent is in state " + this.parent.getState());
        }
        if (!this.allowTransition(caseFileItemTransition)) {
            throw new CaseFileError(caseFileItemTransition + "CaseFileItem[" + this.getPath() + "] cannot be done because item is in state " + this.getState());
        }
        ((CaseFileItemDefinition)this.getDefinition()).validatePropertyTypes(value);
    }

    protected boolean allowTransition(CaseFileItemTransition caseFileItemTransition) {
        switch (this.getState()) {
            case Null: {
                return caseFileItemTransition == CaseFileItemTransition.Create || caseFileItemTransition == CaseFileItemTransition.Update || caseFileItemTransition == CaseFileItemTransition.Replace;
            }
            case Available: {
                return caseFileItemTransition == CaseFileItemTransition.Update || caseFileItemTransition == CaseFileItemTransition.Replace || caseFileItemTransition == CaseFileItemTransition.Delete;
            }
        }
        this.addDebugInfo(() -> "CFI[" + this.getPath() + "] is in state " + this.getState() + " and then we cannot do transition " + caseFileItemTransition, new Object[0]);
        return false;
    }

    @Override
    public void migrateDefinition(CaseFileItemDefinition caseFileItemDefinition) {
        this.addDebugInfo(() -> "=== Migrating CaseFileItem[" + this.getPath() + "] to a new definition", new Object[0]);
        super.migrateDefinition(caseFileItemDefinition);
        this.migrateIdentifiers(caseFileItemDefinition);
        this.addDebugInfo(() -> "=== Completed migration of CaseFileItem[" + this.getPath() + "]\n", new Object[0]);
    }

    private void migrateIdentifiers(CaseFileItemDefinition caseFileItemDefinition) {
        HashMap<String, BusinessIdentifier> hashMap = new HashMap<String, BusinessIdentifier>(this.businessIdentifiers);
        caseFileItemDefinition.getBusinessIdentifiers().forEach(propertyDefinition -> {
            String string = propertyDefinition.getName();
            BusinessIdentifier businessIdentifier = this.businessIdentifiers.get(string);
            if (businessIdentifier == null) {
                BusinessIdentifier businessIdentifier2 = new BusinessIdentifier(this, (PropertyDefinition)propertyDefinition);
                this.businessIdentifiers.put(string, businessIdentifier2);
                if (this.getValue().isMap()) {
                    businessIdentifier2.update(this.getValue().asMap());
                }
            } else {
                businessIdentifier.migrateDefinition(propertyDefinition);
                hashMap.remove(string);
            }
        });
        hashMap.values().forEach(BusinessIdentifier::lostDefinition);
    }

    protected void lostDefinition() {
        this.getItems().forEach(CaseFileItem::lostDefinition);
        this.addEvent(new CaseFileItemDropped(this));
    }

    @Override
    protected void childDropped(CaseFileItem caseFileItem) {
        super.childDropped(caseFileItem);
        if (this.value.isMap()) {
            ((Map)this.value.asMap().getValue()).remove(caseFileItem.getName());
        }
    }

    public void updateState(CaseFileItemDropped caseFileItemDropped) {
        this.host.childDropped(this);
        this.businessIdentifiers.values().forEach(BusinessIdentifier::lostDefinition);
        this.getCaseInstance().getSentryNetwork().disconnect(this);
    }

    public void updateState(CaseFileItemMigrated caseFileItemMigrated) {
        if (this.parent != null) {
            this.parent.renameChildItem(caseFileItemMigrated.formerPath.getName(), caseFileItemMigrated.path.getName());
        }
    }

    public void migrateName(CaseFileItemDefinition caseFileItemDefinition) {
        this.addEvent(new CaseFileItemMigrated(this));
    }

    @Override
    protected void renameChildItem(String string, String string2) {
        if (this.getValue().isMap()) {
            ValueMap valueMap = this.getValue().asMap();
            Value<?> value = valueMap.get(string);
            valueMap.put(string2, value);
            ((Map)valueMap.getValue()).remove(string);
        }
    }
}

