/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.sentry;

import java.util.ArrayList;
import java.util.Collection;
import org.cafienne.cmmn.definition.sentry.ExitCriterionDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.cmmn.instance.sentry.StandardEvent;
import org.cafienne.cmmn.instance.sentry.TransitionCallStack;
import org.cafienne.cmmn.instance.sentry.TransitionPublisher;

public class SentryNetwork {
    private final Case caseInstance;
    private final TransitionCallStack callStack = new TransitionCallStack(this);
    private final Collection<Criterion<?>> criteria = new ArrayList();

    public SentryNetwork(Case case_) {
        this.caseInstance = case_;
    }

    public void connect(CaseFileItem caseFileItem) {
        for (Criterion<?> criterion : this.criteria) {
            criterion.establishPotentialConnection(caseFileItem);
        }
    }

    public void disconnect(CaseFileItem caseFileItem) {
        this.criteria.forEach(criterion -> criterion.removeConnection(caseFileItem));
    }

    public void connect(PlanItem<?> planItem) {
        for (Criterion<?> criterion : this.criteria) {
            criterion.establishPotentialConnection(planItem);
        }
        planItem.getEntryCriteria().connect();
        planItem.getExitCriteria().connect();
    }

    public void disconnect(PlanItem<?> planItem) {
        this.criteria.forEach(criterion -> criterion.removeConnection(planItem));
    }

    void add(Criterion<?> criterion) {
        this.criteria.add(criterion);
    }

    void remove(Criterion<?> criterion) {
        this.criteria.remove(criterion);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SentryNetwork has " + this.criteria.size() + " criteria:");
        this.criteria.forEach(criterion -> stringBuilder.append("\n\t- " + criterion));
        return stringBuilder.toString() + "\n";
    }

    Criterion<?> findRelatedExitCriterion(PlanItem<?> planItem, ExitCriterionDefinition exitCriterionDefinition) {
        for (Criterion<?> criterion : this.criteria) {
            if (!criterion.getDefinition().equals(exitCriterionDefinition) || criterion.getTarget() != planItem) continue;
            return criterion;
        }
        return null;
    }

    public void handleTransition(StandardEvent standardEvent, TransitionPublisher transitionPublisher) {
        if (this.caseInstance.recoveryRunning()) {
            return;
        }
        this.callStack.pushEvent(standardEvent);
    }
}

