/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions;

import java.util.stream.Stream;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.instance.PlanItemType;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.test.CaseTestCommand;
import org.cafienne.cmmn.test.assertions.PlanItemAssertion;
import org.cafienne.cmmn.test.assertions.PlanItemSetAssertion;
import org.cafienne.cmmn.test.assertions.PublishedEventsAssertion;
import org.cafienne.cmmn.test.assertions.TaskAssertion;
import org.cafienne.cmmn.test.filter.EventFilter;

public class StageAssertion
extends PlanItemAssertion {
    StageAssertion(CaseTestCommand caseTestCommand, PlanItemCreated planItemCreated) {
        super(caseTestCommand, planItemCreated);
        if (planItemCreated != null) {
            this.assertType(PlanItemType.Stage, PlanItemType.CasePlan);
        }
    }

    public StageAssertion assertStage(String string) {
        return new StageAssertion(this.testCommand, this.getPlanItem("stage", string));
    }

    public TaskAssertion assertTask(String string) {
        return new TaskAssertion(this.testCommand, this.getPlanItem("task", string));
    }

    public TaskAssertion assertHumanTask(String string) {
        return new TaskAssertion(this.testCommand, this.getPlanItem("task", string));
    }

    public PlanItemAssertion assertPlanItem(String string) {
        return new PlanItemAssertion(this.testCommand, this.getPlanItem("plan item", string));
    }

    public PlanItemAssertion assertPlanItem(String string, State state) {
        return this.assertPlanItems(string, state).assertSize(1).first();
    }

    public PlanItemSetAssertion assertPlanItems(String string) {
        PlanItemSetAssertion planItemSetAssertion = new PlanItemSetAssertion(string);
        this.getPlanItems(string).forEach(planItemCreated -> {
            PlanItemAssertion planItemAssertion = new PlanItemAssertion(this.testCommand, (PlanItemCreated)planItemCreated);
            planItemSetAssertion.add(planItemAssertion);
        });
        return planItemSetAssertion;
    }

    public PlanItemSetAssertion assertPlanItems(String string, State state) {
        return this.assertPlanItems(string).filter(state);
    }

    private PlanItemCreated getPlanItem(String string, String string2) {
        PlanItemCreated planItemCreated = this.getPlanItems(string2).findFirst().orElse(null);
        if (planItemCreated == null) {
            throw new AssertionError((Object)("The " + string + " '" + string2 + "' cannot be found in " + this.getName()));
        }
        return planItemCreated;
    }

    protected Stream<PlanItemCreated> getPlanItems(String string) {
        PublishedEventsAssertion<PlanItemCreated> publishedEventsAssertion = this.testCommand.getEventListener().getEvents().filter(this.caseId).filter(PlanItemCreated.class);
        EventFilter<PlanItemCreated> eventFilter = planItemCreated -> planItemCreated.stageId.equals(this.getId()) && (planItemCreated.getPlanItemId().equals(string) || planItemCreated.getPlanItemName().equals(string));
        return publishedEventsAssertion.filter(eventFilter).getEvents().stream();
    }
}

