/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.consentgroup;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember;
import org.cafienne.consentgroup.actorapi.command.ConsentGroupCommand;
import org.cafienne.consentgroup.actorapi.command.CreateConsentGroup;
import org.cafienne.consentgroup.actorapi.command.ReplaceConsentGroup;
import org.cafienne.consentgroup.actorapi.event.ConsentGroupCreated;
import org.cafienne.consentgroup.actorapi.event.ConsentGroupEvent;
import org.cafienne.consentgroup.actorapi.event.ConsentGroupMemberAdded;
import org.cafienne.consentgroup.actorapi.event.ConsentGroupMemberChanged;
import org.cafienne.consentgroup.actorapi.event.ConsentGroupMemberRemoved;
import org.cafienne.consentgroup.actorapi.event.ConsentGroupModified;
import org.cafienne.system.CaseSystem;

public class ConsentGroupActor
extends ModelActor {
    private final Map<String, ConsentGroupMember> members = new HashMap<String, ConsentGroupMember>();
    private boolean created = false;

    public ConsentGroupActor(CaseSystem caseSystem) {
        super(caseSystem);
    }

    @Override
    protected boolean supportsCommand(Object object) {
        return object instanceof ConsentGroupCommand;
    }

    @Override
    protected boolean supportsEvent(ModelEvent modelEvent) {
        return modelEvent instanceof ConsentGroupEvent;
    }

    public boolean exists() {
        return this.created;
    }

    public boolean isOwner(ConsentGroupUser consentGroupUser) {
        return this.members.values().stream().filter(ConsentGroupMember::isOwner).anyMatch(consentGroupMember -> consentGroupMember.userId().equals(consentGroupUser.id()));
    }

    public List<String> getOwners() {
        return this.members.values().stream().filter(ConsentGroupMember::isOwner).map(ConsentGroupMember::userId).collect(Collectors.toList());
    }

    public Collection<ConsentGroupMember> getMembers() {
        return this.members.values();
    }

    public ConsentGroupMember getMember(String string) {
        return this.members.get(string);
    }

    public boolean setMember(ConsentGroupMember consentGroupMember) {
        ConsentGroupMember consentGroupMember2 = this.members.get(consentGroupMember.userId());
        if (consentGroupMember2 == null) {
            this.addEvent(new ConsentGroupMemberAdded(this, consentGroupMember));
        } else {
            boolean bl = consentGroupMember.isOwner() != consentGroupMember2.isOwner();
            Set<String> set = consentGroupMember2.getRoles().stream().filter(string -> !consentGroupMember.getRoles().contains(string)).collect(Collectors.toSet());
            Set set2 = consentGroupMember.getRoles().stream().filter(string -> !consentGroupMember.getRoles().contains(string)).collect(Collectors.toSet());
            if (bl || !set.isEmpty() || !set2.isEmpty()) {
                this.addEvent(new ConsentGroupMemberChanged(this, consentGroupMember, set));
            }
        }
        return true;
    }

    public void removeMember(String string) {
        ConsentGroupMember consentGroupMember = this.members.remove(string);
        if (consentGroupMember != null) {
            this.addEvent(new ConsentGroupMemberRemoved(this, consentGroupMember));
        }
    }

    public void updateState(ConsentGroupMemberAdded consentGroupMemberAdded) {
        this.members.put(consentGroupMemberAdded.userId, consentGroupMemberAdded.member);
    }

    public void updateState(ConsentGroupMemberChanged consentGroupMemberChanged) {
        this.members.put(consentGroupMemberChanged.userId, consentGroupMemberChanged.member);
    }

    public void updateState(ConsentGroupMemberRemoved consentGroupMemberRemoved) {
        this.members.remove(consentGroupMemberRemoved.userId);
    }

    public void updateState(ConsentGroupCreated consentGroupCreated) {
        this.created = true;
        this.setEngineVersion(consentGroupCreated.engineVersion);
    }

    public void create(CreateConsentGroup createConsentGroup) {
        this.addEvent(new ConsentGroupCreated(this, createConsentGroup.tenant()));
        createConsentGroup.getMembers().foreach(this::setMember);
    }

    public void replace(ReplaceConsentGroup replaceConsentGroup) {
        this.members.keySet().stream().filter(replaceConsentGroup::missingUserId).collect(Collectors.toList()).forEach(this::removeMember);
        replaceConsentGroup.getMembers().foreach(this::setMember);
    }

    @Override
    protected void completeTransaction(IncomingActorMessage incomingActorMessage) {
        this.addEvent(new ConsentGroupModified(this, incomingActorMessage));
    }
}

