/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.consentgroup.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.consentgroup.ConsentGroupActor;
import org.cafienne.consentgroup.actorapi.ConsentGroupMember;
import org.cafienne.consentgroup.actorapi.command.ConsentGroupCommand;
import org.cafienne.consentgroup.actorapi.response.ConsentGroupResponse;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class SetConsentGroupMember
extends ConsentGroupCommand {
    private final ConsentGroupMember newMemberInfo;

    public SetConsentGroupMember(ConsentGroupUser consentGroupUser, ConsentGroupMember consentGroupMember) {
        super(consentGroupUser, consentGroupUser.groupId());
        this.newMemberInfo = consentGroupMember;
    }

    public SetConsentGroupMember(ValueMap valueMap) {
        super(valueMap);
        this.newMemberInfo = ConsentGroupMember.deserialize(valueMap.with((Object)Fields.member));
    }

    @Override
    public void validate(ConsentGroupActor consentGroupActor) throws InvalidCommandException {
        super.validate(consentGroupActor);
        if (!this.newMemberInfo.isOwner()) {
            this.validateNotLastOwner(consentGroupActor, this.newMemberInfo.userId());
        }
    }

    public ConsentGroupResponse process(ConsentGroupActor consentGroupActor) {
        consentGroupActor.setMember(this.newMemberInfo);
        return new ConsentGroupResponse(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.member, this.newMemberInfo.toValue());
    }
}

