/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.humantask.instance;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.actormodel.identity.Origin;
import org.cafienne.cmmn.actorapi.command.platform.NewUserInformation;
import org.cafienne.cmmn.actorapi.event.CaseAppliedPlatformUpdate;
import org.cafienne.cmmn.definition.HumanTaskDefinition;
import org.cafienne.cmmn.definition.task.AssignmentDefinition;
import org.cafienne.cmmn.definition.task.DueDateDefinition;
import org.cafienne.cmmn.definition.task.WorkflowTaskDefinition;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.instance.CMMNElement;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.cmmn.instance.task.validation.ValidationError;
import org.cafienne.cmmn.instance.task.validation.ValidationResponse;
import org.cafienne.humantask.actorapi.event.HumanTaskActivated;
import org.cafienne.humantask.actorapi.event.HumanTaskAssigned;
import org.cafienne.humantask.actorapi.event.HumanTaskClaimed;
import org.cafienne.humantask.actorapi.event.HumanTaskCompleted;
import org.cafienne.humantask.actorapi.event.HumanTaskDelegated;
import org.cafienne.humantask.actorapi.event.HumanTaskDueDateFilled;
import org.cafienne.humantask.actorapi.event.HumanTaskInputSaved;
import org.cafienne.humantask.actorapi.event.HumanTaskOutputSaved;
import org.cafienne.humantask.actorapi.event.HumanTaskOwnerChanged;
import org.cafienne.humantask.actorapi.event.HumanTaskRevoked;
import org.cafienne.humantask.actorapi.event.HumanTaskTransitioned;
import org.cafienne.humantask.actorapi.event.migration.HumanTaskMigrated;
import org.cafienne.humantask.instance.TaskAction;
import org.cafienne.humantask.instance.TaskState;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

public class WorkflowTask
extends CMMNElement<WorkflowTaskDefinition> {
    private final HumanTask task;
    private String currentOwner = "";
    private String currentAssignee = "";
    private Instant currentDueDate = null;
    private TaskState currentTaskState = TaskState.Null;
    private TaskState historyTaskState = TaskState.Null;
    private TaskAction lastAction = TaskAction.Null;

    public WorkflowTask(WorkflowTaskDefinition workflowTaskDefinition, HumanTask humanTask) {
        super(humanTask, workflowTaskDefinition);
        this.task = humanTask;
    }

    public HumanTask getTask() {
        return this.task;
    }

    private Value<?> getTaskModel() {
        return ((WorkflowTaskDefinition)this.getDefinition()).getTaskModel();
    }

    private String getPerformerRole() {
        CaseRoleDefinition caseRoleDefinition = ((HumanTaskDefinition)this.task.getDefinition()).getPerformer();
        return caseRoleDefinition != null ? caseRoleDefinition.getName() : "";
    }

    public void beginLifeCycle() {
        this.addEvent(new HumanTaskActivated(this.task, this.getPerformerRole(), this.getTaskModel()));
        this.calculateOptionalAssignment();
        this.calculateOptionalDueDate();
        this.addEvent(new HumanTaskInputSaved(this.task, this.task.getMappedInputParameters()));
    }

    private void calculateOptionalAssignment() {
        AssignmentDefinition assignmentDefinition = ((WorkflowTaskDefinition)this.getDefinition()).getAssignmentExpression();
        if (assignmentDefinition != null) {
            try {
                String string = assignmentDefinition.evaluate(this.task);
                this.addDebugInfo(() -> "Assignee expression in task " + this.task.getName() + "[" + this.task.getId() + " resulted in: " + string, new Object[0]);
                if (string != null && !string.trim().isEmpty()) {
                    this.assign(CaseUserIdentity.apply(string, Origin.IDP));
                }
            }
            catch (Exception exception) {
                this.addDebugInfo(() -> "Failed to evaluate expression to assign task", exception);
            }
        }
    }

    private void calculateOptionalDueDate() {
        DueDateDefinition dueDateDefinition = ((WorkflowTaskDefinition)this.getDefinition()).getDueDateExpression();
        if (dueDateDefinition != null) {
            try {
                Instant instant = dueDateDefinition.evaluate(this.task);
                this.addDebugInfo(() -> "Due date expression in task " + this.task.getName() + "[" + this.task.getId() + " resulted in: " + instant, new Object[0]);
                this.setDueDate(instant);
            }
            catch (Exception exception) {
                this.addDebugInfo(() -> "Failed to evaluate expression on task due date", exception);
            }
        }
    }

    public void updateState(HumanTaskAssigned humanTaskAssigned) {
        this.currentAssignee = humanTaskAssigned.assignee;
    }

    public void updateState(HumanTaskOwnerChanged humanTaskOwnerChanged) {
        this.currentOwner = humanTaskOwnerChanged.owner;
    }

    public void updateState(HumanTaskTransitioned humanTaskTransitioned) {
        this.historyTaskState = humanTaskTransitioned.getHistoryState();
        this.currentTaskState = humanTaskTransitioned.getCurrentState();
        this.lastAction = humanTaskTransitioned.getTransition();
    }

    public void updateState(HumanTaskDueDateFilled humanTaskDueDateFilled) {
        this.currentDueDate = humanTaskDueDateFilled.dueDate;
    }

    public String getAssignee() {
        return this.currentAssignee;
    }

    public TaskState getCurrentState() {
        return this.currentTaskState;
    }

    public TaskState getHistoryState() {
        return this.historyTaskState;
    }

    private boolean isNewAssignee(CaseUserIdentity caseUserIdentity) {
        return !Objects.equals(this.currentAssignee, caseUserIdentity.id());
    }

    private void addCaseTeamUser(CaseUserIdentity caseUserIdentity) {
        this.getCaseInstance().getCaseTeam().upsertCaseTeamUser(caseUserIdentity, this.task.getPerformer());
    }

    public void assign(CaseUserIdentity caseUserIdentity) {
        if (this.isNewAssignee(caseUserIdentity)) {
            this.addCaseTeamUser(caseUserIdentity);
            this.addEvent(new HumanTaskAssigned(this.task, caseUserIdentity.id()));
            this.checkOwnershipChange(caseUserIdentity.id());
        }
    }

    public void claim(CaseUserIdentity caseUserIdentity) {
        if (this.isNewAssignee(caseUserIdentity)) {
            this.addEvent(new HumanTaskClaimed(this.task, caseUserIdentity.id()));
            this.checkOwnershipChange(caseUserIdentity.id());
        }
    }

    public void delegate(CaseUserIdentity caseUserIdentity) {
        if (this.isNewAssignee(caseUserIdentity)) {
            this.addCaseTeamUser(caseUserIdentity);
            this.addEvent(new HumanTaskDelegated(this.task, caseUserIdentity.id()));
        }
    }

    public void revoke() {
        TaskState taskState = this.currentTaskState == TaskState.Delegated ? TaskState.Assigned : TaskState.Unassigned;
        String string = this.currentTaskState == TaskState.Delegated ? this.currentOwner : "";
        this.addEvent(new HumanTaskRevoked(this.task, string, taskState, TaskAction.Revoke));
        this.checkOwnershipChange(string);
    }

    private void checkOwnershipChange(String string) {
        if (this.currentOwner.equalsIgnoreCase(string)) {
            return;
        }
        this.addEvent(new HumanTaskOwnerChanged(this.task, string));
    }

    public boolean complete(ValueMap valueMap) {
        ValidationResponse validationResponse = this.task.validateOutput(valueMap);
        if (validationResponse instanceof ValidationError) {
            throw new InvalidCommandException("Output for task " + this.task.getName() + " could not be validated due to an error", validationResponse.getException());
        }
        if (!((Map)validationResponse.getContent().getValue()).isEmpty()) {
            throw new InvalidCommandException("Output for task " + this.task.getName() + " is invalid\n" + validationResponse.getContent());
        }
        this.addEvent(new HumanTaskCompleted(this.task, valueMap));
        return this.task.goComplete(valueMap);
    }

    public void setDueDate(Instant instant) {
        if (instant != null && !Objects.equals(this.currentDueDate, instant)) {
            this.addEvent(new HumanTaskDueDateFilled(this.task, instant));
        }
    }

    public void saveOutput(ValueMap valueMap) {
        this.addEvent(new HumanTaskOutputSaved(this.task, valueMap));
    }

    public void updateState(CaseAppliedPlatformUpdate caseAppliedPlatformUpdate) {
        NewUserInformation newUserInformation;
        NewUserInformation newUserInformation2 = caseAppliedPlatformUpdate.newUserInformation.getUserUpdate(this.currentAssignee);
        if (newUserInformation2 != null) {
            this.addDebugInfo(() -> "Updating assignee of " + this.task + " with new user id " + newUserInformation2.newUserId(), new Object[0]);
            this.currentAssignee = newUserInformation2.newUserId();
        }
        if ((newUserInformation = caseAppliedPlatformUpdate.newUserInformation.getUserUpdate(this.currentOwner)) != null) {
            this.addDebugInfo(() -> "Updating owner of " + this.task + " with new user id " + newUserInformation.newUserId(), new Object[0]);
            this.currentOwner = newUserInformation.newUserId();
        }
    }

    @Override
    public void migrateDefinition(WorkflowTaskDefinition workflowTaskDefinition) {
        super.migrateDefinition(workflowTaskDefinition);
        if (this.currentTaskState == TaskState.Null) {
            return;
        }
        if (this.hasNewName() || this.hasNewPerformerRole() || this.hasNewTaskModel()) {
            this.addEvent(new HumanTaskMigrated(this.task, this.getPerformerRole(), this.getTaskModel()));
        }
    }

    private boolean hasNewName() {
        return !((HumanTaskDefinition)this.task.getPreviousDefinition()).getName().equals(((HumanTaskDefinition)this.task.getDefinition()).getName());
    }

    private String getRoleName(HumanTaskDefinition humanTaskDefinition) {
        return humanTaskDefinition.getPerformer() != null ? humanTaskDefinition.getPerformer().getName() : null;
    }

    private boolean hasNewPerformerRole() {
        String string;
        String string2 = this.getRoleName((HumanTaskDefinition)this.task.getPreviousDefinition());
        return !Objects.equals(string2, string = this.getRoleName((HumanTaskDefinition)this.task.getDefinition()));
    }

    private boolean hasNewTaskModel() {
        return !((WorkflowTaskDefinition)this.getPreviousDefinition()).getTaskModel().equals(((WorkflowTaskDefinition)this.getDefinition()).getTaskModel());
    }
}

