/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import org.cafienne.json.BinaryValue;
import org.cafienne.json.BooleanValue;
import org.cafienne.json.DoubleValue;
import org.cafienne.json.JSONParseFailure;
import org.cafienne.json.LongValue;
import org.cafienne.json.StringValue;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;

public class JSONReader {
    private static JsonFactory getJSONFactory() {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true);
        return jsonFactory;
    }

    public static <T extends Value<?>> T parse(String string) throws IOException, JSONParseFailure {
        JsonParser jsonParser = JSONReader.getJSONFactory().createParser(string);
        return (T)JSONReader.read(jsonParser, null);
    }

    public static <T extends Value<?>> T parse(InputStream inputStream) throws IOException, JSONParseFailure {
        JsonParser jsonParser = JSONReader.getJSONFactory().createParser(inputStream);
        return (T)JSONReader.read(jsonParser, null);
    }

    public static <T extends Value<?>> T parse(byte[] byArray) throws IOException, JSONParseFailure {
        JsonParser jsonParser = JSONReader.getJSONFactory().createParser(byArray);
        return (T)JSONReader.read(jsonParser, null);
    }

    public static Value<?> read(JsonParser jsonParser, Value<?> valueMap) throws IOException, JSONParseFailure {
        if (jsonParser.getCurrentToken() == null) {
            jsonParser.nextToken();
        }
        int n = jsonParser.currentTokenId();
        Value value = null;
        switch (n) {
            case 11: {
                value = Value.NULL;
                break;
            }
            case 7: {
                value = new LongValue(jsonParser.getLongValue());
                break;
            }
            case 8: {
                value = new DoubleValue(jsonParser.getDoubleValue());
                break;
            }
            case 6: {
                value = new StringValue(jsonParser.getText());
                break;
            }
            case 9: {
                value = new BooleanValue(true);
                break;
            }
            case 10: {
                value = new BooleanValue(false);
                break;
            }
            case 3: {
                ValueList valueList = new ValueList(new Object[0]);
                jsonParser.nextToken();
                while (jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                    valueList.add(JSONReader.read(jsonParser, valueMap));
                    jsonParser.nextToken();
                }
                value = valueList;
                break;
            }
            case 1: {
                jsonParser.nextToken();
                value = JSONReader.read(jsonParser, valueMap);
                break;
            }
            case 2: 
            case 5: {
                ValueMap valueMap2;
                ValueMap valueMap3 = valueMap;
                valueMap = valueMap2 = new ValueMap();
                while (jsonParser.getCurrentToken().id() != 2) {
                    String string = jsonParser.getCurrentName();
                    jsonParser.nextToken();
                    Value<?> value2 = JSONReader.read(jsonParser, valueMap);
                    valueMap2.put(string, value2);
                    jsonParser.nextToken();
                }
                valueMap = valueMap3;
                value = valueMap2;
                break;
            }
            case 12: {
                value = new BinaryValue(jsonParser.getBinaryValue());
                break;
            }
            case -1: 
            case 0: {
                throw new JSONParseFailure("JsonTokenId: NO_TOKEN or NOT_AVAILABLE; cannot parse into a valid JSON object");
            }
        }
        return value;
    }
}

