/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.expression.spel.SpelReadable;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.ValueMapJacksonDeserializer;
import org.cafienne.infrastructure.serialization.ValueMapJacksonSerializer;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMapParser;

@JsonSerialize(using=ValueMapJacksonSerializer.class)
@JsonDeserialize(using=ValueMapJacksonDeserializer.class)
public class ValueMap
extends Value<Map<String, Value<?>>>
implements SpelReadable {
    public ValueMap() {
        super(new LinkedHashMap());
    }

    public ValueMap(Object ... objectArray) {
        this();
        this.plus(objectArray);
    }

    public static ValueMap fill(ValueMapFiller valueMapFiller) {
        ValueMap valueMap = new ValueMap();
        valueMapFiller.fill(valueMap);
        return valueMap;
    }

    public ValueMap plus(Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new IllegalArgumentException("Must provide sufficient input data to the ValueMap construction, of pattern String, Object, String, Object ...");
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] == null) {
                throw new IllegalArgumentException("Field name cannot be null (argument nr " + i + ")");
            }
            String string = String.valueOf(objectArray[i]);
            if (string.length() > 50 && !(objectArray[i] instanceof String) && !(objectArray[i] instanceof Fields)) {
                throw new IllegalArgumentException("Field name at argument nr " + i + " is type " + objectArray[i].getClass().getName() + " generates a field name with too many characters (" + string.length() + "). Probably wrong argument order? Otherwise use put() method instead for this field.");
            }
            this.put(string, Value.convert(objectArray[i + 1]));
        }
        return this;
    }

    public Value<?> put(Object object, Value<?> value) {
        return ((Map)this.value).put(String.valueOf(object), value);
    }

    @Override
    public void print(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        this.printFields(jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    public void printFields(JsonGenerator jsonGenerator) throws IOException {
        for (Map.Entry entry : ((Map)this.value).entrySet()) {
            this.printField(jsonGenerator, (String)entry.getKey(), (Value)entry.getValue());
        }
    }

    private void printField(JsonGenerator jsonGenerator, String string, Value<?> value) throws IOException {
        jsonGenerator.writeFieldName(string);
        value.print(jsonGenerator);
    }

    @Override
    public boolean isSupersetOf(Value<?> value) {
        if (value == null || !value.isMap()) {
            return false;
        }
        Map map = (Map)this.value;
        Map map2 = (Map)value.asMap().value;
        if (map2.size() > map.size()) {
            return false;
        }
        for (String string : map2.keySet()) {
            Value value2 = (Value)map.get(string);
            Value value3 = (Value)map2.get(string);
            if (value2 != null && value2.isSupersetOf(value3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public void clearOwner() {
        super.clearOwner();
        ((Map)this.value).values().forEach(Value::clearOwner);
    }

    public Iterator<String> fieldNames() {
        return ((Map)this.value).keySet().iterator();
    }

    public Value<?> get(Object object) {
        Value<?> value = (Value<?>)((Map)this.value).get(String.valueOf(object));
        if (value == null) {
            value = Value.NULL;
        }
        return value;
    }

    public boolean has(Object object) {
        return ((Map)this.value).containsKey(String.valueOf(object));
    }

    public ValueMap with(Object object) {
        String string = String.valueOf(object);
        Value value = (Value)((Map)this.value).get(string);
        if (!(value instanceof ValueMap)) {
            value = new ValueMap();
            ((Map)this.value).put(string, value);
        }
        return value.asMap();
    }

    public ValueList withArray(Object object) {
        String string = String.valueOf(object);
        Value value = (Value)((Map)this.value).get(string);
        if (!(value instanceof ValueList)) {
            value = new ValueList(new Object[0]);
            ((Map)this.value).put(string, value);
        }
        return value.asList();
    }

    public <T> T raw(Object object) {
        Object t = this.get((Object)String.valueOf((Object)object)).value;
        return t;
    }

    public int rawInt(Object object) {
        Value<?> value = this.get(String.valueOf(object));
        return ((Long)value.value).intValue();
    }

    public Instant rawInstant(Object object, Instant ... instantArray) {
        Value<?> value = this.get(String.valueOf(object));
        if (value == Value.NULL) {
            return instantArray.length > 0 ? instantArray[0] : null;
        }
        return Instant.parse(value.value.toString());
    }

    private <T extends Enum<?>> T getEnum(Object object, Class<T> clazz) {
        Value<?> value = this.get(String.valueOf(object));
        if (value == null || value == Value.NULL) {
            return null;
        }
        String string = String.valueOf(value.value);
        if (string == null) {
            return null;
        }
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            return (T)((Enum)method.invoke(clazz, string));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException(exception.fillInStackTrace());
        }
    }

    @Override
    public boolean canRead(String string) {
        return true;
    }

    @Override
    public Value<?> read(String string) {
        return this.get(string);
    }

    public ValueMap cloneValueNode() {
        ValueMap valueMap = new ValueMap();
        for (Map.Entry entry : ((Map)this.value).entrySet()) {
            ((Map)valueMap.value).put((String)entry.getKey(), ((Value)entry.getValue()).cloneValueNode());
        }
        return valueMap;
    }

    @Override
    public <V extends Value<?>> V merge(V v) {
        if (!v.isMap()) {
            return v;
        }
        ((Map)v.asMap().value).forEach((string, value) -> {
            Value value2 = (Value)((Map)this.value).get(string);
            if (value2 != null) {
                value = value2.merge(value);
            }
            ((Map)this.value).put(string, value);
        });
        return (V)this;
    }

    @SafeVarargs
    public final <T> T readField(Object object, T ... TArray) {
        if (this.has(object)) {
            return this.raw(object);
        }
        if (TArray.length > 0) {
            return TArray[0];
        }
        return null;
    }

    public <T extends Enum<?>> T readEnum(Object object, Class<T> clazz) {
        return this.getEnum(object, clazz);
    }

    public String readString(Object object, String ... stringArray) {
        return this.readField(object, stringArray);
    }

    public Boolean readBoolean(Object object, Boolean ... booleanArray) {
        if (booleanArray.length > 0) {
            return this.readField(object, booleanArray);
        }
        return this.readField(object, false);
    }

    public Long readLong(Object object, Long ... longArray) {
        if (longArray.length > 0) {
            return this.readField(object, longArray);
        }
        return this.readField(object, new Long[0]);
    }

    public Instant readInstant(Object object, Instant ... instantArray) {
        return this.rawInstant(object, instantArray);
    }

    public String[] readStringList(Object object) {
        String[] stringArray = new String[]{};
        if (this.has(object)) {
            List<String> list = this.withArray(object).rawList();
            return list.toArray(stringArray);
        }
        return stringArray;
    }

    public ValueMap readMap(Object object) {
        return this.with(object);
    }

    public <T> Set<T> readSet(Object object) {
        if (this.has(object)) {
            return new HashSet(this.withArray(object).rawList());
        }
        return new HashSet();
    }

    public <T extends CMMNElementDefinition> T readDefinition(Object object, Class<T> clazz) {
        return CMMNElementDefinition.fromJSON(this.getClass().getName(), this.readMap(object), clazz);
    }

    public Path readPath(Object object, String ... stringArray) {
        return new Path(this.readString(object, stringArray));
    }

    public <T> T readObject(Object object, ValueMapParser<T> valueMapParser) {
        ValueMap valueMap = this.with(object);
        return valueMapParser.convert(valueMap);
    }

    public <T> List<T> readObjects(Object object, ValueMapParser<T> valueMapParser) {
        if (this.has(object)) {
            return this.withArray(object).stream().map(value -> valueMapParser.convert(value.asMap())).collect(Collectors.toList());
        }
        return List.of();
    }

    @FunctionalInterface
    public static interface ValueMapFiller {
        public void fill(ValueMap var1);
    }
}

