/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.definition;

import java.util.LinkedHashMap;
import org.apache.commons.text.StringSubstitutor;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.expression.InvalidExpressionException;
import org.cafienne.cmmn.expression.spel.Evaluator;
import org.cafienne.cmmn.expression.spel.api.APIRootObject;
import org.cafienne.cmmn.expression.spel.api.process.InputMappingRoot;
import org.cafienne.processtask.definition.ParameterEvaluator;
import org.cafienne.processtask.definition.SubProcessInputMappingDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;

public class Resolver
extends CMMNElementDefinition {
    private final Action action;
    private final String source;
    private final SubProcessInputMappingDefinition definition;

    public Resolver(SubProcessInputMappingDefinition subProcessInputMappingDefinition, String string) {
        super(subProcessInputMappingDefinition.getElement(), subProcessInputMappingDefinition.getModelDefinition(), subProcessInputMappingDefinition, new boolean[0]);
        this.definition = subProcessInputMappingDefinition;
        this.source = string;
        this.action = this.parseSource();
    }

    private Action parseSource() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        new StringSubstitutor(string -> {
            if (this.getProcessDefinition().getInputParameters().containsKey(string)) {
                linkedHashMap.put(string, new ParameterEvaluator(this.definition, string));
                return string;
            }
            Evaluator evaluator = new Evaluator(this.definition, string);
            if (evaluator.isValid()) {
                linkedHashMap.put(string, evaluator);
                return string;
            }
            return "";
        }).replace(this.source);
        if (linkedHashMap.isEmpty()) {
            return aPIRootObject -> this.source;
        }
        if (linkedHashMap.size() == 1 && this.source.trim().startsWith("${") && this.source.trim().endsWith("}")) {
            Evaluator evaluator = linkedHashMap.values().toArray(new Evaluator[0])[0];
            return evaluator::evaluate;
        }
        return aPIRootObject -> new StringSubstitutor(string -> {
            Evaluator evaluator = (Evaluator)linkedHashMap.get(string);
            if (evaluator == null) {
                throw new InvalidExpressionException("Cannot execute an invalid expression in task " + this.source);
            }
            return String.valueOf(evaluator.evaluate(aPIRootObject));
        }).replace(this.source);
    }

    public String getSource() {
        return this.source;
    }

    @SafeVarargs
    public final <T> T getValue(ProcessTaskActor processTaskActor, T ... TArray) {
        return this.getValue(new InputMappingRoot(processTaskActor), TArray);
    }

    @SafeVarargs
    public final <T> T getValue(APIRootObject<?> aPIRootObject, T ... TArray) {
        Object object = this.action.evaluate(aPIRootObject);
        if (object == null && TArray.length > 0) {
            return TArray[0];
        }
        return (T)object;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameResolver);
    }

    protected boolean sameResolver(Resolver resolver) {
        return this.getSource().equals(resolver.getSource());
    }

    @FunctionalInterface
    private static interface Action {
        public Object evaluate(APIRootObject<?> var1);
    }
}

