/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.calculation.operation;

import java.util.HashMap;
import java.util.Map;
import org.cafienne.json.Value;
import org.cafienne.processtask.implementation.calculation.Calculation;
import org.cafienne.processtask.implementation.calculation.Result;
import org.cafienne.processtask.implementation.calculation.definition.StepDefinition;
import org.cafienne.processtask.implementation.calculation.definition.expression.ConditionDefinition;
import org.cafienne.processtask.implementation.calculation.definition.source.InputReference;
import org.cafienne.processtask.implementation.calculation.operation.Source;

public class CalculationStep
extends Source<StepDefinition> {
    private Map<InputReference, Value<?>> inputs = null;
    private final ConditionDefinition condition;

    public CalculationStep(Calculation calculation, StepDefinition stepDefinition) {
        super(stepDefinition, calculation);
        this.condition = stepDefinition.getCondition();
    }

    protected Map<InputReference, Value<?>> getInputs() {
        if (this.inputs == null) {
            this.inputs = new HashMap();
            for (InputReference inputReference : ((StepDefinition)this.definition).getInputs()) {
                Source<?> source = this.calculation.getSource(inputReference.getSource());
                this.inputs.put(inputReference, source.getResult().getValue());
            }
        }
        return this.inputs;
    }

    @Override
    public boolean isValid() {
        if (this.condition == null) {
            return true;
        }
        return this.condition.getBooleanResult(this.calculation, this, this.getInputs());
    }

    @Override
    protected Result calculateResult() {
        return ((StepDefinition)this.definition).getResult(this.calculation, this, this.getInputs());
    }
}

