/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.calculation.operation;

import java.util.List;
import org.cafienne.processtask.implementation.calculation.Calculation;
import org.cafienne.processtask.implementation.calculation.Result;
import org.cafienne.processtask.implementation.calculation.definition.MultiStepDefinition;
import org.cafienne.processtask.implementation.calculation.definition.StepDefinition;
import org.cafienne.processtask.implementation.calculation.operation.CalculationStep;

public class MultiStep
extends CalculationStep {
    private final MultiStepDefinition definition;
    private CalculationStep actualStep;

    public MultiStep(Calculation calculation, MultiStepDefinition multiStepDefinition) {
        super(calculation, multiStepDefinition);
        this.definition = multiStepDefinition;
    }

    @Override
    public boolean isValid() {
        List<StepDefinition> list = this.definition.getSteps();
        this.addDebugInfo(() -> "Checking isValid for " + this.definition.getIdentifier() + " on " + list.size() + " possible steps");
        for (StepDefinition stepDefinition : list) {
            this.actualStep = stepDefinition.createInstance(this.calculation);
            if (this.actualStep.isValid()) {
                this.addDebugInfo(() -> "actualStep[" + this.definition.getIdentifier() + "]." + list.indexOf(stepDefinition) + ".isValid() = true");
                return true;
            }
            this.addDebugInfo(() -> "actualStep[" + this.definition.getIdentifier() + "]." + list.indexOf(stepDefinition) + ".isValid() = false");
        }
        this.addDebugInfo(() -> "Could not find a valid actual step, returning false on " + this.definition.getIdentifier());
        return false;
    }

    @Override
    protected Result calculateResult() {
        return this.actualStep.calculateResult();
    }
}

