/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.expression.spel.api.APIRootObject;
import org.cafienne.cmmn.expression.spel.api.process.InputMappingRoot;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.cmmn.instance.task.validation.TaskOutputValidator;
import org.cafienne.processtask.definition.SubProcessDefinition;
import org.cafienne.processtask.implementation.http.HTTPCall;
import org.cafienne.processtask.implementation.http.Header;
import org.cafienne.processtask.implementation.http.definition.ContentDefinition;
import org.cafienne.processtask.implementation.http.definition.HeaderDefinition;
import org.cafienne.processtask.implementation.http.definition.MethodDefinition;
import org.cafienne.processtask.implementation.http.definition.URLDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.w3c.dom.Element;

public class HTTPCallDefinition
extends SubProcessDefinition {
    public static final String RESPONSE_PAYLOAD_PARAMETER = "responsePayload";
    public static final String RESPONSE_CODE_PARAMETER = "responseCode";
    public static final String RESPONSE_MESSAGE_PARAMETER = "responseMessage";
    public static final String RESPONSE_HEADERS_PARAMETER = "responseHeaders";
    private final ContentDefinition contentTemplate;
    private final MethodDefinition httpMethod;
    private final URLDefinition sourceURL;
    private final List<HeaderDefinition> httpHeaders = new ArrayList<HeaderDefinition>();

    public HTTPCallDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.sourceURL = this.parse("url", URLDefinition.class, true);
        this.httpMethod = this.parse("method", MethodDefinition.class, true);
        this.contentTemplate = this.parse("post-content", ContentDefinition.class, false);
        this.parseGrandChildren("http-headers", "http-header", HeaderDefinition.class, this.httpHeaders);
    }

    @Override
    public Set<String> getRawOutputParameterNames() {
        Set<String> set = super.getExceptionParameterNames();
        set.add(RESPONSE_CODE_PARAMETER);
        set.add(RESPONSE_HEADERS_PARAMETER);
        set.add(RESPONSE_MESSAGE_PARAMETER);
        set.add(RESPONSE_PAYLOAD_PARAMETER);
        return set;
    }

    public List<Header> getHeaders(APIRootObject<?> aPIRootObject) {
        return this.httpHeaders.stream().map(headerDefinition -> headerDefinition.getHeader(aPIRootObject)).collect(Collectors.toList());
    }

    public List<Header> getHeaders(ProcessTaskActor processTaskActor) {
        return this.getHeaders(new InputMappingRoot(processTaskActor));
    }

    public URLDefinition getURL() {
        return this.sourceURL;
    }

    public MethodDefinition getMethod() {
        return this.httpMethod;
    }

    public ContentDefinition getContent() {
        return this.contentTemplate;
    }

    public HTTPCall createInstance(ProcessTaskActor processTaskActor) {
        return new HTTPCall(processTaskActor, this);
    }

    public TaskOutputValidator createValidator(HumanTask humanTask) {
        return new TaskOutputValidator(this, humanTask);
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameHTTPCall);
    }

    public boolean sameHTTPCall(HTTPCallDefinition hTTPCallDefinition) {
        return this.sameSubProcess(hTTPCallDefinition) && this.same(this.contentTemplate, hTTPCallDefinition.contentTemplate) && this.same(this.httpMethod, hTTPCallDefinition.httpMethod) && this.same(this.sourceURL, hTTPCallDefinition.sourceURL) && this.same(this.httpHeaders, hTTPCallDefinition.httpHeaders);
    }
}

