/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail;

import jakarta.mail.internet.InternetAddress;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.property.Attendee;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.StringValue;
import org.cafienne.json.Value;
import org.cafienne.processtask.implementation.mail.InvalidMailAddressException;
import org.cafienne.processtask.implementation.mail.definition.AddressDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;

public class MailAddress {
    private final String email;
    private final String name;

    public MailAddress(Value<?> value) {
        if (value.isMap()) {
            this.email = value.asMap().readString((Object)Fields.email, "");
            this.name = value.asMap().readString((Object)Fields.name, "");
        } else if (value instanceof StringValue) {
            this.email = value.getValue().toString();
            this.name = "";
        } else {
            throw new InvalidMailAddressException("Cannot extract an email address from an object of type " + value.getClass().getSimpleName());
        }
        if (this.email == null || this.email.isBlank()) {
            throw new InvalidMailAddressException("Missing email address in object of type " + value.getClass().getSimpleName());
        }
    }

    public MailAddress(AddressDefinition addressDefinition, ProcessTaskActor processTaskActor) {
        this.email = addressDefinition.getEmailResolver().getValue(processTaskActor, "");
        this.name = addressDefinition.getNameResolver().getValue(processTaskActor, "");
    }

    public InternetAddress getAddress() {
        try {
            return new InternetAddress(this.email, this.name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidMailAddressException("Invalid email address " + this.email + " " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    public Attendee asAttendee() {
        Attendee attendee = new Attendee(URI.create("mailto:" + this.email));
        if (!this.name.isBlank()) {
            attendee.getParameters().add((Parameter)new Cn(this.name));
        }
        return attendee;
    }
}

