/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.processtask.definition.SubProcessDefinition;
import org.cafienne.processtask.implementation.mail.Mail;
import org.cafienne.processtask.implementation.mail.definition.AddressDefinition;
import org.cafienne.processtask.implementation.mail.definition.AttachmentDefinition;
import org.cafienne.processtask.implementation.mail.definition.BodyDefinition;
import org.cafienne.processtask.implementation.mail.definition.SubjectDefinition;
import org.cafienne.processtask.instance.ProcessTaskActor;
import org.w3c.dom.Element;

public class MailDefinition
extends SubProcessDefinition {
    private final SubjectDefinition subject;
    private final BodyDefinition body;
    private final AddressDefinition from;
    private final AddressDefinition replyTo;
    private final List<AddressDefinition> toList = new ArrayList<AddressDefinition>();
    private final List<AddressDefinition> ccList = new ArrayList<AddressDefinition>();
    private final List<AddressDefinition> bccList = new ArrayList<AddressDefinition>();
    private final List<AttachmentDefinition> attachmentList = new ArrayList<AttachmentDefinition>();

    public MailDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.subject = this.parse("subject", SubjectDefinition.class, false);
        this.body = this.parse("mail-body", BodyDefinition.class, false);
        this.from = this.parse("from", AddressDefinition.class, false);
        this.replyTo = this.parse("reply-to", AddressDefinition.class, false);
        this.parseGrandChildren("to", "address", AddressDefinition.class, this.toList);
        this.parseGrandChildren("cc", "address", AddressDefinition.class, this.ccList);
        this.parseGrandChildren("bcc", "address", AddressDefinition.class, this.bccList);
        this.parseGrandChildren("attachments", "attachment", AttachmentDefinition.class, this.attachmentList);
    }

    public SubjectDefinition getSubject() {
        return this.subject;
    }

    public AddressDefinition getFrom() {
        return this.from;
    }

    public AddressDefinition getReplyTo() {
        return this.replyTo;
    }

    public List<AddressDefinition> getToList() {
        return this.toList;
    }

    public List<AddressDefinition> getCcList() {
        return this.ccList;
    }

    public List<AddressDefinition> getBccList() {
        return this.bccList;
    }

    public BodyDefinition getBody() {
        return this.body;
    }

    public List<AttachmentDefinition> getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Set<String> getRawOutputParameterNames() {
        return super.getExceptionParameterNames();
    }

    public Properties getMailProperties() {
        return Cafienne.config().engine().mailService().asProperties();
    }

    public Mail createInstance(ProcessTaskActor processTaskActor) {
        return new Mail(processTaskActor, this);
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.notYetImplemented();
    }
}

