/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.processtask.implementation.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.json.Value;
import org.cafienne.processtask.implementation.report.MissingParameterException;
import org.cafienne.processtask.implementation.report.PDFReport;
import org.w3c.dom.Element;

public class ReportDataDefinition
extends CMMNElementDefinition {
    static InputStream EMPTY_STREAM = new ByteArrayInputStream("{}".getBytes(StandardCharsets.UTF_8));
    private final String name = this.parseAttribute("name", false, new String[0]);

    public ReportDataDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
    }

    public InputStream createDataStream(PDFReport pDFReport) {
        if (this.name.isEmpty()) {
            return EMPTY_STREAM;
        }
        if (!pDFReport.getInputParameters().has(this.name)) {
            throw new MissingParameterException("Report data '" + this.name + "' cannot be found in the task input parameters");
        }
        Value<?> value = pDFReport.getInputParameters().get(this.name);
        return new ByteArrayInputStream(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.notYetImplemented();
    }
}

