/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases.file;

import akka.Done;
import akka.Done$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.cafienne.cmmn.actorapi.event.file.BusinessIdentifierCleared;
import org.cafienne.cmmn.actorapi.event.file.BusinessIdentifierEvent;
import org.cafienne.cmmn.actorapi.event.file.BusinessIdentifierSet;
import org.cafienne.cmmn.actorapi.event.file.CaseFileEvent;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemTransitioned;
import org.cafienne.cmmn.actorapi.event.migration.CaseFileItemDropped;
import org.cafienne.cmmn.actorapi.event.migration.CaseFileItemMigrated;
import org.cafienne.json.JSONReader;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.querydb.materializer.cases.CaseEventBatch;
import org.cafienne.querydb.materializer.cases.CaseStorageTransaction;
import org.cafienne.querydb.materializer.cases.file.CaseFileEventBuffer;
import org.cafienne.querydb.materializer.cases.file.CaseFileMerger$;
import org.cafienne.querydb.materializer.cases.file.CaseIdentifierMerger$;
import org.cafienne.querydb.record.CaseBusinessIdentifierRecord;
import org.cafienne.querydb.record.CaseFileRecord;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\r\u001b\u0001\u001dB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011)\u0019!C\u0002}!AQ\t\u0001B\u0001B\u0003%q\bC\u0003G\u0001\u0011\u0005q\t\u0003\u0005N\u0001!\u0015\r\u0011\"\u0001O\u0011!\u0011\u0006\u0001#b\u0001\n\u0003\u0019\u0006\u0002C0\u0001\u0011\u000b\u0007I\u0011A*\t\u000f\u0001\u0004!\u0019!C\u0005C\"1\u0001\u000f\u0001Q\u0001\n\tDq!\u001d\u0001C\u0002\u0013%!\u000f\u0003\u0004w\u0001\u0001\u0006Ia\u001d\u0005\bo\u0002\u0001\r\u0011\"\u0003y\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9\u0001C\u0004\u0002\u0014\u0001\u0001\u000b\u0015B=\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\ty\u0006\u0001C\u0005\u0003CBq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002~\u0001!I!a \t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u0011Q\u0012\u0001\u0005\u0002\u0005]\u0001bBAH\u0001\u0011%\u0011\u0011\u0013\u0002\u0013\u0007\u0006\u001cXMR5mKB\u0013xN[3di&|gN\u0003\u0002\u001c9\u0005!a-\u001b7f\u0015\tib$A\u0003dCN,7O\u0003\u0002 A\u0005aQ.\u0019;fe&\fG.\u001b>fe*\u0011\u0011EI\u0001\bcV,'/\u001f3c\u0015\t\u0019C%\u0001\u0005dC\u001aLWM\u001c8f\u0015\u0005)\u0013aA8sO\u000e\u00011c\u0001\u0001)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\u0004\"a\f\u001c\u000e\u0003AR!!\r\u001a\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005M\"\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003U\n1aY8n\u0013\t9\u0004GA\u0006MCjLHj\\4hS:<\u0017!\u00022bi\u000eD\u0007C\u0001\u001e<\u001b\u0005a\u0012B\u0001\u001f\u001d\u00059\u0019\u0015m]3Fm\u0016tGOQ1uG\"\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0016\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002E\u0003\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002I\u0019R\u0011\u0011j\u0013\t\u0003\u0015\u0002i\u0011A\u0007\u0005\u0006{\u0011\u0001\u001da\u0010\u0005\u0006q\u0011\u0001\r!O\u0001\u000eI\n#&/\u00198tC\u000e$\u0018n\u001c8\u0016\u0003=\u0003\"A\u000f)\n\u0005Ec\"AF\"bg\u0016\u001cFo\u001c:bO\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u0002\u001d\r\f7/Z%ogR\fgnY3JIV\tA\u000b\u0005\u0002V9:\u0011aK\u0017\t\u0003/*j\u0011\u0001\u0017\u0006\u00033\u001a\na\u0001\u0010:p_Rt\u0014BA.+\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mS\u0013A\u0002;f]\u0006tG/A\nckNLg.Z:t\u0013\u0012,g\u000e^5gS\u0016\u00148/F\u0001c!\r\u0019\u0007N[\u0007\u0002I*\u0011QMZ\u0001\b[V$\u0018M\u00197f\u0015\t9'&\u0001\u0006d_2dWm\u0019;j_:L!!\u001b3\u0003\u0007M+G\u000f\u0005\u0002l]6\tAN\u0003\u0002nA\u00051!/Z2pe\u0012L!a\u001c7\u00039\r\u000b7/\u001a\"vg&tWm]:JI\u0016tG/\u001b4jKJ\u0014VmY8sI\u0006!\"-^:j]\u0016\u001c8/\u00133f]RLg-[3sg\u0002\naCY;gM\u0016\u0014X\rZ\"bg\u00164\u0015\u000e\\3Fm\u0016tGo]\u000b\u0002gB\u0011!\n^\u0005\u0003kj\u00111cQ1tK\u001aKG.Z#wK:$()\u001e4gKJ\fqCY;gM\u0016\u0014X\rZ\"bg\u00164\u0015\u000e\\3Fm\u0016tGo\u001d\u0011\u0002\u0011\r\f7/\u001a$jY\u0016,\u0012!\u001f\t\u0004Sid\u0018BA>+\u0005\u0019y\u0005\u000f^5p]B\u0019Q0!\u0001\u000e\u0003yT!a \u0012\u0002\t)\u001cxN\\\u0005\u0004\u0003\u0007q(\u0001\u0003,bYV,W*\u00199\u0002\u0019\r\f7/\u001a$jY\u0016|F%Z9\u0015\t\u0005%\u0011q\u0002\t\u0004S\u0005-\u0011bAA\u0007U\t!QK\\5u\u0011!\t\t\"DA\u0001\u0002\u0004I\u0018a\u0001=%c\u0005I1-Y:f\r&dW\rI\u0001\u0013Q\u0006tG\r\\3DCN,7I]3bi&|g\u000e\u0006\u0002\u0002\n\u0005\u0019\u0002.\u00198eY\u0016\u001c\u0015m]3GS2,WI^3oiR!\u0011QDA\u0018!\u0015\u0001\u0015qDA\u0012\u0013\r\t\t#\u0011\u0002\u0007\rV$XO]3\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ!!!\u000b\u0002\t\u0005\\7.Y\u0005\u0005\u0003[\t9C\u0001\u0003E_:,\u0007bBA\u0019!\u0001\u0007\u00111G\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003k\t\u0019%\u0004\u0002\u00028)\u00191$!\u000f\u000b\t\u0005E\u00121\b\u0006\u0005\u0003{\ty$\u0001\u0005bGR|'/\u00199j\u0015\r\t\tEI\u0001\u0005G6lg.\u0003\u0003\u0002F\u0005]\"!D\"bg\u00164\u0015\u000e\\3Fm\u0016tG/A\u000fiC:$G.\u001a\"vg&tWm]:JI\u0016tG/\u001b4jKJ,e/\u001a8u)\u0011\ti\"a\u0013\t\u000f\u0005E\u0012\u00031\u0001\u0002NA!\u0011QGA(\u0013\u0011\t\t&a\u000e\u0003/\t+8/\u001b8fgNLE-\u001a8uS\u001aLWM]#wK:$\u0018a\u00065b]\u0012dWmQ1tK\u001aKG.Z%uK6,e/\u001a8u)\u0011\ti\"a\u0016\t\u000f\u0005E\"\u00031\u0001\u0002ZA!\u0011QGA.\u0013\u0011\ti&a\u000e\u00031\r\u000b7/\u001a$jY\u0016LE/Z7Ue\u0006t7/\u001b;j_:,G-A\fiC:$G.Z\"bg\u00164\u0015\u000e\\3NS\u001e\u0014\u0018\r^5p]R!\u0011QDA2\u0011\u001d\t\td\u0005a\u0001\u0003K\u0002B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\nI$A\u0005nS\u001e\u0014\u0018\r^5p]&!\u0011qNA5\u0005Q\u0019\u0015m]3GS2,\u0017\n^3n\u001b&<'/\u0019;fI\u0006)\u0002.\u00198eY\u0016\u001c\u0015m]3GS2,GI]8qa\u0016$G\u0003BA\u000f\u0003kBq!!\r\u0015\u0001\u0004\t9\b\u0005\u0003\u0002h\u0005e\u0014\u0002BA>\u0003S\u00121cQ1tK\u001aKG.Z%uK6$%o\u001c9qK\u0012\f1b]3u\u0007\u0006\u001cXMR5mKR\u0019A0!!\t\r\u0005\rU\u00031\u0001}\u0003\u0011!\u0017\r^1\u0002\u0017\u001d,GoQ1tK\u001aKG.\u001a\u000b\u0005\u0003\u0013\u000bY\t\u0005\u0003A\u0003?a\b\"\u0002*\u0017\u0001\u0004!\u0016!\u00049sKB\f'/Z\"p[6LG/\u0001\nhKR,\u0006\u000fZ1uK\u0012\u001c\u0015m]3GS2,G\u0003BAJ\u00033\u00032a[AK\u0013\r\t9\n\u001c\u0002\u000f\u0007\u0006\u001cXMR5mKJ+7m\u001c:e\u0011\u0019\tY\n\u0007a\u0001y\u0006\u00112-Y:f\r&dW-\u00138Qe><'/Z:t\u0001")
public class CaseFileProjection
implements LazyLogging {
    private CaseStorageTransaction dBTransaction;
    private String caseInstanceId;
    private String tenant;
    private final CaseEventBatch batch;
    private final ExecutionContext executionContext;
    private final Set<CaseBusinessIdentifierRecord> businessIdentifiers;
    private final CaseFileEventBuffer bufferedCaseFileEvents;
    private Option<ValueMap> caseFile;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    private Logger logger$lzycompute() {
        CaseFileProjection caseFileProjection = this;
        synchronized (caseFileProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private CaseStorageTransaction dBTransaction$lzycompute() {
        CaseFileProjection caseFileProjection = this;
        synchronized (caseFileProjection) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dBTransaction = this.batch.dBTransaction();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dBTransaction;
    }

    public CaseStorageTransaction dBTransaction() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dBTransaction$lzycompute() : this.dBTransaction;
    }

    private String caseInstanceId$lzycompute() {
        CaseFileProjection caseFileProjection = this;
        synchronized (caseFileProjection) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.caseInstanceId = this.batch.caseInstanceId();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.caseInstanceId;
    }

    public String caseInstanceId() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.caseInstanceId$lzycompute() : this.caseInstanceId;
    }

    private String tenant$lzycompute() {
        CaseFileProjection caseFileProjection = this;
        synchronized (caseFileProjection) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.tenant = this.batch.tenant();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.tenant;
    }

    public String tenant() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.tenant$lzycompute() : this.tenant;
    }

    private Set<CaseBusinessIdentifierRecord> businessIdentifiers() {
        return this.businessIdentifiers;
    }

    private CaseFileEventBuffer bufferedCaseFileEvents() {
        return this.bufferedCaseFileEvents;
    }

    private Option<ValueMap> caseFile() {
        return this.caseFile;
    }

    private void caseFile_$eq(Option<ValueMap> x$1) {
        this.caseFile = x$1;
    }

    public void handleCaseCreation() {
        this.setCaseFile(new ValueMap());
    }

    public Future<Done> handleCaseFileEvent(CaseFileEvent event) {
        Future<Done> future;
        CaseFileEvent caseFileEvent = event;
        if (caseFileEvent instanceof CaseFileItemTransitioned) {
            CaseFileItemTransitioned caseFileItemTransitioned = (CaseFileItemTransitioned)caseFileEvent;
            future = this.handleCaseFileItemEvent(caseFileItemTransitioned);
        } else if (caseFileEvent instanceof BusinessIdentifierEvent) {
            BusinessIdentifierEvent businessIdentifierEvent = (BusinessIdentifierEvent)caseFileEvent;
            future = this.handleBusinessIdentifierEvent(businessIdentifierEvent);
        } else if (caseFileEvent instanceof CaseFileItemMigrated) {
            CaseFileItemMigrated caseFileItemMigrated = (CaseFileItemMigrated)caseFileEvent;
            future = this.handleCaseFileMigration(caseFileItemMigrated);
        } else if (caseFileEvent instanceof CaseFileItemDropped) {
            CaseFileItemDropped caseFileItemDropped = (CaseFileItemDropped)caseFileEvent;
            future = this.handleCaseFileDropped(caseFileItemDropped);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> handleBusinessIdentifierEvent(BusinessIdentifierEvent event) {
        Object object;
        BusinessIdentifierEvent businessIdentifierEvent = event;
        if (businessIdentifierEvent instanceof BusinessIdentifierSet) {
            BusinessIdentifierSet businessIdentifierSet = (BusinessIdentifierSet)businessIdentifierEvent;
            object = BoxesRunTime.boxToBoolean((boolean)this.businessIdentifiers().add((Object)CaseIdentifierMerger$.MODULE$.merge(businessIdentifierSet)));
        } else if (businessIdentifierEvent instanceof BusinessIdentifierCleared) {
            BusinessIdentifierCleared businessIdentifierCleared = (BusinessIdentifierCleared)businessIdentifierEvent;
            object = BoxesRunTime.boxToBoolean((boolean)this.businessIdentifiers().add((Object)CaseIdentifierMerger$.MODULE$.merge(businessIdentifierCleared)));
        } else {
            object = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> handleCaseFileItemEvent(CaseFileItemTransitioned event) {
        this.bufferedCaseFileEvents().addEvent(event);
        return this.getCaseFile(this.caseInstanceId()).map((Function1 & Serializable)x$1 -> Done$.MODULE$, this.executionContext());
    }

    private Future<Done> handleCaseFileMigration(CaseFileItemMigrated event) {
        this.getCaseFile(this.caseInstanceId()).map((Function1 & Serializable)json -> {
            ValueMap parent = event$1.formerPath.resolveParent((ValueMap)json);
            parent.put(event$1.path.name, parent.get(event$1.formerPath.name));
            return (Value)((Map)parent.getValue()).remove(event$1.formerPath.name);
        }, this.executionContext());
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> handleCaseFileDropped(CaseFileItemDropped event) {
        this.getCaseFile(this.caseInstanceId()).map((Function1 & Serializable)json -> {
            ValueMap parent = event$2.path.resolveParent((ValueMap)json);
            return (Value)((Map)parent.getValue()).remove(event$2.path.name);
        }, this.executionContext());
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private ValueMap setCaseFile(ValueMap data) {
        this.caseFile_$eq((Option<ValueMap>)new Some((Object)data));
        return data;
    }

    private Future<ValueMap> getCaseFile(String caseInstanceId) {
        Future future;
        if (this.caseFile().isEmpty()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Retrieving casefile caseInstanceId={} from database", (Object)caseInstanceId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.dBTransaction().getCaseFile(caseInstanceId).map((Function1 & Serializable)x0$1 -> {
                ValueMap valueMap;
                Option option = x0$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CaseFileRecord record = (CaseFileRecord)some.value();
                    valueMap = (ValueMap)JSONReader.parse(record.data());
                } else if (None$.MODULE$.equals(option)) {
                    valueMap = new ValueMap();
                } else {
                    throw new MatchError((Object)option);
                }
                return valueMap;
            }, this.executionContext()).map((Function1 & Serializable)data -> this.setCaseFile((ValueMap)data), this.executionContext());
        } else {
            future = Future$.MODULE$.successful(this.caseFile().get());
        }
        return future;
    }

    public void prepareCommit() {
        this.caseFile().map((Function1 & Serializable)caseFileInProgress -> this.getUpdatedCaseFile((ValueMap)caseFileInProgress)).foreach((Function1 & Serializable)caseFile -> {
            CaseFileProjection.$anonfun$prepareCommit$2(this, caseFile);
            return BoxedUnit.UNIT;
        });
        this.businessIdentifiers().toSeq().foreach((Function1 & Serializable)item -> {
            CaseFileProjection.$anonfun$prepareCommit$3(this, item);
            return BoxedUnit.UNIT;
        });
    }

    private CaseFileRecord getUpdatedCaseFile(ValueMap caseFileInProgress) {
        this.bufferedCaseFileEvents().events().forEach(event -> CaseFileMerger$.MODULE$.merge((CaseFileItemTransitioned)event, caseFileInProgress));
        return new CaseFileRecord(this.caseInstanceId(), this.tenant(), caseFileInProgress.toString());
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$2(CaseFileProjection $this, CaseFileRecord caseFile) {
        $this.dBTransaction().upsert(caseFile);
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$3(CaseFileProjection $this, CaseBusinessIdentifierRecord item) {
        $this.dBTransaction().upsert(item);
    }

    public CaseFileProjection(CaseEventBatch batch, ExecutionContext executionContext) {
        this.batch = batch;
        this.executionContext = executionContext;
        LazyLogging.$init$((LazyLogging)this);
        this.businessIdentifiers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.bufferedCaseFileEvents = new CaseFileEventBuffer();
        this.caseFile = None$.MODULE$;
    }
}

