/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.querydb.materializer.cases.plan;

import akka.Done;
import akka.Done$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.cmmn.actorapi.event.CaseModified;
import org.cafienne.cmmn.actorapi.event.migration.PlanItemDropped;
import org.cafienne.cmmn.actorapi.event.migration.PlanItemMigrated;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.actorapi.event.plan.RepetitionRuleEvaluated;
import org.cafienne.cmmn.actorapi.event.plan.RequiredRuleEvaluated;
import org.cafienne.humantask.actorapi.event.HumanTaskActivated;
import org.cafienne.humantask.actorapi.event.HumanTaskAssigned;
import org.cafienne.humantask.actorapi.event.HumanTaskCompleted;
import org.cafienne.humantask.actorapi.event.HumanTaskCreated;
import org.cafienne.humantask.actorapi.event.HumanTaskDueDateFilled;
import org.cafienne.humantask.actorapi.event.HumanTaskEvent;
import org.cafienne.humantask.actorapi.event.HumanTaskInputSaved;
import org.cafienne.humantask.actorapi.event.HumanTaskOutputSaved;
import org.cafienne.humantask.actorapi.event.HumanTaskOwnerChanged;
import org.cafienne.humantask.actorapi.event.HumanTaskTerminated;
import org.cafienne.humantask.actorapi.event.HumanTaskTransitioned;
import org.cafienne.humantask.actorapi.event.migration.HumanTaskDropped;
import org.cafienne.humantask.actorapi.event.migration.HumanTaskMigrated;
import org.cafienne.querydb.materializer.cases.CaseEventBatch;
import org.cafienne.querydb.materializer.cases.CaseEventMaterializer;
import org.cafienne.querydb.materializer.cases.CaseStorageTransaction;
import org.cafienne.querydb.materializer.cases.plan.PlanItemMerger$;
import org.cafienne.querydb.materializer.cases.plan.TaskMerger$;
import org.cafienne.querydb.record.PlanItemRecord;
import org.cafienne.querydb.record.TaskRecord;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001BC\u0002\u0013\rA\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dY\u0005A1A\u0005\n1CaA\u001a\u0001!\u0002\u0013i\u0005bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007[\u0002\u0001\u000b\u0011B5\t\u000b9\u0004A\u0011A8\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002^\u0001!\t!a\u0018\u0003%\r\u000b7/\u001a)mC:\u0004&o\u001c6fGRLwN\u001c\u0006\u0003)U\tA\u0001\u001d7b]*\u0011acF\u0001\u0006G\u0006\u001cXm\u001d\u0006\u00031e\tA\"\\1uKJL\u0017\r\\5{KJT!AG\u000e\u0002\u000fE,XM]=eE*\u0011A$H\u0001\tG\u00064\u0017.\u001a8oK*\ta$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001C\u001dZ\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)S5\tQ#\u0003\u0002++\t)2)Y:f\u000bZ,g\u000e^'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0001\u00174\u001b\u0005i#B\u0001\u00180\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0001\u0014'\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0014aA2p[&\u0011A'\f\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0003cCR\u001c\u0007.F\u00018!\tA\u0003(\u0003\u0002:+\tq1)Y:f\u000bZ,g\u000e\u001e\"bi\u000eD\u0017A\u00022bi\u000eD\u0007%\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002AG\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\t{$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003E)\u00070Z2vi&|gnQ8oi\u0016DH\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0019SECA$J!\tA\u0005!D\u0001\u0014\u0011\u0015YT\u0001q\u0001>\u0011\u0015)T\u00011\u00018\u0003%\u0001H.\u00198Ji\u0016l7/F\u0001N!\u0011q5+\u00161\u000e\u0003=S!\u0001U)\u0002\u000f5,H/\u00192mK*\u0011!kI\u0001\u000bG>dG.Z2uS>t\u0017B\u0001+P\u0005\u001dA\u0015m\u001d5NCB\u0004\"AV/\u000f\u0005][\u0006C\u0001-$\u001b\u0005I&B\u0001. \u0003\u0019a$o\\8u}%\u0011AlI\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]GA\u0011\u0011\rZ\u0007\u0002E*\u00111-G\u0001\u0007e\u0016\u001cwN\u001d3\n\u0005\u0015\u0014'A\u0004)mC:LE/Z7SK\u000e|'\u000fZ\u0001\u000ba2\fg.\u0013;f[N\u0004\u0013!\u0002;bg.\u001cX#A5\u0011\t9\u001bVK\u001b\t\u0003C.L!\u0001\u001c2\u0003\u0015Q\u000b7o\u001b*fG>\u0014H-\u0001\u0004uCN\\7\u000fI\u0001\u0014Q\u0006tG\r\\3DCN,\u0007\u000b\\1o\u000bZ,g\u000e\u001e\u000b\u0003af\u00042AP9t\u0013\t\u0011xH\u0001\u0004GkR,(/\u001a\t\u0003i^l\u0011!\u001e\u0006\u0002m\u0006!\u0011m[6b\u0013\tAXO\u0001\u0003E_:,\u0007\"\u0002>\u000b\u0001\u0004Y\u0018!B3wK:$\bc\u0001?\u0002\b5\tQP\u0003\u0002\u0015}*\u0011!p \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0005bGR|'/\u00199j\u0015\r\t)aG\u0001\u0005G6lg.C\u0002\u0002\nu\u0014QbQ1tKBc\u0017M\\#wK:$\u0018a\u00055b]\u0012dW\r\u00157b]&#X-\\#wK:$Hc\u00019\u0002\u0010!)!p\u0003a\u0001w\u0006Yq-\u001a;QY\u0006t\u0017\n^3n)\u0011\t)\"!\b\u0011\ty\n\u0018q\u0003\t\u0005E\u0005e\u0001-C\u0002\u0002\u001c\r\u0012aa\u00149uS>t\u0007BBA\u0010\u0019\u0001\u0007Q+\u0001\u0006qY\u0006t\u0017\n^3n\u0013\u0012\f!b\u0019:fCR,G+Y:l)\r\u0001\u0018Q\u0005\u0005\b\u0003Oi\u0001\u0019AA\u0015\u0003\r)g\u000f\u001e\t\u0005\u0003W\t)$\u0004\u0002\u0002.)\u0019!0a\f\u000b\t\u0005\u0005\u0011\u0011\u0007\u0006\u0004\u0003gY\u0012!\u00035v[\u0006tG/Y:l\u0013\u0011\t9$!\f\u0003%!+X.\u00198UCN\\\u0017i\u0019;jm\u0006$X\rZ\u0001\u0015I\u0016\u0004(/Z2bi\u0016$7I]3bi\u0016$\u0016m]6\u0015\u0007A\fi\u0004C\u0004\u0002(9\u0001\r!a\u0010\u0011\t\u0005-\u0012\u0011I\u0005\u0005\u0003\u0007\niC\u0001\tIk6\fg\u000eV1tW\u000e\u0013X-\u0019;fI\u0006!\u0002.\u00198eY\u0016DU/\\1o)\u0006\u001c8.\u0012<f]R$2\u0001]A%\u0011\u0019Qx\u00021\u0001\u0002LA!\u00111FA'\u0013\u0011\ty%!\f\u0003\u001d!+X.\u00198UCN\\WI^3oi\u0006Ia-\u001a;dQR\u000b7o\u001b\u000b\u0005\u0003+\nI\u0006\u0005\u0003?c\u0006]\u0003\u0003\u0002\u0012\u0002\u001a)Da!a\u0017\u0011\u0001\u0004)\u0016A\u0002;bg.LE-A\u0007qe\u0016\u0004\u0018M]3D_6l\u0017\u000e\u001e\u000b\u0005\u0003C\n9\u0007E\u0002#\u0003GJ1!!\u001a$\u0005\u0011)f.\u001b;\t\u000f\u0005%\u0014\u00031\u0001\u0002l\u0005a1-Y:f\u001b>$\u0017NZ5fIB!\u0011QNA8\u001b\u0005q\u0018bAA9}\na1)Y:f\u001b>$\u0017NZ5fI\u0002")
public class CasePlanProjection
implements CaseEventMaterializer,
LazyLogging {
    private final CaseEventBatch batch;
    private final ExecutionContext executionContext;
    private final HashMap<String, PlanItemRecord> planItems;
    private final HashMap<String, TaskRecord> tasks;
    private transient Logger logger;
    private String caseInstanceId;
    private CaseStorageTransaction dBTransaction;
    private String tenant;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    private Logger logger$lzycompute() {
        CasePlanProjection casePlanProjection = this;
        synchronized (casePlanProjection) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private String caseInstanceId$lzycompute() {
        CasePlanProjection casePlanProjection = this;
        synchronized (casePlanProjection) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.caseInstanceId = CaseEventMaterializer.caseInstanceId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.caseInstanceId;
    }

    @Override
    public String caseInstanceId() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.caseInstanceId$lzycompute() : this.caseInstanceId;
    }

    private CaseStorageTransaction dBTransaction$lzycompute() {
        CasePlanProjection casePlanProjection = this;
        synchronized (casePlanProjection) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dBTransaction = CaseEventMaterializer.dBTransaction$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dBTransaction;
    }

    @Override
    public CaseStorageTransaction dBTransaction() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dBTransaction$lzycompute() : this.dBTransaction;
    }

    private String tenant$lzycompute() {
        CasePlanProjection casePlanProjection = this;
        synchronized (casePlanProjection) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.tenant = CaseEventMaterializer.tenant$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.tenant;
    }

    @Override
    public String tenant() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.tenant$lzycompute() : this.tenant;
    }

    @Override
    public CaseEventBatch batch() {
        return this.batch;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private HashMap<String, PlanItemRecord> planItems() {
        return this.planItems;
    }

    private HashMap<String, TaskRecord> tasks() {
        return this.tasks;
    }

    public Future<Done> handleCasePlanEvent(CasePlanEvent event) {
        Future<Done> future;
        CasePlanEvent casePlanEvent = event;
        if (casePlanEvent instanceof HumanTaskCreated) {
            HumanTaskCreated humanTaskCreated = (HumanTaskCreated)casePlanEvent;
            future = this.deprecatedCreateTask(humanTaskCreated);
        } else if (casePlanEvent instanceof HumanTaskActivated) {
            HumanTaskActivated humanTaskActivated = (HumanTaskActivated)casePlanEvent;
            future = this.createTask(humanTaskActivated);
        } else if (casePlanEvent instanceof HumanTaskEvent) {
            HumanTaskEvent humanTaskEvent = (HumanTaskEvent)casePlanEvent;
            future = this.handleHumanTaskEvent(humanTaskEvent);
        } else if (casePlanEvent != null) {
            CasePlanEvent casePlanEvent2 = casePlanEvent;
            future = this.handlePlanItemEvent(casePlanEvent2);
        } else {
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private Future<Done> handlePlanItemEvent(CasePlanEvent event) {
        Future future;
        CasePlanEvent casePlanEvent = event;
        if (casePlanEvent instanceof PlanItemDropped) {
            PlanItemDropped planItemDropped = (PlanItemDropped)casePlanEvent;
            this.dBTransaction().deletePlanItemRecord(planItemDropped.getPlanItemId());
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        } else {
            Future future2;
            CasePlanEvent casePlanEvent2 = event;
            if (casePlanEvent2 instanceof PlanItemCreated) {
                PlanItemCreated planItemCreated = (PlanItemCreated)casePlanEvent2;
                PlanItemRecord planItem = PlanItemMerger$.MODULE$.merge(planItemCreated);
                this.planItems().put((Object)planItem.id(), (Object)planItem);
                future2 = Future$.MODULE$.successful((Object)Done$.MODULE$);
            } else if (casePlanEvent2 != null) {
                CasePlanEvent casePlanEvent3 = casePlanEvent2;
                future2 = this.getPlanItem(event.getPlanItemId()).map((Function1 & Serializable)x0$1 -> {
                    Done$ done$;
                    Option option = x0$1;
                    if (option instanceof Some) {
                        Option option2;
                        Some some = (Some)option;
                        PlanItemRecord planItem = (PlanItemRecord)some.value();
                        CasePlanEvent casePlanEvent = casePlanEvent3;
                        if (casePlanEvent instanceof PlanItemTransitioned) {
                            PlanItemTransitioned planItemTransitioned = (PlanItemTransitioned)casePlanEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(planItemTransitioned, planItem));
                        } else if (casePlanEvent instanceof RepetitionRuleEvaluated) {
                            RepetitionRuleEvaluated repetitionRuleEvaluated = (RepetitionRuleEvaluated)casePlanEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(repetitionRuleEvaluated, planItem));
                        } else if (casePlanEvent instanceof RequiredRuleEvaluated) {
                            RequiredRuleEvaluated requiredRuleEvaluated = (RequiredRuleEvaluated)casePlanEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(requiredRuleEvaluated, planItem));
                        } else if (casePlanEvent instanceof PlanItemMigrated) {
                            PlanItemMigrated planItemMigrated = (PlanItemMigrated)casePlanEvent;
                            option2 = this.planItems().put((Object)planItem.id(), (Object)PlanItemMerger$.MODULE$.merge(planItemMigrated, planItem));
                        } else {
                            option2 = BoxedUnit.UNIT;
                        }
                        done$ = Done$.MODULE$;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error("Expected PlanItem " + event.getPlanItemId() + " in " + event.getCaseInstanceId() + ", but not found in the database on event type " + event.getClass().getSimpleName());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        done$ = Done$.MODULE$;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return done$;
                }, this.executionContext());
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Apparently we have a new type of CasePlanEvent that is not being handled by this Projection. The type is " + casePlanEvent2.getClass().getName());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future2 = Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            future = future2;
        }
        return future;
    }

    private Future<Option<PlanItemRecord>> getPlanItem(String planItemId) {
        Future future;
        Option option = this.planItems().get((Object)planItemId);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            PlanItemRecord item = (PlanItemRecord)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Found plan item {} in current transaction cache", (Object)planItemId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)new Some((Object)item));
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Retrieving plan item {} from database", (Object)planItemId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.dBTransaction().getPlanItem(planItemId);
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private Future<Done> createTask(HumanTaskActivated evt) {
        TaskRecord taskRecord;
        Option option = this.tasks().get((Object)evt.getTaskId());
        if (None$.MODULE$.equals(option)) {
            taskRecord = TaskMerger$.MODULE$.create(evt);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TaskRecord task = (TaskRecord)some.value();
            taskRecord = TaskMerger$.MODULE$.apply(evt, task);
        } else {
            throw new MatchError((Object)option);
        }
        TaskRecord updatedTask = taskRecord;
        this.tasks().put((Object)evt.getTaskId(), (Object)updatedTask);
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> deprecatedCreateTask(HumanTaskCreated evt) {
        this.tasks().put((Object)evt.getTaskId(), (Object)TaskMerger$.MODULE$.create(evt));
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Future<Done> handleHumanTaskEvent(HumanTaskEvent event) {
        Future future;
        HumanTaskEvent humanTaskEvent = event;
        if (humanTaskEvent instanceof HumanTaskDropped) {
            HumanTaskDropped humanTaskDropped = (HumanTaskDropped)humanTaskEvent;
            this.dBTransaction().deleteTaskRecord(humanTaskDropped.getTaskId());
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        HumanTaskEvent humanTaskEvent2 = event;
        if (humanTaskEvent2 instanceof HumanTaskInputSaved) {
            HumanTaskInputSaved humanTaskInputSaved = (HumanTaskInputSaved)humanTaskEvent2;
            future = this.fetchTask(event.getTaskId()).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskInputSaved, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskOutputSaved) {
            HumanTaskOutputSaved humanTaskOutputSaved = (HumanTaskOutputSaved)humanTaskEvent2;
            future = this.fetchTask(event.getTaskId()).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskOutputSaved, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskOwnerChanged) {
            HumanTaskOwnerChanged humanTaskOwnerChanged = (HumanTaskOwnerChanged)humanTaskEvent2;
            future = this.fetchTask(event.getTaskId()).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskOwnerChanged, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskDueDateFilled) {
            HumanTaskDueDateFilled humanTaskDueDateFilled = (HumanTaskDueDateFilled)humanTaskEvent2;
            future = this.fetchTask(event.getTaskId()).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskDueDateFilled, (TaskRecord)task)), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskTransitioned) {
            HumanTaskTransitioned humanTaskTransitioned = (HumanTaskTransitioned)humanTaskEvent2;
            future = this.fetchTask(event.getTaskId()).map((Function1 & Serializable)task -> task.map((Function1 & Serializable)t -> {
                TaskRecord taskRecord;
                TaskRecord copy = TaskMerger$.MODULE$.apply(humanTaskTransitioned, (TaskRecord)t);
                HumanTaskTransitioned humanTaskTransitioned = humanTaskTransitioned;
                if (humanTaskTransitioned instanceof HumanTaskAssigned) {
                    HumanTaskAssigned humanTaskAssigned = (HumanTaskAssigned)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskAssigned, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskActivated) {
                    HumanTaskActivated humanTaskActivated = (HumanTaskActivated)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskActivated, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskCompleted) {
                    HumanTaskCompleted humanTaskCompleted = (HumanTaskCompleted)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskCompleted, copy);
                } else if (humanTaskTransitioned instanceof HumanTaskTerminated) {
                    HumanTaskTerminated humanTaskTerminated = (HumanTaskTerminated)humanTaskTransitioned;
                    taskRecord = TaskMerger$.MODULE$.apply(humanTaskTerminated, copy);
                } else {
                    taskRecord = copy;
                }
                return taskRecord;
            }), this.executionContext());
        } else if (humanTaskEvent2 instanceof HumanTaskMigrated) {
            HumanTaskMigrated humanTaskMigrated = (HumanTaskMigrated)humanTaskEvent2;
            future = this.fetchTask(event.getTaskId()).map((Function1 & Serializable)t -> t.map((Function1 & Serializable)task -> TaskMerger$.MODULE$.apply(humanTaskMigrated, (TaskRecord)task)), this.executionContext());
        } else {
            future = Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        Future fTask = future;
        return fTask.map((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                TaskRecord task = (TaskRecord)some.value();
                boxedUnit = this.tasks().put((Object)task.id(), (Object)task);
            } else {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Could not find task '{}' with id {} in the current database. This may lead to problems. Ignoring event of type {}", new Object[]{event.getTaskName(), event.getTaskId(), event.getClass().getName()});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            }
            return boxedUnit;
        }, this.executionContext()).flatMap((Function1 & Serializable)x$1 -> Future$.MODULE$.successful((Object)Done$.MODULE$), this.executionContext());
    }

    private Future<Option<TaskRecord>> fetchTask(String taskId) {
        Future future;
        Option option = this.tasks().get((Object)taskId);
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Retrieving task " + taskId + " from database");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.dBTransaction().getTask(taskId);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            TaskRecord task = (TaskRecord)some.value();
            future = Future$.MODULE$.successful((Object)new Some((Object)task));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public void prepareCommit(CaseModified caseModified) {
        ((IterableOnceOps)this.planItems().values().map((Function1 & Serializable)item -> PlanItemMerger$.MODULE$.merge(caseModified, (PlanItemRecord)item))).foreach((Function1 & Serializable)item -> {
            CasePlanProjection.$anonfun$prepareCommit$2(this, item);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.tasks().values().map((Function1 & Serializable)current -> TaskMerger$.MODULE$.apply(caseModified, (TaskRecord)current))).foreach((Function1 & Serializable)item -> {
            CasePlanProjection.$anonfun$prepareCommit$4(this, item);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$2(CasePlanProjection $this, PlanItemRecord item) {
        $this.dBTransaction().upsert(item);
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$4(CasePlanProjection $this, TaskRecord item) {
        $this.dBTransaction().upsert(item);
    }

    public CasePlanProjection(CaseEventBatch batch, ExecutionContext executionContext) {
        this.batch = batch;
        this.executionContext = executionContext;
        CaseEventMaterializer.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.planItems = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.tasks = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

