/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.service.akkahttp.storage;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.storage.StorageCoordinator;
import org.cafienne.storage.actormodel.message.StorageActionInitiated;
import org.cafienne.storage.actormodel.message.StorageActionRejected;
import org.cafienne.storage.actormodel.message.StorageCommand;
import org.cafienne.storage.actormodel.message.StorageFailure;
import org.cafienne.storage.deletion.event.RemovalCompleted;
import org.cafienne.system.CaseSystem;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class StorageRoute$
implements LazyLogging {
    public static final StorageRoute$ MODULE$ = new StorageRoute$();
    private static ActorRef storageCoordinator;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        StorageRoute$ storageRoute$ = this;
        synchronized (storageRoute$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    private ActorRef storageCoordinator() {
        return storageCoordinator;
    }

    private void storageCoordinator_$eq(ActorRef x$1) {
        storageCoordinator = x$1;
    }

    public void startCoordinator(CaseSystem caseSystem) {
        block0: {
            if (this.storageCoordinator() != null) break block0;
            ActorSystem system = caseSystem.system();
            this.storageCoordinator_$eq(system.actorOf(Props$.MODULE$.apply(StorageCoordinator.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{caseSystem}))));
        }
    }

    public Function1<RequestContext, Future<RouteResult>> askStorageCoordinator(StorageCommand command) {
        Timeout timeout = Cafienne$.MODULE$.config().actor().askTimout();
        return (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.onComplete((Function0 & Serializable)() -> {
            ActorRef qual$1 = package$.MODULE$.ask(MODULE$.storageCoordinator());
            StorageCommand x$1 = command;
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
            return AskableActorRef$.MODULE$.ask$extension(qual$1, (Object)x$1, x$2, x$3);
        }), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x0$1 -> {
            StandardRoute standardRoute;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                StandardRoute standardRoute2;
                Success success = (Success)try_;
                Object value = success.value();
                Object object = value;
                if (object instanceof StorageActionInitiated) {
                    standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.Accepted(), Marshaller$.MODULE$.fromStatusCode()));
                } else if (object instanceof StorageActionRejected) {
                    BoxedUnit boxedUnit;
                    StorageActionRejected storageActionRejected = (StorageActionRejected)object;
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error("Removal of {} is rejected with reason {}", new Object[]{command.metadata(), storageActionRejected.msg()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.NotFound(), Marshaller$.MODULE$.fromStatusCode()));
                } else if (object instanceof RemovalCompleted) {
                    standardRoute2 = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.NotFound(), (Function0 & Serializable)() -> "Cannot find " + command.metadata(), Marshaller$.MODULE$.StringMarshaller());
                } else if (object instanceof StorageFailure) {
                    StorageFailure storageFailure = (StorageFailure)object;
                    standardRoute2 = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.NotFound(), (Function0 & Serializable)() -> storageFailure.getMessage(), Marshaller$.MODULE$.StringMarshaller());
                } else {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error("Received an unexpected response after asking {} a command of type {}. Response is of type {}", new Object[]{command.metadata(), command.getClass().getSimpleName(), object.getClass().getSimpleName()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.Accepted(), Marshaller$.MODULE$.fromStatusCode()));
                }
                standardRoute = standardRoute2;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                standardRoute = Directives$.MODULE$.complete((StatusCode)StatusCodes$.MODULE$.InternalServerError(), (Function0 & Serializable)() -> e.getMessage(), Marshaller$.MODULE$.StringMarshaller());
            } else {
                throw new MatchError((Object)try_);
            }
            return standardRoute;
        });
    }

    private StorageRoute$() {
    }
}

