/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.storage;

import akka.Done;
import akka.Done$;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorContextProvider;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.annotation.InternalApi;
import akka.persistence.query.EventEnvelope;
import akka.persistence.query.EventEnvelope$;
import akka.persistence.query.Offset$;
import akka.persistence.query.scaladsl.CurrentEventsByTagQuery;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.cafienne.actormodel.command.TerminateModelActor;
import org.cafienne.actormodel.response.ActorTerminated;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.infrastructure.cqrs.ReadJournalProvider;
import org.cafienne.storage.actormodel.message.StorageActionInitiated;
import org.cafienne.storage.actormodel.message.StorageCommand;
import org.cafienne.storage.actormodel.message.StorageEvent;
import org.cafienne.storage.actormodel.message.StorageEvent$;
import org.cafienne.storage.archival.command.ArchiveActorData$;
import org.cafienne.storage.archival.command.RestoreActorData$;
import org.cafienne.storage.archival.event.ArchivalInitiated;
import org.cafienne.storage.deletion.command.RemoveActorData$;
import org.cafienne.storage.deletion.event.RemovalCompleted;
import org.cafienne.storage.deletion.event.RemovalInitiated;
import org.cafienne.storage.restore.event.RestoreInitiated;
import org.cafienne.system.CaseSystem;
import org.cafienne.system.health.HealthMonitor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001B\n\u0015\u0001mA\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005}!)Q\t\u0001C\u0001\r\"9\u0011\t\u0001b\u0001\n\u0003R\u0005B\u0002(\u0001A\u0003%1\nC\u0004P\u0001\t\u0007I1\u0001)\t\r]\u0003\u0001\u0015!\u0003R\u0011\u001dA\u0006A1A\u0005\neCa\u0001\u001d\u0001!\u0002\u0013Q\u0006\"B9\u0001\t\u0013\u0011\b\"B?\u0001\t\u0003q\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003/\u0001A\u0011AA\r\u0011%\ty\u0003\u0001b\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u001a\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002\\\u0001!\t%!\u0018\u0003%M#xN]1hK\u000e{wN\u001d3j]\u0006$xN\u001d\u0006\u0003+Y\tqa\u001d;pe\u0006<WM\u0003\u0002\u00181\u0005A1-\u00194jK:tWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\u0015\u0001AD\t\u00165!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006C\u000e$xN\u001d\u0006\u0002O\u0005!\u0011m[6b\u0013\tICEA\u0003BGR|'\u000f\u0005\u0002,e5\tAF\u0003\u0002.]\u0005a1oY1mC2|wmZ5oO*\u0011q\u0006M\u0001\tif\u0004Xm]1gK*\t\u0011'A\u0002d_6L!a\r\u0017\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\t\u0003kij\u0011A\u000e\u0006\u0003oa\nAaY9sg*\u0011\u0011HF\u0001\u000fS:4'/Y:ueV\u001cG/\u001e:f\u0013\tYdGA\nSK\u0006$'j\\;s]\u0006d\u0007K]8wS\u0012,'/\u0001\u0006dCN,7+_:uK6,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003Z\taa]=ti\u0016l\u0017BA\"A\u0005)\u0019\u0015m]3TsN$X-\\\u0001\fG\u0006\u001cXmU=ti\u0016l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u000f&\u0003\"\u0001\u0013\u0001\u000e\u0003QAQ\u0001P\u0002A\u0002y*\u0012a\u0013\t\u0003G1K!!\u0014\u0013\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!\u0003\t)7-F\u0001R!\t\u0011V+D\u0001T\u0015\t!f$\u0001\u0006d_:\u001cWO\u001d:f]RL!AV*\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005!!/\u001a4t+\u0005Q\u0006\u0003B.aE6l\u0011\u0001\u0018\u0006\u0003;z\u000bq!\\;uC\ndWM\u0003\u0002`=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0005d&aA'baB\u00111M\u001b\b\u0003I\"\u0004\"!\u001a\u0010\u000e\u0003\u0019T!a\u001a\u000e\u0002\rq\u0012xn\u001c;?\u0013\tIg$\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA5\u001f!\t\u0019c.\u0003\u0002pI\tA\u0011i\u0019;peJ+g-A\u0003sK\u001a\u001c\b%A\u0006hKR\f5\r^8s%\u00164GCA7t\u0011\u0015!(\u00021\u0001v\u0003\u001d\u0019w.\\7b]\u0012\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u000f5,7o]1hK*\u0011!\u0010F\u0001\u000bC\u000e$xN]7pI\u0016d\u0017B\u0001?x\u00059\u0019Fo\u001c:bO\u0016\u001cu.\\7b]\u0012\fQa\u001d;beR$\u0012a \t\u0004;\u0005\u0005\u0011bAA\u0002=\t!QK\\5u\u0003%\u0011XO\\*ue\u0016\fW\u000e\u0006\u0002\u0002\nA)!+a\u0003\u0002\u0010%\u0019\u0011QB*\u0003\r\u0019+H/\u001e:f!\u0011\t\t\"a\u0005\u000e\u0003\u0019J1!!\u0006'\u0005\u0011!uN\\3\u0002#\r|gn];nK6{G-\u001a7Fm\u0016tG\u000f\u0006\u0003\u0002\n\u0005m\u0001bBA\u000f\u001b\u0001\u0007\u0011qD\u0001\tK:4X\r\\8qKB!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!B9vKJL(bAA\u0015M\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\u0011\ti#a\t\u0003\u001b\u00153XM\u001c;F]Z,Gn\u001c9f\u0003%1w\u000e\u001c7poV\u00048/\u0006\u0002\u00024A)1\f\u00192\u00026A)Q$a\u000ev[&\u0019\u0011\u0011\b\u0010\u0003\rQ+\b\u000f\\33\u0003)1w\u000e\u001c7poV\u00048\u000fI\u0001\u0011e\u0016<\u0017n\u001d;fe\u001a{G\u000e\\8xkB$Ra`A!\u0003\u0007BQ\u0001\u001e\tA\u0002UDa!!\u0012\u0011\u0001\u0004i\u0017AD8sS\u001eLg.\u00197TK:$WM]\u0001\u000fQ\u0006tG\r\\3G_2dwn^;q)\ry\u00181\n\u0005\u0007qF\u0001\r!!\u0014\u0011\t\u0005=\u0013qK\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005A!/Z:q_:\u001cXM\u0003\u0002{-%!\u0011\u0011LA)\u0005=\t5\r^8s)\u0016\u0014X.\u001b8bi\u0016$\u0017a\u0002:fG\u0016Lg/Z\u000b\u0003\u0003?\u0002B!!\u0019\u0002d5\t\u0001!C\u0002\u0002f!\u0012qAU3dK&4X\r")
public class StorageCoordinator
implements Actor,
ReadJournalProvider {
    private final CaseSystem caseSystem;
    private final ActorSystem system;
    private final ExecutionContext ec;
    private final Map<String, ActorRef> org$cafienne$storage$StorageCoordinator$$refs;
    private final Map<String, Tuple2<StorageCommand, ActorRef>> followups;
    private String configuredJournal;
    private String readJournalSetting;
    private transient Logger logger;
    private ActorContext context;
    private ActorRef self;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public ActorSystem actorSystem() {
        return ReadJournalProvider.actorSystem$(this);
    }

    @Override
    public CurrentPersistenceIdsQuery journal() {
        return ReadJournalProvider.journal$(this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    private String configuredJournal$lzycompute() {
        StorageCoordinator storageCoordinator = this;
        synchronized (storageCoordinator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.configuredJournal = ReadJournalProvider.configuredJournal$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.configuredJournal;
    }

    @Override
    public String configuredJournal() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.configuredJournal$lzycompute() : this.configuredJournal;
    }

    private String readJournalSetting$lzycompute() {
        StorageCoordinator storageCoordinator = this;
        synchronized (storageCoordinator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readJournalSetting = ReadJournalProvider.readJournalSetting$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readJournalSetting;
    }

    @Override
    public String readJournalSetting() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.readJournalSetting$lzycompute() : this.readJournalSetting;
    }

    private Logger logger$lzycompute() {
        StorageCoordinator storageCoordinator = this;
        synchronized (storageCoordinator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public Map<String, ActorRef> org$cafienne$storage$StorageCoordinator$$refs() {
        return this.org$cafienne$storage$StorageCoordinator$$refs;
    }

    private ActorRef getActorRef(StorageCommand command) {
        return (ActorRef)this.org$cafienne$storage$StorageCoordinator$$refs().getOrElseUpdate((Object)command.metadata().actorId(), (Function0 & Serializable)() -> {
            void var2_2;
            ActorRef ref = this.context().actorOf(Props$.MODULE$.apply(command.actorClass(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.caseSystem(), command.metadata()})), command.metadata().actorId());
            this.context().watch(ref);
            return var2_2;
        });
    }

    public void start() {
        this.runStream().onComplete((Function1 & Serializable)x0$1 -> {
            StorageCoordinator.$anonfun$start$1(this, x0$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Future<Done> runStream() {
        Materializer mat = Materializer$.MODULE$.apply((ClassicActorContextProvider)this.context());
        return (Future)((Source)((CurrentEventsByTagQuery)this.journal()).currentEventsByTag(StorageEvent$.MODULE$.TAG(), Offset$.MODULE$.noOffset()).mapAsync(1, (Function1 & Serializable)envelope -> this.consumeModelEvent((EventEnvelope)envelope))).runWith((Graph)Sink$.MODULE$.ignore(), mat);
    }

    public Future<Done> consumeModelEvent(EventEnvelope envelope) {
        Option option;
        Object event;
        Option option2;
        EventEnvelope eventEnvelope = envelope;
        if (eventEnvelope != null && !(option2 = EventEnvelope$.MODULE$.unapply(eventEnvelope)).isEmpty() && (event = ((Tuple4)option2.get())._4()) instanceof StorageActionInitiated) {
            BoxedUnit boxedUnit;
            StorageActionInitiated storageActionInitiated = (StorageActionInitiated)event;
            if (storageActionInitiated.metadata().isRoot()) {
                StorageActionInitiated storageActionInitiated2 = storageActionInitiated;
                if (storageActionInitiated2 instanceof RemovalInitiated) {
                    this.restart$1((Function1)RemoveActorData$.MODULE$, storageActionInitiated);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else if (storageActionInitiated2 instanceof ArchivalInitiated) {
                    this.restart$1((Function1)ArchiveActorData$.MODULE$, storageActionInitiated);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else if (storageActionInitiated2 instanceof RestoreInitiated) {
                    this.restart$1((Function1)RestoreActorData$.MODULE$, storageActionInitiated);
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit5;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Cannot recover a storage process, because of unrecognized initiation event of type {}", (Object)storageActionInitiated2.getClass().getName());
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit6 = boxedUnit5;
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
        } else if (eventEnvelope != null && !(option = EventEnvelope$.MODULE$.unapply(eventEnvelope)).isEmpty() && ((Tuple4)option.get())._4() instanceof StorageEvent) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Encountered unexpected storage tag matching event of type {}", (Object)eventEnvelope.getClass().getName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private Map<String, Tuple2<StorageCommand, ActorRef>> followups() {
        return this.followups;
    }

    public void org$cafienne$storage$StorageCoordinator$$registerFollowup(StorageCommand command, ActorRef originalSender) {
        this.followups().put((Object)command.metadata().actorId(), (Object)new Tuple2((Object)command, (Object)originalSender));
    }

    public void org$cafienne$storage$StorageCoordinator$$handleFollowup(ActorTerminated message) {
        this.followups().remove((Object)message.actorId()).foreach((Function1 & Serializable)request -> {
            StorageCoordinator.$anonfun$handleFollowup$1(this, message, request);
            return BoxedUnit.UNIT;
        });
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageCoordinator $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StorageCommand) {
                    BoxedUnit boxedUnit;
                    StorageCommand storageCommand = (StorageCommand)A1;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug("Received {}", (Object)storageCommand);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.$outer.org$cafienne$storage$StorageCoordinator$$registerFollowup(storageCommand, this.$outer.sender());
                    this.$outer.caseSystem().gateway().inform(new TerminateModelActor(storageCommand.metadata().user(), storageCommand.metadata().actorId()), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ActorTerminated) {
                    ActorTerminated actorTerminated = (ActorTerminated)A1;
                    this.$outer.org$cafienne$storage$StorageCoordinator$$handleFollowup(actorTerminated);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof RemovalCompleted) {
                    BoxedUnit boxedUnit;
                    RemovalCompleted removalCompleted = (RemovalCompleted)A1;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug("Completed removal for {}", (Object)removalCompleted.metadata());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (A1 instanceof Terminated) {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    Terminated terminated = (Terminated)A1;
                    String actorId = terminated.actor().path().name();
                    if (this.$outer.org$cafienne$storage$StorageCoordinator$$refs().remove((Object)actorId).isEmpty()) {
                        if (this.$outer.logger().underlying().isWarnEnabled()) {
                            this.$outer.logger().underlying().warn("Received a Termination message for actor " + actorId + ", but it was not registered in the LocalRoutingService. Termination message is ignored");
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug("Actor {} is removed from memory", (Object)actorId);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof StorageCommand ? true : (object instanceof ActorTerminated ? true : (object instanceof RemovalCompleted ? true : object instanceof Terminated));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$start$1(StorageCoordinator $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Completed re-activating Storage Deletion Actors");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error($this.getClass().getSimpleName() + " bumped into an issue that it cannot recover from.", ex);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HealthMonitor$.MODULE$.storageService().hasFailed(ex);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private final void restart$1(Function1 commandMaker, StorageActionInitiated x6$1) {
        BoxedUnit boxedUnit;
        StorageCommand command = (StorageCommand)commandMaker.apply((Object)x6$1.metadata());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Recovering storage process '{}' on actor {}", new Object[]{command.getClass().getSimpleName(), x6$1.metadata()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.getActorRef(command).tell((Object)command, this.self());
    }

    public static final /* synthetic */ void $anonfun$handleFollowup$1(StorageCoordinator $this, ActorTerminated message$1, Tuple2 request) {
        BoxedUnit boxedUnit;
        StorageCommand command = (StorageCommand)request._1();
        ActorRef originalSender = (ActorRef)request._2();
        if ($this.logger().underlying().isDebugEnabled()) {
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Actor {} terminated, triggering follow up: {}", new Object[]{message$1.actorId(), command});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $this.getActorRef(command).tell((Object)command, originalSender);
    }

    public StorageCoordinator(CaseSystem caseSystem) {
        BoxedUnit boxedUnit;
        this.caseSystem = caseSystem;
        Actor.$init$((Actor)this);
        LazyLogging.$init$((LazyLogging)this);
        ReadJournalProvider.$init$(this);
        this.system = caseSystem.system();
        this.ec = caseSystem.system().dispatcher();
        this.org$cafienne$storage$StorageCoordinator$$refs = new HashMap();
        if (Cafienne$.MODULE$.config().engine().storage().recoveryDisabled()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("WARNING: Storage Coordination Service does not recover any existing unfinished storage processes; set 'engine.storage-service.auto-start = true' to enable recovery ");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Launching Storage Coordination Service");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.start();
            boxedUnit = BoxedUnit.UNIT;
        }
        this.followups = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Statics.releaseFence();
    }
}

