/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.storage.archival;

import akka.Done;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.StashFactory;
import akka.actor.StashSupport;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.actor.UnrestrictedStash;
import akka.annotation.InternalApi;
import akka.annotation.InternalStableApi;
import akka.dispatch.DequeBasedMessageQueueSemantics;
import akka.dispatch.Envelope;
import akka.persistence.DeleteMessagesSuccess;
import akka.persistence.Eventsourced;
import akka.persistence.Persistence;
import akka.persistence.PersistenceIdentity;
import akka.persistence.PersistenceRecovery;
import akka.persistence.PersistenceStash;
import akka.persistence.PersistentActor;
import akka.persistence.PersistentEnvelope;
import akka.persistence.Recovery;
import akka.persistence.SaveSnapshotSuccess;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.Snapshotter;
import akka.persistence.StashOverflowStrategy;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedList;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.response.ActorTerminated;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.storage.actormodel.ActorMetadata;
import org.cafienne.storage.actormodel.ActorType$;
import org.cafienne.storage.actormodel.StorageActor;
import org.cafienne.storage.actormodel.message.StorageActionInitiated;
import org.cafienne.storage.actormodel.message.StorageCommand;
import org.cafienne.storage.actormodel.message.StorageEvent;
import org.cafienne.storage.archival.command.ArchiveActorData;
import org.cafienne.storage.archival.event.ArchivalInitiated;
import org.cafienne.storage.archival.event.ArchivalInitiated$;
import org.cafienne.storage.archival.event.ArchiveCreated;
import org.cafienne.storage.archival.event.ArchiveExported;
import org.cafienne.storage.archival.event.ArchiveExported$;
import org.cafienne.storage.archival.event.ChildArchived;
import org.cafienne.storage.archival.event.ChildArchived$;
import org.cafienne.storage.archival.event.ChildrenArchivalInitiated;
import org.cafienne.storage.archival.event.ModelActorArchived;
import org.cafienne.storage.archival.event.QueryDataArchived;
import org.cafienne.storage.archival.response.ArchivalRejected;
import org.cafienne.storage.archival.state.ArchivalState;
import org.cafienne.storage.archival.state.CaseArchivalState;
import org.cafienne.storage.archival.state.ProcessArchivalState;
import org.cafienne.storage.archive.Storage;
import org.cafienne.system.CaseSystem;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001B\n\u0015\u0001uA\u0001B\u000f\u0001\u0003\u0006\u0004%\te\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005y!A1\t\u0001BC\u0002\u0013\u0005C\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003F\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015a\u0007\u0001\"\u0001S\u0011\u0015i\u0007\u0001\"\u0001S\u0011\u0015q\u0007\u0001\"\u0001S\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015A\b\u0001\"\u0001S\u0011\u0015I\b\u0001\"\u0001{\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0005\u0001\t\u0003\n\u0019BA\tBGR|'\u000fR1uC\u0006\u00138\r[5wKJT!!\u0006\f\u0002\u0011\u0005\u00148\r[5wC2T!a\u0006\r\u0002\u000fM$xN]1hK*\u0011\u0011DG\u0001\tG\u00064\u0017.\u001a8oK*\t1$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001=\u0011\u0002\u0004CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\rE\u0002&Q)j\u0011A\n\u0006\u0003OY\t!\"Y2u_Jlw\u000eZ3m\u0013\tIcE\u0001\u0007Ti>\u0014\u0018mZ3BGR|'\u000f\u0005\u0002,]5\tAF\u0003\u0002.)\u0005)1\u000f^1uK&\u0011q\u0006\f\u0002\u000e\u0003J\u001c\u0007.\u001b<bYN#\u0018\r^3\u0011\u0005EBT\"\u0001\u001a\u000b\u0005M\"\u0014\u0001D:dC2\fGn\\4hS:<'BA\u001b7\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001c\u0002\u0007\r|W.\u0003\u0002:e\tYA*\u0019>z\u0019><w-\u001b8h\u0003)\u0019\u0017m]3TsN$X-\\\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011q\bG\u0001\u0007gf\u001cH/Z7\n\u0005\u0005s$AC\"bg\u0016\u001c\u0016p\u001d;f[\u0006Y1-Y:f'f\u001cH/Z7!\u0003!iW\r^1eCR\fW#A#\u0011\u0005\u00152\u0015BA$'\u00055\t5\r^8s\u001b\u0016$\u0018\rZ1uC\u0006IQ.\u001a;bI\u0006$\u0018\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007-ke\n\u0005\u0002M\u00015\tA\u0003C\u0003;\u000b\u0001\u0007A\bC\u0003D\u000b\u0001\u0007Q)A\u0006de\u0016\fG/Z*uCR,G#\u0001\u0016\u0002\u0011A|7\u000f^*u_B$\u0012a\u0015\t\u0003?QK!!\u0016\u0011\u0003\tUs\u0017\u000e^\u0001\u0016CJ\u001c\u0007.\u001b<f\u0007\"LG\u000eZ!di>\u0014H)\u0019;b)\t\u0019\u0006\fC\u0003Z\u0011\u0001\u0007Q)A\u0003dQ&dG-\u0001\thKR\u001c\u0005.\u001b7e\u0003\u000e$xN\u001d*fMR\u0011A\f\u001a\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\fQ!Y2u_JT\u0011!Y\u0001\u0005C.\\\u0017-\u0003\u0002d=\nA\u0011i\u0019;peJ+g\rC\u0003Z\u0013\u0001\u0007Q)\u0001\u000bdQ&dG-Q2u_J$VM]7j]\u0006$X\r\u001a\u000b\u0003'\u001eDQ\u0001\u001b\u0006A\u0002%\f\u0011\u0001\u001e\t\u0003;*L!a\u001b0\u0003\u0015Q+'/\\5oCR,G-A\tbe\u000eD\u0017N^1m\u0007>l\u0007\u000f\\3uK\u0012\f!$\u00194uKJlu\u000eZ3m\u0003\u000e$xN]#wK:$8\u000b^8sK\u0012\fA#\u00194uKJ\f%o\u00195jm\u0016,\u0005\u0010]8si\u0016$\u0017aE1gi\u0016\u0014\u0018I]2iSZ,7I]3bi\u0016$GCA*r\u0011\u0015\u0011h\u00021\u0001t\u0003\u0015)g/\u001a8u!\t!h/D\u0001v\u0015\t\u0011H#\u0003\u0002xk\nq\u0011I]2iSZ,7I]3bi\u0016$\u0017!D2sK\u0006$X-\u0011:dQ&4X-\u0001\twC2LG-\u0019;f\u0003J\u001c\u0007.\u001b<bYR\u00111k\u001f\u0005\u0006yB\u0001\r!`\u0001\bG>lW.\u00198e!\rq\u0018\u0011A\u0007\u0002\u007f*\u0011A\u0010F\u0005\u0004\u0003\u0007y(\u0001E!sG\"Lg/Z!di>\u0014H)\u0019;b\u0003Q\u0019wN\u001c4je6\u001c\u0005.\u001b7e\u0003J\u001c\u0007.\u001b<fIR\u00191+!\u0003\t\rI\f\u0002\u0019AA\u0006!\r!\u0018QB\u0005\u0004\u0003\u001f)(!D\"iS2$\u0017I]2iSZ,G-\u0001\bsK\u000e,\u0017N^3D_6l\u0017M\u001c3\u0016\u0005\u0005U\u0001\u0003BA\f\u00033i\u0011\u0001A\u0005\u0005\u00037\tiBA\u0004SK\u000e,\u0017N^3\n\u0007\u0005}aLA\u0003BGR|'\u000f")
public class ActorDataArchiver
implements StorageActor<ArchivalState> {
    private final CaseSystem caseSystem;
    private final ActorMetadata metadata;
    private ArchivalState state;
    private Map<String, ActorRef> children;
    private Map<String, Function0<BoxedUnit>> org$cafienne$storage$actormodel$StorageActor$$followups;
    private transient Logger logger;
    private Persistence akka$persistence$Eventsourced$$extension;
    private ActorRef journal;
    private ActorRef snapshotStore;
    private int akka$persistence$Eventsourced$$instanceId;
    private String akka$persistence$Eventsourced$$writerUuid;
    private Vector<PersistentEnvelope> akka$persistence$Eventsourced$$journalBatch;
    private int akka$persistence$Eventsourced$$maxMessageBatchSize;
    private boolean akka$persistence$Eventsourced$$writeInProgress;
    private long akka$persistence$Eventsourced$$sequenceNr;
    private long akka$persistence$Eventsourced$$_lastSequenceNr;
    private Eventsourced.State akka$persistence$Eventsourced$$currentState;
    private long akka$persistence$Eventsourced$$pendingStashingPersistInvocations;
    private LinkedList<Eventsourced.PendingHandlerInvocation> akka$persistence$Eventsourced$$pendingInvocations;
    private List<PersistentEnvelope> akka$persistence$Eventsourced$$eventBatch;
    private StashSupport akka$persistence$Eventsourced$$internalStash;
    private Function1<Object, Object> akka$persistence$Eventsourced$$unstashFilterPredicate;
    private Eventsourced.State akka$persistence$Eventsourced$$processingCommands;
    private Eventsourced.State akka$persistence$Eventsourced$$persistingEvents;
    private Vector<Envelope> akka$actor$StashSupport$$theStash;
    private int akka$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    private ActorContext context;
    private ActorRef self;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public String persistenceId() {
        return StorageActor.persistenceId$(this);
    }

    @Override
    public void clearState(long toSequenceNr) {
        StorageActor.clearState$(this, toSequenceNr);
    }

    @Override
    public long clearState$default$1() {
        return StorageActor.clearState$default$1$(this);
    }

    @Override
    public void printLogMessage(String msg) {
        StorageActor.printLogMessage$(this, msg);
    }

    @Override
    public void informCafienneGateway(String actorId, boolean needsResponse) {
        StorageActor.informCafienneGateway$((StorageActor)this, actorId, needsResponse);
    }

    @Override
    public boolean informCafienneGateway$default$2() {
        return StorageActor.informCafienneGateway$default$2$(this);
    }

    @Override
    public void informCafienneGateway(String actorId, Function0<BoxedUnit> followUpAction) {
        StorageActor.informCafienneGateway$((StorageActor)this, actorId, followUpAction);
    }

    @Override
    public void actorTerminated(ActorTerminated t) {
        StorageActor.actorTerminated$(this, t);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receiveRecover() {
        return StorageActor.receiveRecover$(this);
    }

    @Override
    public void storeEvent(StorageEvent event) {
        StorageActor.storeEvent$(this, event);
    }

    @Override
    public void triggerStorageProcess(StorageCommand command, StorageActionInitiated event) {
        StorageActor.triggerStorageProcess$(this, command, event);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return PersistentActor.receive$((PersistentActor)this);
    }

    public <A> void persist(A event, Function1<A, BoxedUnit> handler) {
        PersistentActor.persist$((PersistentActor)this, event, handler);
    }

    public <A> void persistAll(Seq<A> events, Function1<A, BoxedUnit> handler) {
        PersistentActor.persistAll$((PersistentActor)this, events, handler);
    }

    public <A> void persistAsync(A event, Function1<A, BoxedUnit> handler) {
        PersistentActor.persistAsync$((PersistentActor)this, event, handler);
    }

    public <A> void persistAllAsync(Seq<A> events, Function1<A, BoxedUnit> handler) {
        PersistentActor.persistAllAsync$((PersistentActor)this, events, handler);
    }

    public <A> void deferAsync(A event, Function1<A, BoxedUnit> handler) {
        PersistentActor.deferAsync$((PersistentActor)this, event, handler);
    }

    public <A> void defer(A event, Function1<A, BoxedUnit> handler) {
        PersistentActor.defer$((PersistentActor)this, event, handler);
    }

    public /* synthetic */ void akka$persistence$Eventsourced$$super$aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    public /* synthetic */ void akka$persistence$Eventsourced$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void akka$persistence$Eventsourced$$super$aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public /* synthetic */ void akka$persistence$Eventsourced$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void akka$persistence$Eventsourced$$super$unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public /* synthetic */ void akka$persistence$Eventsourced$$super$stash() {
        StashSupport.stash$((StashSupport)this);
    }

    public /* synthetic */ void akka$persistence$Eventsourced$$super$aroundReceive(PartialFunction receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive2, (Object)msg);
    }

    public String snapshotterId() {
        return Eventsourced.snapshotterId$((Eventsourced)this);
    }

    public long lastSequenceNr() {
        return Eventsourced.lastSequenceNr$((Eventsourced)this);
    }

    public long snapshotSequenceNr() {
        return Eventsourced.snapshotSequenceNr$((Eventsourced)this);
    }

    @InternalStableApi
    public void onReplaySuccess() {
        Eventsourced.onReplaySuccess$((Eventsourced)this);
    }

    public void onRecoveryFailure(Throwable cause, Option<Object> event) {
        Eventsourced.onRecoveryFailure$((Eventsourced)this, (Throwable)cause, event);
    }

    @InternalStableApi
    public void onPersistFailure(Throwable cause, Object event, long seqNr) {
        Eventsourced.onPersistFailure$((Eventsourced)this, (Throwable)cause, (Object)event, (long)seqNr);
    }

    @InternalStableApi
    public void onPersistRejected(Throwable cause, Object event, long seqNr) {
        Eventsourced.onPersistRejected$((Eventsourced)this, (Throwable)cause, (Object)event, (long)seqNr);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
        Eventsourced.aroundReceive$((Eventsourced)this, receive2, (Object)message);
    }

    public void aroundPreStart() {
        Eventsourced.aroundPreStart$((Eventsourced)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Eventsourced.aroundPreRestart$((Eventsourced)this, (Throwable)reason, message);
    }

    public void aroundPostRestart(Throwable reason) {
        Eventsourced.aroundPostRestart$((Eventsourced)this, (Throwable)reason);
    }

    public void aroundPostStop() {
        Eventsourced.aroundPostStop$((Eventsourced)this);
    }

    public void unhandled(Object message) {
        Eventsourced.unhandled$((Eventsourced)this, (Object)message);
    }

    @InternalApi
    public final <A> void internalPersist(A event, Function1<A, BoxedUnit> handler) {
        Eventsourced.internalPersist$((Eventsourced)this, event, handler);
    }

    @InternalApi
    public final <A> void internalPersistAll(Seq<A> events, Function1<A, BoxedUnit> handler) {
        Eventsourced.internalPersistAll$((Eventsourced)this, events, handler);
    }

    @InternalApi
    public final <A> void internalPersistAsync(A event, Function1<A, BoxedUnit> handler) {
        Eventsourced.internalPersistAsync$((Eventsourced)this, event, handler);
    }

    @InternalApi
    public final <A> void internalPersistAllAsync(Seq<A> events, Function1<A, BoxedUnit> handler) {
        Eventsourced.internalPersistAllAsync$((Eventsourced)this, events, handler);
    }

    @InternalApi
    public final <A> void internalDeferAsync(A event, Function1<A, BoxedUnit> handler) {
        Eventsourced.internalDeferAsync$((Eventsourced)this, event, handler);
    }

    @InternalApi
    public final <A> void internalDefer(A event, Function1<A, BoxedUnit> handler) {
        Eventsourced.internalDefer$((Eventsourced)this, event, handler);
    }

    public void deleteMessages(long toSequenceNr) {
        Eventsourced.deleteMessages$((Eventsourced)this, (long)toSequenceNr);
    }

    @InternalApi
    public void internalDeleteMessagesBeforeSnapshot(SaveSnapshotSuccess e, int keepNrOfBatches, int snapshotAfter) {
        Eventsourced.internalDeleteMessagesBeforeSnapshot$((Eventsourced)this, (SaveSnapshotSuccess)e, (int)keepNrOfBatches, (int)snapshotAfter);
    }

    public boolean recoveryRunning() {
        return Eventsourced.recoveryRunning$((Eventsourced)this);
    }

    public boolean recoveryFinished() {
        return Eventsourced.recoveryFinished$((Eventsourced)this);
    }

    public void stash() {
        Eventsourced.stash$((Eventsourced)this);
    }

    public void unstashAll() {
        Eventsourced.unstashAll$((Eventsourced)this);
    }

    public Recovery recovery() {
        return PersistenceRecovery.recovery$((PersistenceRecovery)this);
    }

    public String journalPluginId() {
        return PersistenceIdentity.journalPluginId$((PersistenceIdentity)this);
    }

    public String snapshotPluginId() {
        return PersistenceIdentity.snapshotPluginId$((PersistenceIdentity)this);
    }

    public StashOverflowStrategy internalStashOverflowStrategy() {
        return PersistenceStash.internalStashOverflowStrategy$((PersistenceStash)this);
    }

    public StashSupport createStash(ActorContext ctx, ActorRef ref) {
        return StashFactory.createStash$((StashFactory)this, (ActorContext)ctx, (ActorRef)ref);
    }

    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        UnrestrictedStash.preRestart$((UnrestrictedStash)this, (Throwable)reason, message);
    }

    public void prepend(Seq<Envelope> others) {
        StashSupport.prepend$((StashSupport)this, others);
    }

    public void unstash() {
        StashSupport.unstash$((StashSupport)this);
    }

    @InternalStableApi
    public void unstashAll(Function1<Object, Object> filterPredicate) {
        StashSupport.unstashAll$((StashSupport)this, filterPredicate);
    }

    @InternalStableApi
    public Vector<Envelope> clearStash() {
        return StashSupport.clearStash$((StashSupport)this);
    }

    public void loadSnapshot(String persistenceId, SnapshotSelectionCriteria criteria, long toSequenceNr) {
        Snapshotter.loadSnapshot$((Snapshotter)this, (String)persistenceId, (SnapshotSelectionCriteria)criteria, (long)toSequenceNr);
    }

    public void saveSnapshot(Object snapshot) {
        Snapshotter.saveSnapshot$((Snapshotter)this, (Object)snapshot);
    }

    public void deleteSnapshot(long sequenceNr) {
        Snapshotter.deleteSnapshot$((Snapshotter)this, (long)sequenceNr);
    }

    public void deleteSnapshots(SnapshotSelectionCriteria criteria) {
        Snapshotter.deleteSnapshots$((Snapshotter)this, (SnapshotSelectionCriteria)criteria);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    @Override
    public ArchivalState state() {
        return this.state;
    }

    @Override
    public Map<String, ActorRef> children() {
        return this.children;
    }

    @Override
    public Map<String, Function0<BoxedUnit>> org$cafienne$storage$actormodel$StorageActor$$followups() {
        return this.org$cafienne$storage$actormodel$StorageActor$$followups;
    }

    @Override
    public void org$cafienne$storage$actormodel$StorageActor$_setter_$state_$eq(ArchivalState x$1) {
        this.state = x$1;
    }

    @Override
    public void org$cafienne$storage$actormodel$StorageActor$_setter_$children_$eq(Map<String, ActorRef> x$1) {
        this.children = x$1;
    }

    @Override
    public final void org$cafienne$storage$actormodel$StorageActor$_setter_$org$cafienne$storage$actormodel$StorageActor$$followups_$eq(Map<String, Function0<BoxedUnit>> x$1) {
        this.org$cafienne$storage$actormodel$StorageActor$$followups = x$1;
    }

    private Logger logger$lzycompute() {
        ActorDataArchiver actorDataArchiver = this;
        synchronized (actorDataArchiver) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Persistence akka$persistence$Eventsourced$$extension() {
        return this.akka$persistence$Eventsourced$$extension;
    }

    private ActorRef journal$lzycompute() {
        ActorDataArchiver actorDataArchiver = this;
        synchronized (actorDataArchiver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.journal = Eventsourced.journal$((Eventsourced)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.journal;
    }

    public ActorRef journal() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.journal$lzycompute() : this.journal;
    }

    private ActorRef snapshotStore$lzycompute() {
        ActorDataArchiver actorDataArchiver = this;
        synchronized (actorDataArchiver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.snapshotStore = Eventsourced.snapshotStore$((Eventsourced)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.snapshotStore;
    }

    public ActorRef snapshotStore() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.snapshotStore$lzycompute() : this.snapshotStore;
    }

    public int akka$persistence$Eventsourced$$instanceId() {
        return this.akka$persistence$Eventsourced$$instanceId;
    }

    public String akka$persistence$Eventsourced$$writerUuid() {
        return this.akka$persistence$Eventsourced$$writerUuid;
    }

    public Vector<PersistentEnvelope> akka$persistence$Eventsourced$$journalBatch() {
        return this.akka$persistence$Eventsourced$$journalBatch;
    }

    public void akka$persistence$Eventsourced$$journalBatch_$eq(Vector<PersistentEnvelope> x$1) {
        this.akka$persistence$Eventsourced$$journalBatch = x$1;
    }

    public int akka$persistence$Eventsourced$$maxMessageBatchSize() {
        return this.akka$persistence$Eventsourced$$maxMessageBatchSize;
    }

    public boolean akka$persistence$Eventsourced$$writeInProgress() {
        return this.akka$persistence$Eventsourced$$writeInProgress;
    }

    public void akka$persistence$Eventsourced$$writeInProgress_$eq(boolean x$1) {
        this.akka$persistence$Eventsourced$$writeInProgress = x$1;
    }

    public long akka$persistence$Eventsourced$$sequenceNr() {
        return this.akka$persistence$Eventsourced$$sequenceNr;
    }

    public void akka$persistence$Eventsourced$$sequenceNr_$eq(long x$1) {
        this.akka$persistence$Eventsourced$$sequenceNr = x$1;
    }

    public long akka$persistence$Eventsourced$$_lastSequenceNr() {
        return this.akka$persistence$Eventsourced$$_lastSequenceNr;
    }

    public void akka$persistence$Eventsourced$$_lastSequenceNr_$eq(long x$1) {
        this.akka$persistence$Eventsourced$$_lastSequenceNr = x$1;
    }

    public Eventsourced.State akka$persistence$Eventsourced$$currentState() {
        return this.akka$persistence$Eventsourced$$currentState;
    }

    public void akka$persistence$Eventsourced$$currentState_$eq(Eventsourced.State x$1) {
        this.akka$persistence$Eventsourced$$currentState = x$1;
    }

    public long akka$persistence$Eventsourced$$pendingStashingPersistInvocations() {
        return this.akka$persistence$Eventsourced$$pendingStashingPersistInvocations;
    }

    public void akka$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(long x$1) {
        this.akka$persistence$Eventsourced$$pendingStashingPersistInvocations = x$1;
    }

    public LinkedList<Eventsourced.PendingHandlerInvocation> akka$persistence$Eventsourced$$pendingInvocations() {
        return this.akka$persistence$Eventsourced$$pendingInvocations;
    }

    public List<PersistentEnvelope> akka$persistence$Eventsourced$$eventBatch() {
        return this.akka$persistence$Eventsourced$$eventBatch;
    }

    public void akka$persistence$Eventsourced$$eventBatch_$eq(List<PersistentEnvelope> x$1) {
        this.akka$persistence$Eventsourced$$eventBatch = x$1;
    }

    public StashSupport akka$persistence$Eventsourced$$internalStash() {
        return this.akka$persistence$Eventsourced$$internalStash;
    }

    public Function1<Object, Object> akka$persistence$Eventsourced$$unstashFilterPredicate() {
        return this.akka$persistence$Eventsourced$$unstashFilterPredicate;
    }

    public Eventsourced.State akka$persistence$Eventsourced$$processingCommands() {
        return this.akka$persistence$Eventsourced$$processingCommands;
    }

    public Eventsourced.State akka$persistence$Eventsourced$$persistingEvents() {
        return this.akka$persistence$Eventsourced$$persistingEvents;
    }

    public final void akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$extension_$eq(Persistence x$1) {
        this.akka$persistence$Eventsourced$$extension = x$1;
    }

    public final void akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$instanceId_$eq(int x$1) {
        this.akka$persistence$Eventsourced$$instanceId = x$1;
    }

    public final void akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$writerUuid_$eq(String x$1) {
        this.akka$persistence$Eventsourced$$writerUuid = x$1;
    }

    public final void akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$maxMessageBatchSize_$eq(int x$1) {
        this.akka$persistence$Eventsourced$$maxMessageBatchSize = x$1;
    }

    public final void akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$pendingInvocations_$eq(LinkedList<Eventsourced.PendingHandlerInvocation> x$1) {
        this.akka$persistence$Eventsourced$$pendingInvocations = x$1;
    }

    public final void akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$internalStash_$eq(StashSupport x$1) {
        this.akka$persistence$Eventsourced$$internalStash = x$1;
    }

    public final void akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$unstashFilterPredicate_$eq(Function1<Object, Object> x$1) {
        this.akka$persistence$Eventsourced$$unstashFilterPredicate = x$1;
    }

    public final void akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$processingCommands_$eq(Eventsourced.State x$1) {
        this.akka$persistence$Eventsourced$$processingCommands = x$1;
    }

    public final void akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$persistingEvents_$eq(Eventsourced.State x$1) {
        this.akka$persistence$Eventsourced$$persistingEvents = x$1;
    }

    public Vector<Envelope> akka$actor$StashSupport$$theStash() {
        return this.akka$actor$StashSupport$$theStash;
    }

    public void akka$actor$StashSupport$$theStash_$eq(Vector<Envelope> x$1) {
        this.akka$actor$StashSupport$$theStash = x$1;
    }

    public int akka$actor$StashSupport$$capacity() {
        return this.akka$actor$StashSupport$$capacity;
    }

    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public final void akka$actor$StashSupport$_setter_$akka$actor$StashSupport$$capacity_$eq(int x$1) {
        this.akka$actor$StashSupport$$capacity = x$1;
    }

    public void akka$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$1) {
        this.mailbox = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    @Override
    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    @Override
    public ActorMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ArchivalState createState() {
        ArchivalState archivalState;
        String string = this.metadata().actorType();
        String string2 = ActorType$.MODULE$.Case();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            archivalState = new CaseArchivalState(this);
        } else {
            String string4 = ActorType$.MODULE$.Process();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                archivalState = new ProcessArchivalState(this);
            } else {
                throw new RuntimeException("Cannot handle archival of data on actor type " + this.metadata());
            }
        }
        return archivalState;
    }

    public void postStop() {
        if (this.metadata().hasParent()) {
            this.printLogMessage("========== Finished Storage Archival for " + this.metadata() + " (child of " + this.metadata().parent().path() + ")\n");
        } else {
            this.printLogMessage("========== Finished Storage Archival for " + this.metadata() + "\n");
        }
    }

    public void archiveChildActorData(ActorMetadata child) {
        this.printLogMessage("Initiating deletion for child actor " + child);
        this.informCafienneGateway(child.actorId(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.getChildActorRef(child).tell((Object)new ArchiveActorData(child), this.self()));
    }

    public ActorRef getChildActorRef(ActorMetadata child) {
        return (ActorRef)this.children().getOrElseUpdate((Object)child.actorId(), (Function0 & Serializable)() -> this.context().watch(this.context().actorOf(Props$.MODULE$.apply(ActorDataArchiver.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.caseSystem(), child})), child.actorId())));
    }

    public void childActorTerminated(Terminated t) {
        BoxedUnit boxedUnit;
        String actorId = t.actor().path().name();
        if (this.children().remove((Object)actorId).isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Received a Termination message for actor " + actorId + ", but it was not registered in the LocalRoutingService. Termination message is ignored");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.informCafienneGateway(actorId, this.informCafienneGateway$default$2());
    }

    public void archivalCompleted() {
        this.context().stop(this.self());
    }

    public void afterModelActorEventStored() {
        block0: {
            if (!this.state().events().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ActorDataArchiver.$anonfun$afterModelActorEventStored$1(x$1)))) break block0;
            this.clearState(this.lastSequenceNr() - 1L);
        }
    }

    public void afterArchiveExported() {
        this.printLogMessage("Found acknowledgement that our archive has been exported");
        this.storeEvent(((ArchivalState)this.state()).createModelActorEvent());
    }

    public void afterArchiveCreated(ArchiveCreated event) {
        if (this.metadata().isRoot()) {
            ExecutionContextExecutor ec = this.caseSystem().system().dispatcher();
            Storage storage = Cafienne$.MODULE$.config().engine().storage().archive().plugin();
            storage.store(event.archive()).map((Function1 & Serializable)x$2 -> {
                ActorDataArchiver.$anonfun$afterArchiveCreated$1(this, event, x$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ec);
        } else {
            this.context().parent().$bang((Object)new ChildArchived(this.metadata(), event.archive(), ChildArchived$.MODULE$.apply$default$3()), this.self());
        }
    }

    public void createArchive() {
        this.storeEvent(((ArchivalState)this.state()).createArchiveEvent());
    }

    public void validateArchival(ArchiveActorData command) {
        if (this.lastSequenceNr() == 0L) {
            this.printLogMessage("Actor has not recovered any events. Probably does not exist at all");
            this.sender().$bang((Object)new ArchivalRejected(command.metadata(), "Actor does not exist in the event journal"), this.self());
        } else if (this.state().events().nonEmpty() && !this.state().hasExpectedEvents()) {
            this.printLogMessage("State does not match expected actor type " + this.metadata() + "; state contains: " + this.state().actualModelActorType());
            this.sender().$bang((Object)new ArchivalRejected(command.metadata(), "Expected actor " + this.metadata() + "; Found: " + this.state().actualModelActorType()), this.self());
        } else if (((ArchivalState)this.state()).isCleared()) {
            this.afterModelActorEventStored();
        } else if (((ArchivalState)this.state()).isExported()) {
            this.printLogMessage("Our parent is aware that we are archived, but we have not yet cleaned up ourself, doing that now");
            this.afterArchiveExported();
        } else if (((ArchivalState)this.state()).isCreated()) {
            this.afterArchiveCreated(((ArchivalState)this.state()).archive());
        } else {
            this.triggerStorageProcess(command, new ArchivalInitiated(command.metadata(), ArchivalInitiated$.MODULE$.apply$default$2()));
        }
    }

    public void confirmChildArchived(ChildArchived event) {
        ActorMetadata child = event.metadata();
        this.printLogMessage("Received archive for child " + child + "; sending acknowledgement");
        this.getChildActorRef(child).tell((Object)new ArchiveExported(child, ArchiveExported$.MODULE$.apply$default$2()), this.self());
    }

    public PartialFunction<Object, BoxedUnit> receiveCommand() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorDataArchiver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (A1 instanceof ArchiveActorData) {
                    ArchiveActorData archiveActorData = (ArchiveActorData)A1;
                    this.$outer.validateArchival(archiveActorData);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof ChildrenArchivalInitiated) {
                    ChildrenArchivalInitiated childrenArchivalInitiated = (ChildrenArchivalInitiated)A1;
                    this.$outer.storeEvent(childrenArchivalInitiated);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof QueryDataArchived) {
                    QueryDataArchived queryDataArchived = (QueryDataArchived)A1;
                    this.$outer.storeEvent(queryDataArchived);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof ChildArchived) {
                    ChildArchived childArchived = (ChildArchived)A1;
                    this.$outer.storeEvent(childArchived);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof ArchiveExported) {
                    ArchiveExported archiveExported = (ArchiveExported)A1;
                    this.$outer.storeEvent(archiveExported);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof ArchivalInitiated) {
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof DeleteMessagesSuccess) {
                    this.$outer.archivalCompleted();
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof Terminated) {
                    Terminated terminated = (Terminated)A1;
                    this.$outer.childActorTerminated(terminated);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (A1 instanceof ActorTerminated) {
                    ActorTerminated actorTerminated = (ActorTerminated)A1;
                    this.$outer.actorTerminated(actorTerminated);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.printLogMessage("Received message with unknown type. Ignoring it. Message is of type " + A1.getClass().getName());
                    boxedUnit = BoxedUnit.UNIT;
                }
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ArchiveActorData ? true : (object instanceof ChildrenArchivalInitiated ? true : (object instanceof QueryDataArchived ? true : (object instanceof ChildArchived ? true : (object instanceof ArchiveExported ? true : (object instanceof ArchivalInitiated ? true : (object instanceof DeleteMessagesSuccess ? true : (object instanceof Terminated ? true : (object instanceof ActorTerminated ? true : true))))))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$afterModelActorEventStored$1(ModelEvent x$1) {
        return x$1 instanceof ModelActorArchived;
    }

    public static final /* synthetic */ void $anonfun$afterArchiveCreated$1(ActorDataArchiver $this, ArchiveCreated event$1, Done x$2) {
        $this.self().$bang((Object)new ArchiveExported(event$1.metadata(), ArchiveExported$.MODULE$.apply$default$2()), $this.self());
    }

    public ActorDataArchiver(CaseSystem caseSystem, ActorMetadata metadata) {
        this.caseSystem = caseSystem;
        this.metadata = metadata;
        Actor.$init$((Actor)this);
        Snapshotter.$init$((Snapshotter)this);
        StashSupport.$init$((StashSupport)this);
        UnrestrictedStash.$init$((UnrestrictedStash)this);
        StashFactory.$init$((StashFactory)this);
        PersistenceStash.$init$((PersistenceStash)this);
        PersistenceIdentity.$init$((PersistenceIdentity)this);
        PersistenceRecovery.$init$((PersistenceRecovery)this);
        Eventsourced.$init$((Eventsourced)this);
        PersistentActor.$init$((PersistentActor)this);
        LazyLogging.$init$((LazyLogging)this);
        StorageActor.$init$(this);
        this.printLogMessage("\n========== Launching Storage Archival Service " + metadata.path());
        Statics.releaseFence();
    }
}

