/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.storage.archival.state;

import akka.Done;
import akka.actor.ActorRef;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.json.ValueList;
import org.cafienne.json.ValueMap;
import org.cafienne.storage.actormodel.ActorMetadata;
import org.cafienne.storage.actormodel.StorageActorState;
import org.cafienne.storage.actormodel.message.StorageEvent;
import org.cafienne.storage.archival.ActorDataArchiver;
import org.cafienne.storage.archival.Archive;
import org.cafienne.storage.archival.ModelEventSerializer$;
import org.cafienne.storage.archival.event.ArchivalInitiated;
import org.cafienne.storage.archival.event.ArchiveCreated;
import org.cafienne.storage.archival.event.ArchiveCreated$;
import org.cafienne.storage.archival.event.ArchiveExported;
import org.cafienne.storage.archival.event.ChildArchived;
import org.cafienne.storage.archival.event.ChildrenArchivalInitiated;
import org.cafienne.storage.archival.event.ChildrenArchivalInitiated$;
import org.cafienne.storage.archival.event.ModelActorArchived;
import org.cafienne.storage.archival.event.QueryDataArchived;
import org.cafienne.storage.archival.event.QueryDataArchived$;
import org.cafienne.storage.querydb.QueryDBStorage;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005eda\u0002\u000e\u001c!\u0003\r\tA\n\u0005\u0006{\u0001!\tA\u0010\u0005\b\u0005\u0002\u0011\rQ\"\u0011D\u0011\u0015A\u0005A\"\u0001J\u0011\u0015\u0001\u0006\u0001b\u0001R\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00159\u0007\u0001\"\u0001d\u0011\u0015A\u0007\u0001\"\u0001d\u0011\u0015I\u0007A\"\u0001k\u0011\u0015!\b\u0001\"\u0011?\u0011\u0015)\b\u0001\"\u0001?\u0011\u00151\b\u0001\"\u0001?\u0011\u00159\b\u0001\"\u0001d\u0011\u0015A\b\u0001\"\u0001z\u0011\u0019\t\u0019\u0002\u0001C\u0001s\"9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001BBA\u000f\u0001\u0011\u00051\r\u0003\u0004\u0002 \u0001!\tA\u0010\u0005\u0007\u0003C\u0001A\u0011A2\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA\u001f\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!a\u001c\u0001\r\u0003\t\tHA\u0007Be\u000eD\u0017N^1m'R\fG/\u001a\u0006\u00039u\tQa\u001d;bi\u0016T!AH\u0010\u0002\u0011\u0005\u00148\r[5wC2T!\u0001I\u0011\u0002\u000fM$xN]1hK*\u0011!eI\u0001\tG\u00064\u0017.\u001a8oK*\tA%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001O5\u001a\u0004C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/c5\tqF\u0003\u00021?\u0005Q\u0011m\u0019;pe6|G-\u001a7\n\u0005Iz#!E*u_J\fw-Z!di>\u00148\u000b^1uKB\u0011AgO\u0007\u0002k)\u0011agN\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003qe\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002u\u0005\u00191m\\7\n\u0005q*$a\u0003'bufdunZ4j]\u001e\fa\u0001J5oSR$C#A \u0011\u0005!\u0002\u0015BA!*\u0005\u0011)f.\u001b;\u0002\u000b\u0005\u001cGo\u001c:\u0016\u0003\u0011\u0003\"!\u0012$\u000e\u0003uI!aR\u000f\u0003#\u0005\u001bGo\u001c:ECR\f\u0017I]2iSZ,'/A\u0005eEN#xN]1hKV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N?\u00059\u0011/^3ss\u0012\u0014\u0017BA(M\u00059\tV/\u001a:z\t\n\u001bFo\u001c:bO\u0016\f!\u0002Z5ta\u0006$8\r[3s+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+*\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003/R\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002%!\fg\u000e\u001a7f'R|'/Y4f\u000bZ,g\u000e\u001e\u000b\u0003\u007fiCQaW\u0003A\u0002q\u000bQ!\u001a<f]R\u0004\"!\u00181\u000e\u0003yS!aX\u0018\u0002\u000f5,7o]1hK&\u0011\u0011M\u0018\u0002\r'R|'/Y4f\u000bZ,g\u000e^\u0001\nSN\u001c%/Z1uK\u0012,\u0012\u0001\u001a\t\u0003Q\u0015L!AZ\u0015\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0011n]#ya>\u0014H/\u001a3\u0002\u0013%\u001c8\t\\3be\u0016$\u0017\u0001E1sG\"Lg/Z)vKJLH)\u0019;b)\u0005Y\u0007cA*m]&\u0011Q\u000e\u0016\u0002\u0007\rV$XO]3\u0011\u0005=\u0014X\"\u00019\u000b\u0003E\fA!Y6lC&\u00111\u000f\u001d\u0002\u0005\t>tW-\u0001\fd_:$\u0018N\\;f'R|'/Y4f!J|7-Z:t\u0003m!(/[4hKJ\u001c\u0005.\u001b7e\u0003J\u001c\u0007.\u001b<bYB\u0013xnY3tg\u0006aBO]5hO\u0016\u0014\u0018+^3ss\u0012\u00135\t\\3b]V\u0004\bK]8dKN\u001c\u0018!G2iS2$'/\u001a8NKR\fG-\u0019;b\u0003Z\f\u0017\u000e\\1cY\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002uB)10a\u0002\u0002\u000e9\u0019A0a\u0001\u000f\u0007u\f\t!D\u0001\u007f\u0015\tyX%\u0001\u0004=e>|GOP\u0005\u0002U%\u0019\u0011QA\u0015\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000bI\u0003c\u0001\u0018\u0002\u0010%\u0019\u0011\u0011C\u0018\u0003\u001b\u0005\u001bGo\u001c:NKR\fG-\u0019;b\u0003U\u0001XM\u001c3j]\u001e\u001c\u0005.\u001b7e\u0003J\u001c\u0007.\u001b<bYN\f\u0011#[:BYJ,\u0017\rZ=Be\u000eD\u0017N^3e)\r!\u0017\u0011\u0004\u0005\b\u00037\u0001\u0002\u0019AA\u0007\u0003\u0015\u0019\u0007.\u001b7e\u0003E\tX/\u001a:z\t\u0006$\u0018-\u0011:dQ&4X\rZ\u0001\u0013G\",7m[!sG\"Lg/\u001b8h\t>tW-\u0001\fdQ&dG-\u0011:dQ&4Xm]!wC&d\u0017M\u00197f\u00035\u0019\u0007.\u001b7e\u0003J\u001c\u0007.\u001b<fgV\u0011\u0011q\u0005\t\u0006w\u0006\u001d\u0011\u0011\u0006\t\u0004\u000b\u0006-\u0012bAA\u0017;\t9\u0011I]2iSZ,\u0017AE2sK\u0006$X-\u0011:dQ&4X-\u0012<f]R,\"!a\r\u0011\t\u0005U\u0012\u0011H\u0007\u0003\u0003oQ!aW\u000f\n\t\u0005m\u0012q\u0007\u0002\u000f\u0003J\u001c\u0007.\u001b<f\u0007J,\u0017\r^3e\u0003\u001d\t'o\u00195jm\u0016\fQb\u0019:fCR,\u0017I]2iSZ,WCAA\u0015\u0003Q\u0019XM]5bY&TX-\u0012<f]R$vNS:p]R!\u0011qIA*!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'C\u0005!!n]8o\u0013\u0011\t\t&a\u0013\u0003\u0011Y\u000bG.^3NCBDq!!\u0016\u0019\u0001\u0004\t9&A\u0004fY\u0016lWM\u001c;\u0011\u000f!\nI&!\u0018\u0002j%\u0019\u00111L\u0015\u0003\rQ+\b\u000f\\33!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bA.\u0002d)\u0011\u0001'I\u0005\u0005\u0003O\n\tG\u0001\u0006N_\u0012,G.\u0012<f]R\u00042\u0001KA6\u0013\r\ti'\u000b\u0002\u0004\u0013:$\u0018!F2sK\u0006$X-T8eK2\f5\r^8s\u000bZ,g\u000e^\u000b\u0003\u0003g\u0002B!!\u000e\u0002v%!\u0011qOA\u001c\u0005Iiu\u000eZ3m\u0003\u000e$xN]!sG\"Lg/\u001a3")
public interface ArchivalState
extends StorageActorState,
LazyLogging {
    public ActorDataArchiver actor();

    public QueryDBStorage dbStorage();

    public static /* synthetic */ ExecutionContext dispatcher$(ArchivalState $this) {
        return $this.dispatcher();
    }

    default public ExecutionContext dispatcher() {
        return this.dbStorage().dispatcher();
    }

    public static /* synthetic */ void handleStorageEvent$(ArchivalState $this, StorageEvent event) {
        $this.handleStorageEvent(event);
    }

    @Override
    default public void handleStorageEvent(StorageEvent event) {
        StorageEvent storageEvent = event;
        if (storageEvent instanceof ArchivalInitiated) {
            ArchivalInitiated archivalInitiated = (ArchivalInitiated)storageEvent;
            this.printLogMessage("Starting archival for " + archivalInitiated.metadata());
            this.continueStorageProcess();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (storageEvent instanceof ChildrenArchivalInitiated) {
            this.triggerChildArchivalProcess();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (storageEvent instanceof QueryDataArchived) {
            this.printLogMessage("QueryDB has been archived");
            this.checkArchivingDone();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (storageEvent instanceof ChildArchived) {
            ChildArchived childArchived = (ChildArchived)storageEvent;
            this.actor().confirmChildArchived(childArchived);
            this.checkArchivingDone();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (storageEvent instanceof ArchiveCreated) {
            ArchiveCreated archiveCreated = (ArchiveCreated)storageEvent;
            this.actor().afterArchiveCreated(archiveCreated);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (storageEvent instanceof ArchiveExported) {
            this.actor().afterArchiveExported();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (storageEvent instanceof ModelActorArchived) {
            this.actor().afterModelActorEventStored();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Cannot handle event of type {} in {}[{}]", new Object[]{storageEvent.getClass().getName(), this.actor().getClass().getSimpleName(), storageEvent.actorId()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static /* synthetic */ boolean isCreated$(ArchivalState $this) {
        return $this.isCreated();
    }

    default public boolean isCreated() {
        return this.events().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$isCreated$1(x$1)));
    }

    public static /* synthetic */ boolean isExported$(ArchivalState $this) {
        return $this.isExported();
    }

    default public boolean isExported() {
        return this.events().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$isExported$1(x$2)));
    }

    public static /* synthetic */ boolean isCleared$(ArchivalState $this) {
        return $this.isCleared();
    }

    default public boolean isCleared() {
        return this.events().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$isCleared$1(x$3)));
    }

    public Future<Done> archiveQueryData();

    public static /* synthetic */ void continueStorageProcess$(ArchivalState $this) {
        $this.continueStorageProcess();
    }

    @Override
    default public void continueStorageProcess() {
        this.triggerChildArchivalProcess();
        this.triggerQueryDBCleanupProcess();
    }

    public static /* synthetic */ void triggerChildArchivalProcess$(ArchivalState $this) {
        $this.triggerChildArchivalProcess();
    }

    default public void triggerChildArchivalProcess() {
        if (!this.childrenMetadataAvailable()) {
            this.findCascadingChildren().map((Function1 & Serializable)children -> {
                ArchivalState.$anonfun$triggerChildArchivalProcess$1(this, children);
                return BoxedUnit.UNIT;
            }, this.dispatcher());
        } else if (this.pendingChildArchivals().nonEmpty()) {
            this.printLogMessage("Found " + this.pendingChildArchivals().size() + " out of " + this.children().size() + " children with pending archival");
            this.pendingChildArchivals().foreach((Function1 & Serializable)child -> {
                ArchivalState.$anonfun$triggerChildArchivalProcess$2(this, child);
                return BoxedUnit.UNIT;
            });
        } else {
            this.printLogMessage("No children found that have pending archival");
            this.checkArchivingDone();
        }
    }

    public static /* synthetic */ void triggerQueryDBCleanupProcess$(ArchivalState $this) {
        $this.triggerQueryDBCleanupProcess();
    }

    default public void triggerQueryDBCleanupProcess() {
        BoxedUnit boxedUnit;
        if (!this.queryDataArchived()) {
            this.printLogMessage("Archiving query data");
            boxedUnit = this.archiveQueryData().map((Function1 & Serializable)x$4 -> {
                ArchivalState.$anonfun$triggerQueryDBCleanupProcess$1(this, x$4);
                return BoxedUnit.UNIT;
            }, this.dispatcher());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.checkArchivingDone();
    }

    public static /* synthetic */ boolean childrenMetadataAvailable$(ArchivalState $this) {
        return $this.childrenMetadataAvailable();
    }

    default public boolean childrenMetadataAvailable() {
        return this.events().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$childrenMetadataAvailable$1(x$5)));
    }

    public static /* synthetic */ Seq children$(ArchivalState $this) {
        return $this.children();
    }

    default public Seq<ActorMetadata> children() {
        return (Seq)this.eventsOfType(ChildrenArchivalInitiated.class).flatMap((Function1 & Serializable)x$6 -> x$6.members());
    }

    public static /* synthetic */ Seq pendingChildArchivals$(ArchivalState $this) {
        return $this.pendingChildArchivals();
    }

    default public Seq<ActorMetadata> pendingChildArchivals() {
        return (Seq)this.children().filterNot((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)this.isAlreadyArchived(child)));
    }

    public static /* synthetic */ boolean isAlreadyArchived$(ArchivalState $this, ActorMetadata child) {
        return $this.isAlreadyArchived(child);
    }

    default public boolean isAlreadyArchived(ActorMetadata child) {
        return this.eventsOfType(ChildArchived.class).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$isAlreadyArchived$1(child, x$7)));
    }

    public static /* synthetic */ boolean queryDataArchived$(ArchivalState $this) {
        return $this.queryDataArchived();
    }

    default public boolean queryDataArchived() {
        return this.events().exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$queryDataArchived$1(x$8)));
    }

    public static /* synthetic */ void checkArchivingDone$(ArchivalState $this) {
        $this.checkArchivingDone();
    }

    default public void checkArchivingDone() {
        block0: {
            this.printLogMessage("Running completion check: [queryDataCleared=" + this.queryDataArchived() + "; childrenMetadataAvailable=" + this.childrenMetadataAvailable() + "; children archived=" + (this.children().size() - this.pendingChildArchivals().size()) + ", pending=" + this.pendingChildArchivals().size() + "]");
            if (!this.childArchivesAvailable() || !this.queryDataArchived() || this.isCreated()) break block0;
            this.actor().storeEvent(this.createArchiveEvent());
        }
    }

    public static /* synthetic */ boolean childArchivesAvailable$(ArchivalState $this) {
        return $this.childArchivesAvailable();
    }

    default public boolean childArchivesAvailable() {
        return this.childrenMetadataAvailable() && this.pendingChildArchivals().isEmpty();
    }

    public static /* synthetic */ Seq childArchives$(ArchivalState $this) {
        return $this.childArchives();
    }

    default public Seq<Archive> childArchives() {
        return (Seq)this.eventsOfType(ChildArchived.class).map((Function1 & Serializable)x$9 -> x$9.archive());
    }

    public static /* synthetic */ ArchiveCreated createArchiveEvent$(ArchivalState $this) {
        return $this.createArchiveEvent();
    }

    default public ArchiveCreated createArchiveEvent() {
        this.printLogMessage("Starting final step to delete ourselves from event journal");
        Archive archive = this.createArchive();
        return new ArchiveCreated(this.metadata(), archive, ArchiveCreated$.MODULE$.apply$default$3());
    }

    public static /* synthetic */ ArchiveCreated archive$(ArchivalState $this) {
        return $this.archive();
    }

    default public ArchiveCreated archive() {
        return (ArchiveCreated)this.events().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ArchivalState.$anonfun$archive$1(x$10))).get();
    }

    public static /* synthetic */ Archive createArchive$(ArchivalState $this) {
        return $this.createArchive();
    }

    default public Archive createArchive() {
        ValueList list = new ValueList(new Object[0]);
        ((IterableOnceOps)((IterableOps)this.originalModelActorEvents().zipWithIndex()).map((Function1 & Serializable)element -> this.serializeEventToJson((Tuple2<ModelEvent, Object>)element))).foreach((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)list.add(e)));
        return new Archive(this.metadata(), list, this.childArchives());
    }

    public static /* synthetic */ ValueMap serializeEventToJson$(ArchivalState $this, Tuple2 element) {
        return $this.serializeEventToJson((Tuple2<ModelEvent, Object>)element);
    }

    default public ValueMap serializeEventToJson(Tuple2<ModelEvent, Object> element) {
        return ModelEventSerializer$.MODULE$.serializeEventToJson((ModelEvent)element._1(), element._2$mcI$sp() + 1);
    }

    public ModelActorArchived createModelActorEvent();

    public static /* synthetic */ boolean $anonfun$isCreated$1(ModelEvent x$1) {
        return x$1 instanceof ArchiveCreated;
    }

    public static /* synthetic */ boolean $anonfun$isExported$1(ModelEvent x$2) {
        return x$2 instanceof ArchiveExported;
    }

    public static /* synthetic */ boolean $anonfun$isCleared$1(ModelEvent x$3) {
        return x$3 instanceof ModelActorArchived;
    }

    public static /* synthetic */ void $anonfun$triggerChildArchivalProcess$1(ArchivalState $this, Seq children) {
        $this.printLogMessage("Found " + children.length() + " children to be archived: " + children.mkString("\n--- ", "\n--- ", ""));
        ChildrenArchivalInitiated x$1 = new ChildrenArchivalInitiated($this.actor().metadata(), (Seq<ActorMetadata>)children, ChildrenArchivalInitiated$.MODULE$.apply$default$3());
        ActorRef x$2 = $this.actor().self().$bang$default$2((Object)x$1);
        $this.actor().self().$bang((Object)x$1, x$2);
    }

    public static /* synthetic */ void $anonfun$triggerChildArchivalProcess$2(ArchivalState $this, ActorMetadata child) {
        $this.actor().archiveChildActorData(child);
    }

    public static /* synthetic */ void $anonfun$triggerQueryDBCleanupProcess$1(ArchivalState $this, Done x$4) {
        QueryDataArchived x$1 = new QueryDataArchived($this.metadata(), QueryDataArchived$.MODULE$.apply$default$2());
        ActorRef x$2 = $this.actor().self().$bang$default$2((Object)x$1);
        $this.actor().self().$bang((Object)x$1, x$2);
    }

    public static /* synthetic */ boolean $anonfun$childrenMetadataAvailable$1(ModelEvent x$5) {
        return x$5 instanceof ChildrenArchivalInitiated;
    }

    public static /* synthetic */ boolean $anonfun$isAlreadyArchived$1(ActorMetadata child$1, ChildArchived x$7) {
        ActorMetadata actorMetadata = x$7.metadata();
        ActorMetadata actorMetadata2 = child$1;
        return !(actorMetadata != null ? !((Object)actorMetadata).equals(actorMetadata2) : actorMetadata2 != null);
    }

    public static /* synthetic */ boolean $anonfun$queryDataArchived$1(ModelEvent x$8) {
        return x$8 instanceof QueryDataArchived;
    }

    public static /* synthetic */ boolean $anonfun$archive$1(ModelEvent x$10) {
        return x$10 instanceof ArchiveCreated;
    }

    public static void $init$(ArchivalState $this) {
    }
}

