/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.storage.deletion.state;

import akka.Done;
import akka.actor.ActorRef;
import java.io.Serializable;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.storage.actormodel.ActorMetadata;
import org.cafienne.storage.actormodel.StorageActorState;
import org.cafienne.storage.actormodel.message.StorageEvent;
import org.cafienne.storage.deletion.ActorDataRemover;
import org.cafienne.storage.deletion.event.ChildrenRemovalInitiated;
import org.cafienne.storage.deletion.event.ChildrenRemovalInitiated$;
import org.cafienne.storage.deletion.event.QueryDataRemoved;
import org.cafienne.storage.deletion.event.QueryDataRemoved$;
import org.cafienne.storage.deletion.event.RemovalCompleted;
import org.cafienne.storage.deletion.event.RemovalInitiated;
import org.cafienne.storage.querydb.QueryDBStorage;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005e4q\u0001E\t\u0011\u0002\u0007\u0005A\u0004C\u0003*\u0001\u0011\u0005!\u0006C\u0004/\u0001\t\u0007i\u0011I\u0018\t\u000bQ\u0002a\u0011A\u001b\t\u000bq\u0002A1A\u001f\t\u000b\u0011\u0003A\u0011I#\t\u000b9\u0003a\u0011A(\t\u000be\u0003A\u0011\t\u0016\t\u000bi\u0003A\u0011\u0001\u0016\t\u000bm\u0003A\u0011\u0001\u0016\t\u000bq\u0003A\u0011A/\t\u000b\u0005\u0004A\u0011\u00012\t\u000bI\u0004A\u0011\u00012\t\u000bM\u0004A\u0011\u0001;\t\u000b]\u0004A\u0011A/\t\u000ba\u0004A\u0011\u0001\u0016\u0003\u001b\u0011+G.\u001a;j_:\u001cF/\u0019;f\u0015\t\u00112#A\u0003ti\u0006$XM\u0003\u0002\u0015+\u0005AA-\u001a7fi&|gN\u0003\u0002\u0017/\u000591\u000f^8sC\u001e,'B\u0001\r\u001a\u0003!\u0019\u0017MZ5f]:,'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001i2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0003I\u001dj\u0011!\n\u0006\u0003MU\t!\"Y2u_Jlw\u000eZ3m\u0013\tASEA\tTi>\u0014\u0018mZ3BGR|'o\u0015;bi\u0016\fa\u0001J5oSR$C#A\u0016\u0011\u0005ya\u0013BA\u0017 \u0005\u0011)f.\u001b;\u0002\u000b\u0005\u001cGo\u001c:\u0016\u0003A\u0002\"!\r\u001a\u000e\u0003MI!aM\n\u0003!\u0005\u001bGo\u001c:ECR\f'+Z7pm\u0016\u0014\u0018!\u00033c'R|'/Y4f+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d\u0016\u0003\u001d\tX/\u001a:zI\nL!a\u000f\u001d\u0003\u001dE+XM]=E\u0005N#xN]1hK\u0006QA-[:qCR\u001c\u0007.\u001a:\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!Q\u0010\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002D\u0001\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0013Q\u0006tG\r\\3Ti>\u0014\u0018mZ3Fm\u0016tG\u000f\u0006\u0002,\r\")q)\u0002a\u0001\u0011\u0006)QM^3oiB\u0011\u0011\nT\u0007\u0002\u0015*\u00111*J\u0001\b[\u0016\u001c8/Y4f\u0013\ti%J\u0001\u0007Ti>\u0014\u0018mZ3Fm\u0016tG/\u0001\bdY\u0016\f'/U;fef$\u0015\r^1\u0015\u0003A\u00032aP)T\u0013\t\u0011\u0006I\u0001\u0004GkR,(/\u001a\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006!\u0011m[6b\u0013\tAVK\u0001\u0003E_:,\u0017AF2p]RLg.^3Ti>\u0014\u0018mZ3Qe>\u001cWm]:\u00025Q\u0014\u0018nZ4fe\u000eC\u0017\u000e\u001c3SK6|g/\u00197Qe>\u001cWm]:\u00029Q\u0014\u0018nZ4feF+XM]=E\u0005\u000ecW-\u00198vaB\u0013xnY3tg\u0006I2\r[5mIJ,g.T3uC\u0012\fG/Y!wC&d\u0017M\u00197f+\u0005q\u0006C\u0001\u0010`\u0013\t\u0001wDA\u0004C_>dW-\u00198\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012a\u0019\t\u0004I2|gBA3k\u001d\t1\u0017.D\u0001h\u0015\tA7$\u0001\u0004=e>|GOP\u0005\u0002A%\u00111nH\u0001\ba\u0006\u001c7.Y4f\u0013\tigNA\u0002TKFT!a[\u0010\u0011\u0005\u0011\u0002\u0018BA9&\u00055\t5\r^8s\u001b\u0016$\u0018\rZ1uC\u0006!\u0002/\u001a8eS:<7\t[5mIJ+Wn\u001c<bYN\f\u0001#[:BYJ,\u0017\rZ=EK2,G/\u001a3\u0015\u0005y+\b\"\u0002<\u000e\u0001\u0004y\u0017!B2iS2$\u0017\u0001E9vKJLH)\u0019;b\u00072,\u0017M]3e\u0003y\u0019\u0007.Z2l\t\u0016dW\r^5p]B\u0013xnY3tg\u000e{W\u000e\u001d7fi&|g\u000e")
public interface DeletionState
extends StorageActorState {
    public ActorDataRemover actor();

    public QueryDBStorage dbStorage();

    public static /* synthetic */ ExecutionContext dispatcher$(DeletionState $this) {
        return $this.dispatcher();
    }

    default public ExecutionContext dispatcher() {
        return this.dbStorage().dispatcher();
    }

    public static /* synthetic */ void handleStorageEvent$(DeletionState $this, StorageEvent event) {
        $this.handleStorageEvent(event);
    }

    @Override
    default public void handleStorageEvent(StorageEvent event) {
        StorageEvent storageEvent = event;
        if (storageEvent instanceof RemovalInitiated) {
            RemovalInitiated removalInitiated = (RemovalInitiated)storageEvent;
            this.printLogMessage("Starting removal for " + removalInitiated.metadata());
            this.continueStorageProcess();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (storageEvent instanceof ChildrenRemovalInitiated) {
            ChildrenRemovalInitiated childrenRemovalInitiated = (ChildrenRemovalInitiated)storageEvent;
            this.printLogMessage("Initiating deletion of " + childrenRemovalInitiated.members().size() + " children");
            this.triggerChildRemovalProcess();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (storageEvent instanceof QueryDataRemoved) {
            this.printLogMessage("QueryDB has been cleaned");
            this.checkDeletionProcessCompletion();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (storageEvent instanceof RemovalCompleted) {
            RemovalCompleted removalCompleted = (RemovalCompleted)storageEvent;
            this.printLogMessage("Child " + removalCompleted.metadata() + " reported completion");
            this.checkDeletionProcessCompletion();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.printLogMessage("Encountered unexpected storage event " + storageEvent.getClass().getName() + " on Actor [" + storageEvent.actorId() + "] data on behalf of user " + storageEvent.user());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Future<Done> clearQueryData();

    public static /* synthetic */ void continueStorageProcess$(DeletionState $this) {
        $this.continueStorageProcess();
    }

    @Override
    default public void continueStorageProcess() {
        this.triggerChildRemovalProcess();
        this.triggerQueryDBCleanupProcess();
    }

    public static /* synthetic */ void triggerChildRemovalProcess$(DeletionState $this) {
        $this.triggerChildRemovalProcess();
    }

    default public void triggerChildRemovalProcess() {
        if (!this.childrenMetadataAvailable()) {
            this.findCascadingChildren().map((Function1 & Serializable)children -> {
                DeletionState.$anonfun$triggerChildRemovalProcess$1(this, children);
                return BoxedUnit.UNIT;
            }, this.dispatcher());
        } else {
            if (this.pendingChildRemovals().nonEmpty()) {
                this.printLogMessage("Found " + this.pendingChildRemovals().size() + " out of " + this.children().size() + " children with pending removal");
                this.pendingChildRemovals().foreach((Function1 & Serializable)child -> {
                    DeletionState.$anonfun$triggerChildRemovalProcess$2(this, child);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.printLogMessage("No children found that have pending removal");
            }
            this.checkDeletionProcessCompletion();
        }
    }

    public static /* synthetic */ void triggerQueryDBCleanupProcess$(DeletionState $this) {
        $this.triggerQueryDBCleanupProcess();
    }

    default public void triggerQueryDBCleanupProcess() {
        BoxedUnit boxedUnit;
        if (!this.queryDataCleared()) {
            this.printLogMessage("Deleting query data");
            boxedUnit = this.clearQueryData().map((Function1 & Serializable)x$1 -> {
                DeletionState.$anonfun$triggerQueryDBCleanupProcess$1(this, x$1);
                return BoxedUnit.UNIT;
            }, this.dispatcher());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.checkDeletionProcessCompletion();
    }

    public static /* synthetic */ boolean childrenMetadataAvailable$(DeletionState $this) {
        return $this.childrenMetadataAvailable();
    }

    default public boolean childrenMetadataAvailable() {
        return this.events().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeletionState.$anonfun$childrenMetadataAvailable$1(x$2)));
    }

    public static /* synthetic */ Seq children$(DeletionState $this) {
        return $this.children();
    }

    default public Seq<ActorMetadata> children() {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)this.events().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeletionState.$anonfun$children$1(x$3)))).map((Function1 & Serializable)x$4 -> (ChildrenRemovalInitiated)x$4)).flatMap((Function1 & Serializable)x$5 -> x$5.members())).toSeq();
    }

    public static /* synthetic */ Seq pendingChildRemovals$(DeletionState $this) {
        return $this.pendingChildRemovals();
    }

    default public Seq<ActorMetadata> pendingChildRemovals() {
        return (Seq)this.children().filterNot((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)this.isAlreadyDeleted(child)));
    }

    public static /* synthetic */ boolean isAlreadyDeleted$(DeletionState $this, ActorMetadata child) {
        return $this.isAlreadyDeleted(child);
    }

    default public boolean isAlreadyDeleted(ActorMetadata child) {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)this.events().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeletionState.$anonfun$isAlreadyDeleted$1(x$6)))).map((Function1 & Serializable)x$7 -> (RemovalCompleted)x$7)).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeletionState.$anonfun$isAlreadyDeleted$3(child, x$8)));
    }

    public static /* synthetic */ boolean queryDataCleared$(DeletionState $this) {
        return $this.queryDataCleared();
    }

    default public boolean queryDataCleared() {
        return this.events().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeletionState.$anonfun$queryDataCleared$1(x$9)));
    }

    public static /* synthetic */ void checkDeletionProcessCompletion$(DeletionState $this) {
        $this.checkDeletionProcessCompletion();
    }

    default public void checkDeletionProcessCompletion() {
        block0: {
            this.printLogMessage("Running completion check: [queryDataCleared=" + this.queryDataCleared() + "; childrenMetadataAvailable=" + this.childrenMetadataAvailable() + "; children removed=" + (this.children().size() - this.pendingChildRemovals().size()) + ", pending=" + this.pendingChildRemovals().size() + "]");
            if (!this.childrenMetadataAvailable() || !this.pendingChildRemovals().isEmpty() || !this.queryDataCleared()) break block0;
            this.actor().completeDeletionProcess();
        }
    }

    public static /* synthetic */ void $anonfun$triggerChildRemovalProcess$1(DeletionState $this, Seq children) {
        $this.printLogMessage("Found " + children.length() + " children to be removed: " + children.mkString("\n--- ", "\n--- ", ""));
        ChildrenRemovalInitiated x$1 = new ChildrenRemovalInitiated($this.actor().metadata(), (Seq<ActorMetadata>)children, ChildrenRemovalInitiated$.MODULE$.apply$default$3());
        ActorRef x$2 = $this.actor().self().$bang$default$2((Object)x$1);
        $this.actor().self().$bang((Object)x$1, x$2);
    }

    public static /* synthetic */ void $anonfun$triggerChildRemovalProcess$2(DeletionState $this, ActorMetadata child) {
        $this.actor().deleteChildActorData(child);
    }

    public static /* synthetic */ void $anonfun$triggerQueryDBCleanupProcess$1(DeletionState $this, Done x$1) {
        QueryDataRemoved x$12 = new QueryDataRemoved($this.metadata(), QueryDataRemoved$.MODULE$.apply$default$2());
        ActorRef x$2 = $this.actor().self().$bang$default$2((Object)x$12);
        $this.actor().self().$bang((Object)x$12, x$2);
    }

    public static /* synthetic */ boolean $anonfun$childrenMetadataAvailable$1(ModelEvent x$2) {
        return x$2 instanceof ChildrenRemovalInitiated;
    }

    public static /* synthetic */ boolean $anonfun$children$1(ModelEvent x$3) {
        return x$3 instanceof ChildrenRemovalInitiated;
    }

    public static /* synthetic */ boolean $anonfun$isAlreadyDeleted$1(ModelEvent x$6) {
        return x$6 instanceof RemovalCompleted;
    }

    public static /* synthetic */ boolean $anonfun$isAlreadyDeleted$3(ActorMetadata child$1, RemovalCompleted x$8) {
        ActorMetadata actorMetadata = x$8.metadata();
        ActorMetadata actorMetadata2 = child$1;
        return !(actorMetadata != null ? !((Object)actorMetadata).equals(actorMetadata2) : actorMetadata2 != null);
    }

    public static /* synthetic */ boolean $anonfun$queryDataCleared$1(ModelEvent x$9) {
        return x$9 instanceof QueryDataRemoved;
    }

    public static void $init$(DeletionState $this) {
    }
}

