/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.system.health;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.Instant;
import org.cafienne.json.ValueMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\u000b\u0016\u0001yA\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\ty\u0001\u0011\t\u0011)A\u0005c!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u001dI\u0005\u00011A\u0005\nyBqA\u0013\u0001A\u0002\u0013%1\n\u0003\u0004R\u0001\u0001\u0006Ka\u0010\u0005\b%\u0002\u0001\r\u0011\"\u0003T\u0011\u001dY\u0006\u00011A\u0005\nqCaA\u0018\u0001!B\u0013!\u0006\"C0\u0001\u0001\u0004\u0005\r\u0011\"\u0003a\u0011%9\u0007\u00011AA\u0002\u0013%\u0001\u000eC\u0005k\u0001\u0001\u0007\t\u0011)Q\u0005C\")1\u000e\u0001C\u0001Y\")Q\u000e\u0001C\u0001]\")q\u000e\u0001C\u0001a\")A\u0010\u0001C\u0001a!)Q\u0010\u0001C\u0001}\n\u0011\u0002*Z1mi\"lU-Y:ve\u0016\u0004v.\u001b8u\u0015\t1r#\u0001\u0004iK\u0006dG\u000f\u001b\u0006\u00031e\taa]=ti\u0016l'B\u0001\u000e\u001c\u0003!\u0019\u0017MZ5f]:,'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M5j\u0011a\n\u0006\u0003Q%\nAb]2bY\u0006dwnZ4j]\u001eT!AK\u0016\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001L\u0001\u0004G>l\u0017B\u0001\u0018(\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0007-,\u00170F\u00012!\t\u0011\u0014H\u0004\u00024oA\u0011A'I\u0007\u0002k)\u0011a'H\u0001\u0007yI|w\u000e\u001e \n\u0005a\n\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u0011\u0002\t-,\u0017\u0010I\u0001\u000bSN\u001c%/\u001b;jG\u0006dW#A \u0011\u0005\u0001\u0002\u0015BA!\"\u0005\u001d\u0011un\u001c7fC:\f1\"[:De&$\u0018nY1mA\u00051A(\u001b8jiz\"2!R$I!\t1\u0005!D\u0001\u0016\u0011\u0015yS\u00011\u00012\u0011\u0015iT\u00011\u0001@\u0003\u001dAW-\u00197uQf\f1\u0002[3bYRD\u0017p\u0018\u0013fcR\u0011Aj\u0014\t\u0003A5K!AT\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b!\u001e\t\t\u00111\u0001@\u0003\rAH%M\u0001\tQ\u0016\fG\u000e\u001e5zA\u0005YA-Z:de&\u0004H/[8o+\u0005!\u0006CA+[\u001b\u00051&BA,Y\u0003\u0011a\u0017M\\4\u000b\u0003e\u000bAA[1wC&\u0011!HV\u0001\u0010I\u0016\u001c8M]5qi&|gn\u0018\u0013fcR\u0011A*\u0018\u0005\b!*\t\t\u00111\u0001U\u00031!Wm]2sSB$\u0018n\u001c8!\u0003\u001d\u0019\u0007.\u00198hK\u0012,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003Ib\u000bA\u0001^5nK&\u0011am\u0019\u0002\b\u0013:\u001cH/\u00198u\u0003-\u0019\u0007.\u00198hK\u0012|F%Z9\u0015\u00051K\u0007b\u0002)\u000e\u0003\u0003\u0005\r!Y\u0001\tG\"\fgnZ3eA\u0005IQO\u001c5fC2$\b.\u001f\u000b\u0002\u007f\u0005!\u0011n](L)\u0005a\u0015!\u00035bg\u001a\u000b\u0017\u000e\\3e)\ta\u0015\u000fC\u0003s#\u0001\u00071/A\u0005uQJ|w/\u00192mKB\u0011A/\u001f\b\u0003k^t!\u0001\u000e<\n\u0003\tJ!\u0001_\u0011\u0002\u000fA\f7m[1hK&\u0011!p\u001f\u0002\n)\"\u0014xn^1cY\u0016T!\u0001_\u0011\u0002\rM$\u0018\r^;t\u0003\u0019\t7OS*P\u001dR\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)!G\u0001\u0005UN|g.\u0003\u0003\u0002\n\u0005\r!\u0001\u0003,bYV,W*\u00199")
public class HealthMeasurePoint
implements LazyLogging {
    private final String key;
    private final boolean isCritical;
    private boolean healthy;
    private String description;
    private Instant changed;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        HealthMeasurePoint healthMeasurePoint = this;
        synchronized (healthMeasurePoint) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String key() {
        return this.key;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    private boolean healthy() {
        return this.healthy;
    }

    private void healthy_$eq(boolean x$1) {
        this.healthy = x$1;
    }

    private String description() {
        return this.description;
    }

    private void description_$eq(String x$1) {
        this.description = x$1;
    }

    private Instant changed() {
        return this.changed;
    }

    private void changed_$eq(Instant x$1) {
        this.changed = x$1;
    }

    public boolean unhealthy() {
        return !this.healthy();
    }

    public void isOK() {
        block2: {
            BoxedUnit boxedUnit;
            if (this.healthy()) break block2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("{} is healthy health again", (Object)this.key());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.healthy_$eq(true);
            this.description_$eq(this.key() + " is healthy ");
            this.changed_$eq(Instant.now());
        }
    }

    public void hasFailed(Throwable throwable) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error(this.key() + " reported bad health", throwable);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.healthy_$eq(false);
        this.description_$eq("Failure: " + throwable.getLocalizedMessage());
        this.changed_$eq(Instant.now());
    }

    public String status() {
        return this.healthy() ? "OK" : "NOK";
    }

    /*
     * WARNING - void declaration
     */
    public ValueMap asJSON() {
        void var1_1;
        ValueMap json = new ValueMap("Status", this.status(), "Description", this.description());
        Object object = this.changed() != null ? json.plus("changed-at", this.changed()) : BoxedUnit.UNIT;
        return var1_1;
    }

    public HealthMeasurePoint(String key, boolean isCritical) {
        this.key = key;
        this.isCritical = isCritical;
        LazyLogging.$init$((LazyLogging)this);
        this.healthy = true;
        this.description = key + " is healthy ";
    }
}

