/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.tenant.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.tenant.TenantActor;
import org.cafienne.tenant.actorapi.command.TenantCommand;
import org.cafienne.tenant.actorapi.response.TenantResponse;

@Manifest
public class RemoveTenantUser
extends TenantCommand {
    public final String userId;

    public RemoveTenantUser(TenantUser tenantUser, String string, String string2) {
        super(tenantUser, string);
        this.userId = string2;
    }

    public RemoveTenantUser(ValueMap valueMap) {
        super(valueMap);
        this.userId = valueMap.readString((Object)Fields.userId, new String[0]);
    }

    @Override
    public void validate(TenantActor tenantActor) throws InvalidCommandException {
        super.validate(tenantActor);
        this.validateNotLastOwner(tenantActor, this.userId);
    }

    public TenantResponse process(TenantActor tenantActor) {
        tenantActor.removeUser(this.userId);
        return new TenantResponse(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.userId, this.userId);
    }
}

