/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.tenant.actorapi.command;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.TenantUser;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.tenant.TenantActor;
import org.cafienne.tenant.actorapi.command.TenantCommand;
import org.cafienne.tenant.actorapi.response.TenantResponse;

@Manifest
public class SetTenantUser
extends TenantCommand {
    public final TenantUser newUser;

    public SetTenantUser(TenantUser tenantUser, String string, TenantUser tenantUser2) {
        super(tenantUser, string);
        this.newUser = tenantUser2;
    }

    public SetTenantUser(ValueMap valueMap) {
        super(valueMap);
        this.newUser = TenantUser.deserialize(valueMap.with((Object)Fields.newTenantUser));
    }

    @Override
    public void validate(TenantActor tenantActor) throws InvalidCommandException {
        super.validate(tenantActor);
        if (!this.newUser.isOwner() || !this.newUser.enabled()) {
            this.validateNotLastOwner(tenantActor, this.newUser.id());
        }
    }

    public TenantResponse process(TenantActor tenantActor) {
        tenantActor.setUser(this.newUser);
        return new TenantResponse(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.newTenantUser, this.newUser);
    }
}

