/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.system.health.HealthMonitor$;
import org.cafienne.timerservice.Timer;
import org.cafienne.timerservice.TimerMonitor;
import org.cafienne.timerservice.persistence.TimerStore;
import scala.Function1;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005I4Aa\u0004\t\u0001/!AQ\u0006\u0001B\u0001B\u0003%a\u0006C\u00033\u0001\u0011\u00051\u0007C\u00047\u0001\t\u0007I1A\u001c\t\r\u0001\u0003\u0001\u0015!\u00039\u0011\u001d\t\u0005A1A\u0005\n\tCa!\u0013\u0001!\u0002\u0013\u0019\u0005b\u0002&\u0001\u0005\u0004%Ia\u0013\u0005\u0007%\u0002\u0001\u000b\u0011\u0002'\t\u000fM\u0003\u0001\u0019!C\u0005)\"9\u0011\f\u0001a\u0001\n\u0013Q\u0006B\u00021\u0001A\u0003&Q\u000bC\u0003b\u0001\u0011\u0005#\rC\u0003d\u0001\u0011\u0005A\rC\u0003i\u0001\u0011\u0005\u0011N\u0001\nUS6,'o\u0015;pe\u0006<WMU3bI\u0016\u0014(BA\t\u0013\u00031!\u0018.\\3sg\u0016\u0014h/[2f\u0015\t\u0019B#\u0001\u0005dC\u001aLWM\u001c8f\u0015\u0005)\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u0019A\r\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u00033\u0005J!A\t\u000e\u0003\u0011I+hN\\1cY\u0016\u0004\"\u0001J\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005!J\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003)\n1aY8n\u0013\taSEA\u0006MCjLHj\\4hS:<\u0017\u0001C:dQ\u0016$W\u000f\\3\u0011\u0005=\u0002T\"\u0001\t\n\u0005E\u0002\"\u0001\u0004+j[\u0016\u0014Xj\u001c8ji>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00025kA\u0011q\u0006\u0001\u0005\u0006[\t\u0001\rAL\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014X#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014AC2p]\u000e,(O]3oi*\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@u\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\fI&\u001c\b/\u0019;dQ\u0016\u0014\b%A\u0004ti>\u0014\u0018mZ3\u0016\u0003\r\u0003\"\u0001R$\u000e\u0003\u0015S!A\u0012\t\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003\u0011\u0016\u0013!\u0002V5nKJ\u001cFo\u001c:f\u0003!\u0019Ho\u001c:bO\u0016\u0004\u0013AB<j]\u0012|w/F\u0001M!\ti\u0005+D\u0001O\u0015\ty%(\u0001\u0005ekJ\fG/[8o\u0013\t\tfJ\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u000f]Lg\u000eZ8xA\u0005a\u0011m\u0019;jm\u0016<\u0016N\u001c3poV\tQ\u000b\u0005\u0002W/6\tA(\u0003\u0002Yy\t!Aj\u001c8h\u0003A\t7\r^5wK^Kg\u000eZ8x?\u0012*\u0017\u000f\u0006\u0002\\=B\u0011a\u000bX\u0005\u0003;r\u0012A!\u00168ji\"9qLCA\u0001\u0002\u0004)\u0016a\u0001=%c\u0005i\u0011m\u0019;jm\u0016<\u0016N\u001c3po\u0002\n1A];o)\u0005Y\u0016A\u00047pC\u0012tU\r\u001f;XS:$wn^\u000b\u0002KB\u0019\u0011HZ.\n\u0005\u001dT$A\u0002$viV\u0014X-\u0001\tgSR\u001c\u0018i\u0019;jm\u0016<\u0016N\u001c3poR\u0011!.\u001c\t\u0003-.L!\u0001\u001c\u001f\u0003\u000f\t{w\u000e\\3b]\")aN\u0004a\u0001_\u0006)A/[7feB\u0011q\u0006]\u0005\u0003cB\u0011Q\u0001V5nKJ\u0004")
public class TimerStorageReader
implements Runnable,
LazyLogging {
    private final TimerMonitor schedule;
    private final ExecutionContext dispatcher;
    private final TimerStore storage;
    private final FiniteDuration window;
    private long activeWindow;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TimerStorageReader timerStorageReader = this;
        synchronized (timerStorageReader) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext dispatcher() {
        return this.dispatcher;
    }

    private TimerStore storage() {
        return this.storage;
    }

    private FiniteDuration window() {
        return this.window;
    }

    private long activeWindow() {
        return this.activeWindow;
    }

    private void activeWindow_$eq(long x$1) {
        this.activeWindow = x$1;
    }

    @Override
    public void run() {
        this.loadNextWindow();
    }

    /*
     * WARNING - void declaration
     */
    public Future<BoxedUnit> loadNextWindow() {
        Future future;
        BoxedUnit boxedUnit;
        Instant nextWindow = Instant.now().plusMillis(this.window().toMillis());
        this.activeWindow_$eq(nextWindow.toEpochMilli());
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Reading timers from TimerStore for next {} (setting active window to {})", new Object[]{this.window(), nextWindow});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            void var3_2;
            Future<Seq<Timer>> result = this.storage().getTimers(nextWindow);
            HealthMonitor$.MODULE$.timerService().isOK();
            future = var3_2;
        }
        catch (Throwable t) {
            HealthMonitor$.MODULE$.timerService().hasFailed(t);
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$));
        }
        void timers = future;
        return timers.map((Function1 & Serializable)x$1 -> {
            x$1.foreach((Function1 & Serializable)timer -> {
                $this.schedule.scheduleTimer(timer);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }, this.dispatcher());
    }

    public boolean fitsActiveWindow(Timer timer) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Checking if timer {} fits current window gives - {}", new Object[]{timer, BoxesRunTime.boxToBoolean((timer.moment().toEpochMilli() < this.activeWindow() ? 1 : 0) != 0)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return timer.moment().toEpochMilli() < this.activeWindow();
    }

    public TimerStorageReader(TimerMonitor schedule) {
        this.schedule = schedule;
        LazyLogging.$init$((LazyLogging)this);
        this.dispatcher = schedule.timerService().caseSystem.system().dispatcher();
        this.storage = schedule.timerService().storage;
        this.window = Cafienne$.MODULE$.config().engine().timerService().window();
        this.activeWindow = -1L;
    }
}

