/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice.persistence;

import akka.actor.ActorSystem;
import akka.persistence.cassandra.query.scaladsl.CassandraReadJournal;
import akka.persistence.jdbc.query.scaladsl.JdbcReadJournal;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.cafienne.infrastructure.cqrs.ReadJournalProvider;
import org.cafienne.system.CaseSystem;
import org.cafienne.timerservice.persistence.TimerStore;
import org.cafienne.timerservice.persistence.cassandra.CassandraTimerStore;
import org.cafienne.timerservice.persistence.inmemory.InMemoryStore;
import org.cafienne.timerservice.persistence.jdbc.JDBCTimerStore;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}2A\u0001C\u0005\u0001%!A\u0011\u0005\u0001BC\u0002\u0013\u0005!\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u001d1\u0003A1A\u0005B=Ba\u0001\u000f\u0001!\u0002\u0013\u0001\u0004bB\u001d\u0001\u0005\u0004%\tA\u000f\u0005\u0007}\u0001\u0001\u000b\u0011B\u001e\u0003%QKW.\u001a:Ti>\u0014X\r\u0015:pm&$WM\u001d\u0006\u0003\u0015-\t1\u0002]3sg&\u001cH/\u001a8dK*\u0011A\"D\u0001\ri&lWM]:feZL7-\u001a\u0006\u0003\u001d=\t\u0001bY1gS\u0016tg.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQr$D\u0001\u001c\u0015\taR$\u0001\u0003dcJ\u001c(B\u0001\u0010\u000e\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016L!\u0001I\u000e\u0003'I+\u0017\r\u001a&pkJt\u0017\r\u001c)s_ZLG-\u001a:\u0002\u0015\r\f7/Z*zgR,W.F\u0001$!\t!s%D\u0001&\u0015\t1S\"\u0001\u0004tsN$X-\\\u0005\u0003Q\u0015\u0012!bQ1tKNK8\u000f^3n\u0003-\u0019\u0017m]3TsN$X-\u001c\u0011\u0002\rqJg.\u001b;?)\tac\u0006\u0005\u0002.\u00015\t\u0011\u0002C\u0003\"\u0007\u0001\u00071%F\u00011!\t\td'D\u00013\u0015\t\u0019D'A\u0003bGR|'OC\u00016\u0003\u0011\t7n[1\n\u0005]\u0012$aC!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%A\u0003ti>\u0014X-F\u0001<!\tiC(\u0003\u0002>\u0013\tQA+[7feN#xN]3\u0002\rM$xN]3!\u0001")
public class TimerStoreProvider
implements ReadJournalProvider {
    private final CaseSystem caseSystem;
    private final ActorSystem system;
    private final TimerStore store;
    private String configuredJournal;
    private String readJournalSetting;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public ActorSystem actorSystem() {
        return ReadJournalProvider.actorSystem$(this);
    }

    @Override
    public CurrentPersistenceIdsQuery journal() {
        return ReadJournalProvider.journal$(this);
    }

    private String configuredJournal$lzycompute() {
        TimerStoreProvider timerStoreProvider = this;
        synchronized (timerStoreProvider) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.configuredJournal = ReadJournalProvider.configuredJournal$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.configuredJournal;
    }

    @Override
    public String configuredJournal() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.configuredJournal$lzycompute() : this.configuredJournal;
    }

    private String readJournalSetting$lzycompute() {
        TimerStoreProvider timerStoreProvider = this;
        synchronized (timerStoreProvider) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readJournalSetting = ReadJournalProvider.readJournalSetting$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readJournalSetting;
    }

    @Override
    public String readJournalSetting() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.readJournalSetting$lzycompute() : this.readJournalSetting;
    }

    private Logger logger$lzycompute() {
        TimerStoreProvider timerStoreProvider = this;
        synchronized (timerStoreProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    public TimerStore store() {
        return this.store;
    }

    public TimerStoreProvider(CaseSystem caseSystem) {
        TimerStore timerStore;
        this.caseSystem = caseSystem;
        LazyLogging.$init$((LazyLogging)this);
        ReadJournalProvider.$init$(this);
        this.system = caseSystem.system();
        CurrentPersistenceIdsQuery currentPersistenceIdsQuery = this.journal();
        if (currentPersistenceIdsQuery instanceof CassandraReadJournal) {
            CassandraReadJournal cassandraReadJournal = (CassandraReadJournal)currentPersistenceIdsQuery;
            timerStore = new CassandraTimerStore(cassandraReadJournal);
        } else {
            timerStore = currentPersistenceIdsQuery instanceof JdbcReadJournal ? new JDBCTimerStore() : new InMemoryStore();
        }
        this.store = timerStore;
    }
}

