/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice.persistence.inmemory;

import akka.Done;
import akka.Done$;
import akka.persistence.query.Offset;
import akka.persistence.query.Offset$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import org.cafienne.timerservice.Timer;
import org.cafienne.timerservice.persistence.TimerStore;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0005\u000b\u0001UAQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\u0005q\u0006\u0003\u0004H\u0001\u0001\u0006I\u0001\r\u0005\u0006\u0011\u0002!\t%\u0013\u0005\u00063\u0002!\tE\u0017\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006{\u0002!\tE \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u00055Ie.T3n_JL8\u000b^8sK*\u00111\u0002D\u0001\tS:lW-\\8ss*\u0011QBD\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0010!\u0005aA/[7feN,'O^5dK*\u0011\u0011CE\u0001\tG\u00064\u0017.\u001a8oK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001-q\u0001\u0003CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\tA\"\u0003\u0002 \u0019\tQA+[7feN#xN]3\u0011\u0005\u0005BS\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0013'\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0014\u0002\u0007\r|W.\u0003\u0002*E\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0005\u0002.\u00015\t!\"\u0001\u0004uS6,'o]\u000b\u0002aA!\u0011G\u000e\u001dD\u001b\u0005\u0011$BA\u001a5\u0003\u001diW\u000f^1cY\u0016T!!\u000e\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00028e\t9\u0001*Y:i\u001b\u0006\u0004\bCA\u001dA\u001d\tQd\b\u0005\u0002<15\tAH\u0003\u0002>)\u00051AH]8pizJ!a\u0010\r\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fa\u0001\"\u0001R#\u000e\u00039I!A\u0012\b\u0003\u000bQKW.\u001a:\u0002\u000fQLW.\u001a:tA\u0005Iq-\u001a;PM\u001a\u001cX\r^\u000b\u0002\u0015B\u00191J\u0014)\u000e\u00031S!!\u0014\r\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002P\u0019\n1a)\u001e;ve\u0016\u0004\"!U,\u000e\u0003IS!a\u0015+\u0002\u000bE,XM]=\u000b\u00055)&\"\u0001,\u0002\t\u0005\\7.Y\u0005\u00031J\u0013aa\u00144gg\u0016$\u0018!C4fiRKW.\u001a:t)\tYV\rE\u0002L\u001dr\u00032!\u00182D\u001d\tq\u0006M\u0004\u0002<?&\t\u0011$\u0003\u0002b1\u00059\u0001/Y2lC\u001e,\u0017BA2e\u0005\r\u0019V-\u001d\u0006\u0003CbAQAZ\u0003A\u0002\u001d\faa^5oI><\bC\u00015n\u001b\u0005I'B\u00016l\u0003\u0011!\u0018.\\3\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\b\u0013:\u001cH/\u00198u\u0003)\u0019Ho\u001c:f)&lWM\u001d\u000b\u0004cZD\bcA&OeB\u00111\u000f^\u0007\u0002+&\u0011Q/\u0016\u0002\u0005\t>tW\rC\u0003x\r\u0001\u00071)A\u0002k_\nDQ!\u001f\u0004A\u0002i\faa\u001c4gg\u0016$\bcA\f|!&\u0011A\u0010\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017I,Wn\u001c<f)&lWM\u001d\u000b\u0005c~\f\u0019\u0001\u0003\u0004\u0002\u0002\u001d\u0001\r\u0001O\u0001\bi&lWM]%e\u0011\u0015Ix\u00011\u0001{\u00031IW\u000e]8siRKW.\u001a:t)\u0011\tI!a\u0004\u0011\u0007]\tY!C\u0002\u0002\u000ea\u0011A!\u00168ji\"1\u0011\u0011\u0003\u0005A\u0002q\u000bA\u0001\\5ti\u0002")
public class InMemoryStore
implements TimerStore {
    private final HashMap<String, Timer> timers;
    private ExecutionContext ec;
    private String storageName;
    private String description;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public String storageName() {
        return this.storageName;
    }

    private String description$lzycompute() {
        InMemoryStore inMemoryStore = this;
        synchronized (inMemoryStore) {
            if (!this.bitmap$0) {
                this.description = TimerStore.description$(this);
                this.bitmap$0 = true;
            }
        }
        return this.description;
    }

    @Override
    public String description() {
        return !this.bitmap$0 ? this.description$lzycompute() : this.description;
    }

    @Override
    public void org$cafienne$timerservice$persistence$TimerStore$_setter_$ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    @Override
    public void org$cafienne$timerservice$persistence$TimerStore$_setter_$storageName_$eq(String x$1) {
        this.storageName = x$1;
    }

    private Logger logger$lzycompute() {
        InMemoryStore inMemoryStore = this;
        synchronized (inMemoryStore) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public HashMap<String, Timer> timers() {
        return this.timers;
    }

    @Override
    public Future<Offset> getOffset() {
        return Future$.MODULE$.successful((Object)Offset$.MODULE$.noOffset());
    }

    @Override
    public Future<Seq<Timer>> getTimers(Instant window) {
        return Future$.MODULE$.successful((Object)((IterableOnceOps)this.timers().values().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InMemoryStore.$anonfun$getTimers$1(window, x$1)))).toSeq());
    }

    @Override
    public Future<Done> storeTimer(Timer job, Option<Offset> offset) {
        BoxedUnit boxedUnit;
        this.timers().put((Object)job.timerId(), (Object)job);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Stored timer {}", (Object)job);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    @Override
    public Future<Done> removeTimer(String timerId, Option<Offset> offset) {
        BoxedUnit boxedUnit;
        this.timers().remove((Object)timerId);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Removed timer {}", (Object)timerId);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    @Override
    public void importTimers(Seq<Timer> list) {
        list.foreach((Function1 & Serializable)timer -> this.timers().put((Object)timer.timerId(), timer));
    }

    public static final /* synthetic */ boolean $anonfun$getTimers$1(Instant window$1, Timer x$1) {
        return x$1.moment().toEpochMilli() <= window$1.toEpochMilli();
    }

    public InMemoryStore() {
        LazyLogging.$init$((LazyLogging)this);
        TimerStore.$init$(this);
        this.timers = new HashMap();
        Statics.releaseFence();
    }
}

