/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.event.BaseModelEvent;
import org.cafienne.actormodel.event.CommitEvent;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class ActorModified<M extends ModelActor>
extends BaseModelEvent<M>
implements CommitEvent {
    public final transient IncomingActorMessage source;
    public final String sourceString;
    public final Instant lastModified;

    protected ActorModified(M m, IncomingActorMessage incomingActorMessage) {
        super(m);
        this.source = incomingActorMessage;
        this.sourceString = incomingActorMessage.getClass().getName();
        this.lastModified = ((ModelActor)((Object)m)).getTransactionTimestamp();
    }

    protected ActorModified(ValueMap valueMap) {
        super(valueMap);
        this.source = null;
        this.lastModified = valueMap.readInstant((Object)Fields.lastModified, new Instant[0]);
        this.sourceString = valueMap.readString((Object)Fields.source, "unknown message");
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + " upon " + this.sourceString;
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        this.writeActorModified(jsonGenerator);
    }

    @Override
    public void updateState(M m) {
        ((ModelActor)((Object)m)).updateState(this);
    }

    public void writeActorModified(JsonGenerator jsonGenerator) throws IOException {
        super.writeModelEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.lastModified, this.lastModified);
        this.writeField(jsonGenerator, (Object)Fields.source, this.sourceString);
    }
}

