/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.message;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.infrastructure.serialization.CafienneSerializable;
import org.cafienne.infrastructure.serialization.CafienneSerializer;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.JSONParseFailure;
import org.cafienne.json.JSONReader;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

public interface UserMessage
extends CafienneSerializable {
    public UserIdentity getUser();

    default public Class<?> actorClass() {
        return ModelActor.class;
    }

    default public boolean isBootstrapMessage() {
        return false;
    }

    default public BootstrapMessage asBootstrapMessage() {
        return (BootstrapMessage)this;
    }

    default public ValueMap rawJson() {
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter stringWriter = new StringWriter();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)stringWriter);
            jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            this.writeThisObject(jsonGenerator);
            jsonGenerator.close();
            Object t = JSONReader.parse(stringWriter.toString());
            return new ValueMap(new Object[]{Fields.type, CafienneSerializer.getManifestString(this), Fields.content, t});
        }
        catch (IOException | JSONParseFailure exception) {
            return new ValueMap("message", "Could not make JSON out of " + this.getClass().getName(), "exception", Value.convertThrowable(exception));
        }
    }
}

