/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.authentication;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.cafienne.authentication.OIDCConfiguration$;
import org.cafienne.infrastructure.config.util.ConfigReader;
import org.cafienne.json.JSONReader;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0005]4AAD\b\u0001-!A!\u0005\u0001BC\u0002\u0013\u0005s\u0005\u0003\u00052\u0001\t\u0005\t\u0015!\u0003)\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u001d9\u0004A1A\u0005\u0002aBa\u0001\u0012\u0001!\u0002\u0013I\u0004bB#\u0001\u0005\u0004%\tA\u0012\u0005\u00071\u0002\u0001\u000b\u0011B$\t\u000be\u0003A\u0011\u0001.\t\u000bm\u0003A\u0011\u0001/\b\u000b}{\u0001\u0012\u00011\u0007\u000b9y\u0001\u0012A1\t\u000bIZA\u0011\u00015\t\u000b%\\A\u0011\u00016\u0003#=KEiQ\"p]\u001aLw-\u001e:bi&|gN\u0003\u0002\u0011#\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'B\u0001\n\u0014\u0003!\u0019\u0017MZ5f]:,'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=\u0015j\u0011a\b\u0006\u0003A\u0005\nA!\u001e;jY*\u0011!eI\u0001\u0007G>tg-[4\u000b\u0005\u0011\n\u0012AD5oMJ\f7\u000f\u001e:vGR,(/Z\u0005\u0003M}\u0011AbQ8oM&<'+Z1eKJ,\u0012\u0001\u000b\t\u0003S=j\u0011A\u000b\u0006\u0003E-R!\u0001L\u0017\u0002\u0011QL\b/Z:bM\u0016T\u0011AL\u0001\u0004G>l\u0017B\u0001\u0019+\u0005\u0019\u0019uN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00025mA\u0011Q\u0007A\u0007\u0002\u001f!)!e\u0001a\u0001Q\u00051\u0011n]:vKJ,\u0012!\u000f\t\u0003u\u0005s!aO \u0011\u0005qJR\"A\u001f\u000b\u0005y*\u0012A\u0002\u001fs_>$h(\u0003\u0002A3\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001\u0015$A\u0004jgN,XM\u001d\u0011\u0002\u00115,G/\u00193bi\u0006,\u0012a\u0012\t\u00041!S\u0015BA%\u001a\u0005\u0019y\u0005\u000f^5p]B\u00111JV\u0007\u0002\u0019*\u0011QJT\u0001\u0003_BT!a\u0014)\u0002\u0007M$7N\u0003\u0002R%\u000691m\u001c8oK\u000e$(BA*U\u0003\u0019y\u0007/\u001a8jI*\u0011Q+L\u0001\t]&l'-^:eg&\u0011q\u000b\u0014\u0002\u0015\u001f&#5\t\u0015:pm&$WM]'fi\u0006$\u0017\r^1\u0002\u00135,G/\u00193bi\u0006\u0004\u0013a\u0006:fC\u0012\u001cF/\u0019;jG\u000e{gNZ5hkJ\fG/[8o)\u0005Q\u0015\u0001\u0007:fC\u0012$\u0015P\\1nS\u000e\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u0011!*\u0018\u0005\u0006=&\u0001\r!O\u0001\tK:$\u0007o\\5oi\u0006\tr*\u0013#D\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005UZ1cA\u0006\u0018EB\u00111MZ\u0007\u0002I*\u0011QmK\u0001\rg\u000e\fG.\u00197pO\u001eLgnZ\u0005\u0003O\u0012\u00141\u0002T1{s2{wmZ5oOR\t\u0001-\u0001\nsK\u0006$7i\u001c8gS\u001e,(/\u0019;j_:\u001cHCA6u!\ra\u0017O\u0013\b\u0003[>t!\u0001\u00108\n\u0003iI!\u0001]\r\u0002\u000fA\f7m[1hK&\u0011!o\u001d\u0002\u0004'\u0016\f(B\u00019\u001a\u0011\u0015)X\u00021\u0001w\u0003\u001d\u0019wN\u001c4jON\u00042\u0001\\9)\u0001")
public class OIDCConfiguration
implements ConfigReader {
    private final Config config;
    private final String issuer;
    private final Option<OIDCProviderMetadata> metadata;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Seq<OIDCProviderMetadata> readConfigurations(Seq<Config> configs) {
        return OIDCConfiguration$.MODULE$.readConfigurations(configs);
    }

    @Override
    public void warn(String msg) {
        ConfigReader.warn$(this, msg);
    }

    @Override
    public Number readNumber(String path, Number number) {
        return ConfigReader.readNumber$(this, path, number);
    }

    @Override
    public long readLong(String path, long l) {
        return ConfigReader.readLong$(this, path, l);
    }

    @Override
    public int readInt(String path, int n) {
        return ConfigReader.readInt$(this, path, n);
    }

    @Override
    public String readString(String path, String string) {
        return ConfigReader.readString$(this, path, string);
    }

    @Override
    public String readString$default$2() {
        return ConfigReader.readString$default$2$(this);
    }

    @Override
    public <T> T readEnum(String path, Class<T> enumClass, T t) {
        return (T)ConfigReader.readEnum$(this, path, enumClass, t);
    }

    @Override
    public <T> Null$ readEnum$default$3() {
        return ConfigReader.readEnum$default$3$(this);
    }

    @Override
    public boolean readBoolean(String path, boolean bl) {
        return ConfigReader.readBoolean$(this, path, bl);
    }

    @Override
    public FiniteDuration readDuration(String name, FiniteDuration finiteDuration) {
        return ConfigReader.readDuration$(this, name, finiteDuration);
    }

    @Override
    public Seq<String> readStringList(String path, Seq<String> defaultValue) {
        return ConfigReader.readStringList$(this, path, defaultValue);
    }

    @Override
    public Seq<String> readStringList$default$2() {
        return ConfigReader.readStringList$default$2$(this);
    }

    @Override
    public ConfigReader getConfigReader(String path, Config defaultValue) {
        return ConfigReader.getConfigReader$(this, path, defaultValue);
    }

    @Override
    public Config getConfigReader$default$2() {
        return ConfigReader.getConfigReader$default$2$(this);
    }

    @Override
    public Config readConfig(String path, Config defaultValue) {
        return ConfigReader.readConfig$(this, path, defaultValue);
    }

    @Override
    public Config readConfig$default$2() {
        return ConfigReader.readConfig$default$2$(this);
    }

    @Override
    public Seq<ConfigReader> readConfigList(String path, Seq<Config> defaultValue) {
        return ConfigReader.readConfigList$(this, path, defaultValue);
    }

    @Override
    public Seq<Config> readConfigList$default$2() {
        return ConfigReader.readConfigList$default$2$(this);
    }

    @Override
    public void requires(String errorPrefixMessage, Seq<String> paths) {
        ConfigReader.requires$(this, errorPrefixMessage, paths);
    }

    @Override
    public Nothing$ fail(String msg) {
        return ConfigReader.fail$(this, msg);
    }

    private Logger logger$lzycompute() {
        OIDCConfiguration oIDCConfiguration = this;
        synchronized (oIDCConfiguration) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Config config() {
        return this.config;
    }

    public String issuer() {
        return this.issuer;
    }

    public Option<OIDCProviderMetadata> metadata() {
        return this.metadata;
    }

    public OIDCProviderMetadata readStaticConfiguration() {
        String keysUrl = this.readString("key-url", this.readString$default$2());
        ArrayList<SubjectType> subjectTypes = new ArrayList<SubjectType>();
        subjectTypes.add(SubjectType.PUBLIC);
        OIDCProviderMetadata metadata = new OIDCProviderMetadata(new Issuer(this.issuer()), subjectTypes, new URI(keysUrl));
        JWSAlgorithm expectedJWSAlg = JWSAlgorithm.RS256;
        metadata.setIDTokenJWSAlgs(Collections.singletonList(expectedJWSAlg));
        String authorizationUrl = this.readString("authorization-url", this.readString$default$2());
        metadata.setAuthorizationEndpointURI(new URI(authorizationUrl));
        String tokenUrl = this.readString("token-url", this.readString$default$2());
        metadata.setTokenEndpointURI(new URI(tokenUrl));
        return metadata;
    }

    public OIDCProviderMetadata readDynamicConfiguration(String endpoint) {
        BoxedUnit boxedUnit;
        OIDCProviderMetadata metadata = OIDCProviderMetadata.resolve((Issuer)new Issuer(endpoint));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Retrieved dynamic info from IDP " + endpoint + ": " + JSONReader.parse(metadata.toJSONObject().toJSONString()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return metadata;
    }

    public OIDCConfiguration(Config config) {
        Some some;
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
        ConfigReader.$init$(this);
        this.issuer = this.readString("issuer", this.readString$default$2());
        if (config.hasPath("key-url")) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Reading static info for IDP {}", (Object)this.issuer());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            some = new Some((Object)this.readStaticConfiguration());
        } else {
            String connectUrl = this.readString("connect-url", this.readString$default$2());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(connectUrl))) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Reading dynamic info for IDP {} from connect-url {}", new Object[]{this.issuer(), connectUrl});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = new Some((Object)this.readDynamicConfiguration(connectUrl));
            } else if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.issuer()))) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Reading dynamic info for IDP {}", (Object)this.issuer());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = new Some((Object)this.readDynamicConfiguration(this.issuer()));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Encountered empty IDP configuration; this configuration will be skipped");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            }
        }
        this.metadata = some;
    }
}

