/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command;

import java.util.Map;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.StartCase;
import org.cafienne.cmmn.actorapi.command.team.CaseTeam;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.parameter.InputParameterDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.team.CaseTeamError;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

@Manifest
public class ReactivateCase
extends StartCase {
    @Override
    public boolean isBootstrapMessage() {
        return false;
    }

    public ReactivateCase(String string, CaseUserIdentity caseUserIdentity, String string2, CaseDefinition caseDefinition, ValueMap valueMap, CaseTeam caseTeam, boolean bl, String string3, String string4) {
        super(string, caseUserIdentity, string2, caseDefinition, valueMap, caseTeam, bl, string3, string4);
    }

    public ReactivateCase(ValueMap valueMap) {
        super(valueMap);
    }

    @Override
    public String toString() {
        return "Reactivate Case '" + this.definition.getName() + "'";
    }

    @Override
    public void validate(Case case_) {
        ((Map)this.inputParameters.getValue()).forEach((string, value) -> {
            InputParameterDefinition inputParameterDefinition = this.definition.getInputParameters().get(string);
            if (inputParameterDefinition == null) {
                throw new InvalidCommandException("An input parameter with name " + string + " is not defined in the case");
            }
            inputParameterDefinition.validate((Value<?>)value);
        });
        if (this.caseTeam.isEmpty()) {
            case_.addDebugInfo(() -> "Adding user '" + ((CaseUserIdentity)this.getUser()).id() + "' to the case team (as owner) because new team is empty", new Object[0]);
            this.caseTeam = CaseTeam.create((CaseUserIdentity)this.getUser());
        }
        if (this.caseTeam.owners().isEmpty()) {
            throw new CaseTeamError("The case team needs to have at least one owner");
        }
        this.caseTeam.validate(this.definition.getCaseTeamModel());
    }

    @Override
    public void processCaseCommand(Case case_) {
        case_.getCaseTeam().replace(this.caseTeam);
        case_.addDebugInfo(() -> "Input parameters for new case of type " + this.definition.getName(), this.inputParameters);
        case_.setInputParameters(this.inputParameters);
        case_.getCasePlan().makeTransition(Transition.Reactivate);
    }
}

