/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.migration;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.command.team.CaseTeam;
import org.cafienne.cmmn.actorapi.response.migration.MigrationStartedResponse;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.team.CaseTeamError;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class MigrateCaseDefinition
extends CaseCommand {
    private final CaseDefinition newDefinition;
    private final CaseTeam newCaseTeam;

    public MigrateCaseDefinition(CaseUserIdentity caseUserIdentity, String string, CaseDefinition caseDefinition, CaseTeam caseTeam) {
        super(caseUserIdentity, string);
        this.newDefinition = caseDefinition;
        this.newCaseTeam = caseTeam;
    }

    public MigrateCaseDefinition(ValueMap valueMap) {
        super(valueMap);
        this.newDefinition = valueMap.readDefinition((Object)Fields.definition, CaseDefinition.class);
        this.newCaseTeam = valueMap.readObject((Object)Fields.team, CaseTeam::deserialize);
    }

    @Override
    public void validate(Case case_) {
        super.validate(case_);
        if (this.newCaseTeam != null) {
            if (this.newCaseTeam.owners().isEmpty()) {
                throw new CaseTeamError("The case team needs to have at least one owner");
            }
            this.newCaseTeam.validate(this.newDefinition.getCaseTeamModel());
        }
    }

    @Override
    public String toString() {
        return "Migrate Case Definition '" + this.newDefinition.getName() + "'";
    }

    @Override
    public void processCaseCommand(Case case_) {
        if (this.newDefinition.getDefinitionsDocument().equals(case_.getDefinition().getDefinitionsDocument())) {
            case_.addDebugInfo(() -> "No need to migrate definition of case " + case_.getId() + " (proposed definition already in use by the case instance)", new Object[0]);
        } else {
            case_.migrate(this.newDefinition, this.newCaseTeam);
        }
        this.setResponse(new MigrationStartedResponse(this));
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeModelCommand(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.definition, this.newDefinition);
        this.writeField(jsonGenerator, (Object)Fields.team, this.newCaseTeam);
    }
}

