/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.plan;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.response.AddDiscretionaryItemResponse;
import org.cafienne.cmmn.definition.DiscretionaryItemDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.DiscretionaryItem;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.util.Guid;

@Manifest
public class AddDiscretionaryItem
extends CaseCommand {
    private final String name;
    private final String planItemId;
    private final String parentId;
    private final String definitionId;
    private transient DiscretionaryItem discretionaryItem;
    private transient PlanItem<?> parentItem;

    public AddDiscretionaryItem(CaseUserIdentity caseUserIdentity, String string, String string2, String string3, String string4, String string5) {
        super(caseUserIdentity, string);
        this.name = string2;
        this.planItemId = string5 == null || string5.isEmpty() ? new Guid().toString() : string5;
        this.definitionId = string3;
        this.parentId = string4;
    }

    public AddDiscretionaryItem(ValueMap valueMap) {
        super(valueMap);
        this.name = valueMap.readString((Object)Fields.name, new String[0]);
        this.planItemId = valueMap.readString((Object)Fields.planItemId, new String[0]);
        this.definitionId = valueMap.readString((Object)Fields.definitionId, new String[0]);
        this.parentId = valueMap.readString((Object)Fields.parentId, new String[0]);
    }

    @Override
    public void validate(Case case_) {
        super.validate(case_);
        Object t = case_.getPlanItemById(this.planItemId);
        if (t != null) {
            throw new InvalidCommandException("Cannot plan a discretionary item named '" + this.name + "' with the specified id " + this.planItemId + ", because the case already has a plan item with that id");
        }
        this.parentItem = case_.getPlanItemById(this.parentId);
        if (this.parentItem == null) {
            throw new InvalidCommandException("Cannot plan a discretionary item named '" + this.name + "' because the parent item with id '" + this.parentId + "' cannot be found in the case");
        }
        DiscretionaryItemDefinition discretionaryItemDefinition = (DiscretionaryItemDefinition)case_.getDefinition().getElement(this.definitionId);
        this.discretionaryItem = discretionaryItemDefinition.createInstance(this.parentItem);
        if (!this.discretionaryItem.isPlannable()) {
            throw new InvalidCommandException("Cannot plan a discretionary item named '" + this.name + "'. It may not be applicable at this moment");
        }
        if (!this.discretionaryItem.isAuthorized()) {
            throw new InvalidCommandException("No authorization available to plan a discretionary item named '" + this.name + "'");
        }
    }

    @Override
    public void processCaseCommand(Case case_) {
        this.discretionaryItem.plan(this.planItemId);
        this.setResponse(new AddDiscretionaryItemResponse(this, new ValueMap("planItemId", this.planItemId)));
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeModelCommand(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.name, this.name);
        this.writeField(jsonGenerator, (Object)Fields.planItemId, this.planItemId);
        this.writeField(jsonGenerator, (Object)Fields.definitionId, this.definitionId);
        this.writeField(jsonGenerator, (Object)Fields.parentId, this.parentId);
    }
}

