/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.team.removemember;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamCommand;
import org.cafienne.cmmn.actorapi.command.team.CaseTeamMember;
import org.cafienne.cmmn.instance.team.CaseTeamError;
import org.cafienne.cmmn.instance.team.MemberType;
import org.cafienne.cmmn.instance.team.Team;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

abstract class RemoveCaseTeamMemberCommand<M extends CaseTeamMember>
extends CaseTeamCommand {
    protected final String memberId;

    protected RemoveCaseTeamMemberCommand(CaseUserIdentity caseUserIdentity, String string, String string2) {
        super(caseUserIdentity, string);
        this.memberId = string2;
    }

    protected RemoveCaseTeamMemberCommand(ValueMap valueMap) {
        super(valueMap);
        this.memberId = valueMap.readString((Object)Fields.memberId, new String[0]);
    }

    protected abstract MemberType type();

    @Override
    public void validate(Team team) throws InvalidCommandException {
        M m = this.member(team);
        if (m == null) {
            throw new CaseTeamError("The case team does not have a " + this.type() + " with id " + this.memberId);
        }
        this.validateNotLastOwner(team);
    }

    protected void validateNotLastOwner(Team team) {
        M m = this.member(team);
        if (m != null && m.isOwner() && team.getOwners().size() == 1) {
            throw new CaseTeamError("Cannot remove the last case owner");
        }
    }

    protected abstract M member(Team var1);

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.memberId, this.memberId);
    }
}

