/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.migration;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class PlanItemMigrated
extends CasePlanEvent {
    public final String planItemName;
    public final String definitionId;

    public PlanItemMigrated(PlanItem<?> planItem) {
        super(planItem);
        this.planItemName = planItem.getName();
        this.definitionId = planItem.getItemDefinition().getId();
    }

    public PlanItemMigrated(ValueMap valueMap) {
        super(valueMap);
        this.planItemName = valueMap.readString((Object)Fields.name, new String[0]);
        this.definitionId = valueMap.readString((Object)Fields.definitionId, "");
    }

    @Override
    public String getDescription() {
        return "PlanItemCreated [" + this.getType() + "-" + this.getPlanItemName() + "." + this.getIndex() + "/" + this.getPlanItemId() + "]";
    }

    public String getPlanItemName() {
        return this.planItemName;
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeCasePlanEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.name, this.planItemName);
        this.writeField(jsonGenerator, (Object)Fields.definitionId, this.definitionId);
    }

    @Override
    protected void updatePlanItemState(PlanItem<?> planItem) {
    }
}

