/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.plan;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.util.Guid;

@Manifest
public class PlanItemCreated
extends CasePlanEvent {
    public final String definitionId;

    public PlanItemCreated(Case case_) {
        this(case_, new Guid().toString(), "", new Path(""), case_.getDefinition().getCasePlanModel(), 0);
    }

    public PlanItemCreated(Stage<?> stage, ItemDefinition itemDefinition, String string, int n) {
        this(stage.getCaseInstance(), string, stage.getId(), stage.getPath(), itemDefinition, n);
    }

    private PlanItemCreated(Case case_, String string, String string2, Path path, ItemDefinition itemDefinition, int n) {
        super(case_, string, string2, new Path(path, itemDefinition, n), itemDefinition.getPlanItemDefinition().getItemType(), null);
        this.definitionId = itemDefinition.getId();
    }

    public PlanItemCreated(ValueMap valueMap) {
        super(valueMap);
        this.definitionId = valueMap.readString((Object)Fields.definitionId, "");
    }

    @Override
    public String getDescription() {
        return "PlanItemCreated [" + this.getType() + "-" + this.getPlanItemName() + "." + this.getIndex() + "/" + this.getPlanItemId() + "]" + (String)(this.stageId.isEmpty() ? "" : " in stage " + this.stageId);
    }

    public Instant getCreatedOn() {
        return this.getTimestamp() == null ? this.rawJson().readInstant((Object)Fields.createdOn, new Instant[0]) : this.getTimestamp();
    }

    public String getPlanItemName() {
        return this.path.isEmpty() ? this.rawJson().readString((Object)Fields.name, new String[0]) : this.path.name;
    }

    public PlanItem<?> getCreatedPlanItem() {
        return this.getPlanItem();
    }

    @Override
    public void updateState(Case case_) {
        PlanItem<?> planItem = case_.add(this);
        this.setPlanItem(planItem);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeCasePlanEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.definitionId, this.definitionId);
    }

    @Override
    protected void updatePlanItemState(PlanItem<?> planItem) {
    }
}

