/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanItemStarter;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItemType;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.task.cmmn.CaseTask;
import org.w3c.dom.Element;

public class CaseTaskDefinition
extends TaskDefinition<CaseDefinition> {
    private final String caseRef = this.parseAttribute("caseRef", true, new String[0]);
    private CaseDefinition subCaseDefinition;

    public CaseTaskDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.subCaseDefinition = this.getCaseDefinition().getDefinitionsDocument().getCaseDefinition(this.caseRef);
        if (this.subCaseDefinition == null) {
            this.getCaseDefinition().addReferenceError("The case task '" + this.getName() + "' refers to a case named " + this.caseRef + ", but that definition is not found");
        }
    }

    @Override
    protected void validateElement() {
        PlanItemStarter planItemStarter;
        super.validateElement();
        if (this.getImplementationDefinition().equals(this.getCaseDefinition()) && (planItemStarter = this.findItemDefinition().getStarter()).isImmediate()) {
            this.getCaseDefinition().addDefinitionError("CaseTask '" + this.getName() + "' leads to infinite recursion, because\n " + planItemStarter);
        }
    }

    @Override
    public PlanItemType getItemType() {
        return PlanItemType.CaseTask;
    }

    public CaseTask createInstance(String string, int n, ItemDefinition itemDefinition, Stage<?> stage, Case case_) {
        return new CaseTask(string, n, itemDefinition, this, stage);
    }

    @Override
    public CaseDefinition getImplementationDefinition() {
        return this.subCaseDefinition;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameCaseTask);
    }

    public boolean sameCaseTask(CaseTaskDefinition caseTaskDefinition) {
        return this.sameTask(caseTaskDefinition) && this.subCaseDefinition.sameIdentifiers(caseTaskDefinition.subCaseDefinition);
    }
}

