/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import org.cafienne.cmmn.definition.ApplicabilityRuleDefinition;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ItemControlDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.TableItemDefinition;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.definition.extension.workflow.FourEyesDefinition;
import org.cafienne.cmmn.definition.extension.workflow.RendezVousDefinition;
import org.cafienne.cmmn.definition.sentry.EntryCriterionDefinition;
import org.cafienne.cmmn.definition.sentry.ExitCriterionDefinition;
import org.cafienne.cmmn.definition.sentry.ReactivateCriterionDefinition;
import org.cafienne.cmmn.instance.DiscretionaryItem;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.w3c.dom.Element;

public class DiscretionaryItemDefinition
extends TableItemDefinition
implements ItemDefinition {
    private ItemControlDefinition planItemControl;
    private PlanItemDefinitionDefinition definition;
    private final Collection<EntryCriterionDefinition> entryCriteria = new ArrayList<EntryCriterionDefinition>();
    private final Collection<ReactivateCriterionDefinition> reactivationCriteria = new ArrayList<ReactivateCriterionDefinition>();
    private final Collection<ExitCriterionDefinition> exitCriteria = new ArrayList<ExitCriterionDefinition>();
    private final FourEyesDefinition fourEyesDefinition;
    private final RendezVousDefinition rendezVousDefinition;
    private final String planItemDefinitionRefValue = this.parseAttribute("definitionRef", true, new String[0]);

    public DiscretionaryItemDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.parse("entryCriterion", EntryCriterionDefinition.class, this.entryCriteria);
        this.parse("exitCriterion", ExitCriterionDefinition.class, this.exitCriteria);
        this.parseExtension("reactivateCriterion", ReactivateCriterionDefinition.class, this.reactivationCriteria);
        this.planItemControl = this.parse("itemControl", ItemControlDefinition.class, false);
        this.fourEyesDefinition = this.parseExtension("four_eyes", FourEyesDefinition.class);
        this.rendezVousDefinition = this.parseExtension("rendez_vous", RendezVousDefinition.class);
        if (this.definition instanceof TaskDefinition && !((TaskDefinition)this.definition).isBlocking() && !this.exitCriteria.isEmpty()) {
            this.getCaseDefinition().addDefinitionError("The plan item " + this.getName() + " has exit sentries, but these are not allowed for a non blocking task");
            return;
        }
    }

    @Override
    public ItemControlDefinition getPlanItemControl() {
        return this.planItemControl;
    }

    @Override
    public PlanItemDefinitionDefinition getPlanItemDefinition() {
        return this.definition;
    }

    @Override
    public String getType() {
        return this.definition.getType();
    }

    @Override
    public Collection<EntryCriterionDefinition> getEntryCriteria() {
        return this.entryCriteria;
    }

    @Override
    public Collection<ReactivateCriterionDefinition> getReactivatingCriteria() {
        return this.reactivationCriteria;
    }

    @Override
    public Collection<ExitCriterionDefinition> getExitCriteria() {
        return this.exitCriteria;
    }

    @Override
    public FourEyesDefinition getFourEyesDefinition() {
        return this.fourEyesDefinition;
    }

    @Override
    public RendezVousDefinition getRendezVousDefinition() {
        return this.rendezVousDefinition;
    }

    @Override
    public boolean isDiscretionary() {
        return true;
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.definition = this.getCaseDefinition().findPlanItemDefinition(this.planItemDefinitionRefValue);
        if (this.definition == null) {
            this.getCaseDefinition().addReferenceError("The discretionary item '" + this.getName() + "' refers to a definition named '" + this.planItemDefinitionRefValue + "', but that definition is not found");
            return;
        }
        if (this.getName().isEmpty()) {
            this.setName(this.definition.getName());
        }
    }

    @Override
    protected void validateElement() {
        super.validateElement();
        if (this.planItemControl == null) {
            this.planItemControl = this.definition.getDefaultControl();
        }
        this.checkTaskPairingConstraints();
    }

    public boolean isApplicable(PlanItem<?> planItem) {
        if (this.isAlreadyPlanned(planItem)) {
            return false;
        }
        if (this.getApplicabilityRules().isEmpty()) {
            planItem.getCaseInstance().addDebugInfo(() -> this + ": item is applicable because rules are not defined", new Object[0]);
            return true;
        }
        planItem.getCaseInstance().addDebugInfo(() -> this + ": checking " + this.getApplicabilityRules().size() + " applicability rule(s)", new Object[0]);
        for (ApplicabilityRuleDefinition applicabilityRuleDefinition : this.getApplicabilityRules()) {
            if (applicabilityRuleDefinition.evaluate(planItem, applicabilityRuleDefinition, this)) continue;
            return false;
        }
        return true;
    }

    private boolean isAlreadyPlanned(PlanItem<?> planItem) {
        Stage<?> stage = planItem instanceof Stage ? (Stage<?>)planItem : planItem.getStage();
        Collection<PlanItem<?>> collection = stage.getPlanItems();
        for (PlanItem<?> planItem2 : collection) {
            if (!planItem2.getName().equals(this.getName()) || planItem2.repeats()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Element dumpMemoryStateToXML(Element element, Stage<?> stage) {
        Element element2 = element.getOwnerDocument().createElement("discretionaryItem");
        element2.setAttribute("name", this.getName());
        super.dumpMemoryStateToXML(element2, stage);
        element.appendChild(element2);
        return element2;
    }

    @Override
    public void evaluate(PlanItem<?> planItem, Collection<DiscretionaryItem> collection) {
        if (this.isApplicable(planItem)) {
            collection.add(this.createInstance(planItem));
        }
    }

    public DiscretionaryItem createInstance(PlanItem<?> planItem) {
        return new DiscretionaryItem(planItem, this);
    }

    @Override
    protected DiscretionaryItemDefinition getDiscretionaryItem(String string) {
        if (this.getName().equals(string) || this.getId().equals(string)) {
            return this;
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.definition == null) {
            return super.toString();
        }
        return "DiscretionaryItem[" + this.definition.getType() + " '" + this.getName() + "']";
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameDiscretionaryItem);
    }

    public boolean sameDiscretionaryItem(DiscretionaryItemDefinition discretionaryItemDefinition) {
        return this.sameTableItem(discretionaryItemDefinition) && this.same(this.definition, discretionaryItemDefinition.definition) && this.same(this.planItemControl, discretionaryItemDefinition.planItemControl) && this.same(this.entryCriteria, discretionaryItemDefinition.entryCriteria) && this.same(this.exitCriteria, discretionaryItemDefinition.exitCriteria);
    }
}

