/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.DefinitionsDocument;
import org.cafienne.cmmn.definition.parameter.InputParameterDefinition;
import org.cafienne.cmmn.definition.parameter.OutputParameterDefinition;
import org.w3c.dom.Element;

public abstract class ModelDefinition
extends CMMNElementDefinition {
    private final String defaultExpressionLanguage;
    private final Collection<CMMNElementDefinition> elements = new ArrayList<CMMNElementDefinition>();
    private final DefinitionsDocument document;
    private final Map<String, InputParameterDefinition> inputParameters = new LinkedHashMap<String, InputParameterDefinition>();
    private final Map<String, OutputParameterDefinition> outputParameters = new LinkedHashMap<String, OutputParameterDefinition>();

    protected ModelDefinition(Element element, DefinitionsDocument definitionsDocument) {
        super(element, null, null, true);
        this.document = definitionsDocument;
        this.defaultExpressionLanguage = this.parseAttribute("expressionLanguage", false, definitionsDocument.getDefaultExpressionLanguage());
        this.parse("input", InputParameterDefinition.class, this.inputParameters);
        this.parse("output", OutputParameterDefinition.class, this.outputParameters);
        definitionsDocument.addElement(this);
    }

    public String getDefaultExpressionLanguage() {
        return this.defaultExpressionLanguage;
    }

    public DefinitionsDocument getDefinitionsDocument() {
        return this.document;
    }

    void addCMMNElement(CMMNElementDefinition cMMNElementDefinition) {
        this.elements.add(cMMNElementDefinition);
        this.document.addElement(cMMNElementDefinition);
    }

    public <T extends CMMNElementDefinition> T findElement(ElementMatcher elementMatcher) {
        for (CMMNElementDefinition cMMNElementDefinition : this.elements) {
            if (!elementMatcher.matches(cMMNElementDefinition)) continue;
            return (T)cMMNElementDefinition;
        }
        return null;
    }

    public <T extends CMMNElementDefinition> T getElement(String string) {
        return this.findElement(cMMNElementDefinition -> cMMNElementDefinition.getName().equals(string) || cMMNElementDefinition.getId().equals(string));
    }

    @Override
    public ModelDefinition getModelDefinition() {
        return this;
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        for (CMMNElementDefinition cMMNElementDefinition : this.elements) {
            cMMNElementDefinition.resolveReferences();
        }
    }

    @Override
    protected void validateElement() {
        super.validateElement();
        for (CMMNElementDefinition cMMNElementDefinition : this.elements) {
            cMMNElementDefinition.validateElement();
        }
    }

    public void addDefinitionError(String string) {
        this.document.addDefinitionError(this, string);
    }

    public void addReferenceError(String string) {
        this.document.addDefinitionError(this, string);
    }

    public void fatalError(String string, Throwable throwable) {
        this.document.addFatalError(this, string, throwable);
    }

    public Map<String, InputParameterDefinition> getInputParameters() {
        return this.inputParameters;
    }

    public Map<String, OutputParameterDefinition> getOutputParameters() {
        return this.outputParameters;
    }

    public boolean sameModelDefinition(ModelDefinition modelDefinition) {
        return this.sameIdentifiers(modelDefinition) && this.same(this.defaultExpressionLanguage, modelDefinition.defaultExpressionLanguage) && this.same(this.inputParameters.values(), modelDefinition.inputParameters.values()) && this.same(this.outputParameters.values(), modelDefinition.outputParameters.values());
    }

    @FunctionalInterface
    public static interface ElementMatcher {
        public boolean matches(CMMNElementDefinition var1);
    }
}

