/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.cafienne.cmmn.definition.ApplicabilityRuleDefinition;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.DiscretionaryItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanningTableDefinition;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.instance.CasePlan;
import org.cafienne.cmmn.instance.DiscretionaryItem;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.State;
import org.w3c.dom.Element;

abstract class TableItemDefinition
extends CMMNElementDefinition {
    private final String applicabilityRuleRefs;
    private final String authorizedRoleRefs;
    private final List<ApplicabilityRuleDefinition> applicabilityRules = new ArrayList<ApplicabilityRuleDefinition>();
    private final Collection<CaseRoleDefinition> authorizedRoles = new ArrayList<CaseRoleDefinition>();

    protected TableItemDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.applicabilityRuleRefs = this.parseAttribute("applicabilityRuleRefs", false, "");
        this.authorizedRoleRefs = this.parseAttribute("authorizedRoleRefs", false, "");
    }

    protected abstract DiscretionaryItemDefinition getDiscretionaryItem(String var1);

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        StringTokenizer stringTokenizer = new StringTokenizer(this.applicabilityRuleRefs, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            ApplicabilityRuleDefinition applicabilityRuleDefinition = this.getTable().getApplicabilityRule(string);
            if (applicabilityRuleDefinition == null) {
                this.getCaseDefinition().addReferenceError("An applicability rule with name " + string + " is referenced from table item " + this.getName() + ", but it cannot be found in the planning table");
                continue;
            }
            this.applicabilityRules.add(applicabilityRuleDefinition);
        }
        this.getCaseDefinition().getCaseTeamModel().resolveRoleReferences(this.authorizedRoleRefs, this.authorizedRoles, "Table item " + this);
    }

    private PlanningTableDefinition getTable() {
        for (CMMNElementDefinition cMMNElementDefinition = (CMMNElementDefinition)this.getParentElement(); cMMNElementDefinition != null; cMMNElementDefinition = (CMMNElementDefinition)cMMNElementDefinition.getParentElement()) {
            if (!(cMMNElementDefinition instanceof PlanningTableDefinition)) continue;
            return (PlanningTableDefinition)cMMNElementDefinition;
        }
        return null;
    }

    protected List<ApplicabilityRuleDefinition> getApplicabilityRules() {
        return this.applicabilityRules;
    }

    public Collection<CaseRoleDefinition> getAuthorizedRoles() {
        return this.authorizedRoles;
    }

    public boolean isPlanningAllowed(PlanItem<?> planItem) {
        State state = planItem.getState();
        if (planItem instanceof CasePlan) {
            return state.isActive() || state.isFailed() || state.isSuspended() || state.isCompleted() || state.isTerminated();
        }
        if (planItem instanceof Stage) {
            return state.isActive() || state.isAvailable() || state.isEnabled() || state.isDisabled() || state.isFailed() || state.isSuspended();
        }
        return state.isActive();
    }

    public abstract void evaluate(PlanItem<?> var1, Collection<DiscretionaryItem> var2);

    public Element dumpMemoryStateToXML(Element element, Stage<?> stage) {
        Collection<CaseRoleDefinition> collection = this.getAuthorizedRoles();
        for (CaseRoleDefinition caseRoleDefinition : collection) {
            String string = caseRoleDefinition.getName();
            Element element2 = element.getOwnerDocument().createElement("Role");
            element.appendChild(element2);
            element2.setAttribute("name", string);
        }
        return element;
    }

    protected boolean sameTableItem(TableItemDefinition tableItemDefinition) {
        return this.sameIdentifiers(tableItemDefinition) && this.same(this.applicabilityRules, tableItemDefinition.applicabilityRules) && this.same(this.authorizedRoles, tableItemDefinition.authorizedRoles);
    }
}

