/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.casefile;

import java.util.Collection;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.Multiplicity;
import org.cafienne.cmmn.definition.casefile.CaseFileError;
import org.cafienne.cmmn.definition.casefile.CaseFileItemCollectionDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinitionDefinition;
import org.cafienne.cmmn.definition.casefile.PropertyDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Path;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItemArray;
import org.cafienne.cmmn.instance.casefile.CaseFileItemCollection;
import org.cafienne.json.Value;
import org.w3c.dom.Element;

public class CaseFileItemDefinition
extends CaseFileItemCollectionDefinition {
    private final Multiplicity multiplicity = this.readMultiplicity();
    private final String definitionRef = this.parseAttribute("definitionRef", true, "");
    private final String sourceRef = this.parseAttribute("sourceRef", false, "");
    private final String targetRefs = this.parseAttribute("targetRefs", false, "");
    private CaseFileItemDefinitionDefinition typeDefinition;

    public CaseFileItemDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.parseGrandChildren("children", "caseFileItem", CaseFileItemDefinition.class, this.getChildren());
    }

    private Multiplicity readMultiplicity() {
        String string = this.parseAttribute("multiplicity", false, "Unspecified");
        try {
            return Multiplicity.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.getCaseDefinition().addDefinitionError(string + " is not a valid multiplicity (in CaseFileItem " + this.getName() + ")");
            return null;
        }
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.typeDefinition = this.getCaseDefinition().getDefinitionsDocument().getCaseFileItemDefinition(this.definitionRef);
        if (this.typeDefinition == null) {
            this.getModelDefinition().addReferenceError("The case file item '" + this.getName() + "' refers to a definition named " + this.definitionRef + ", but that definition is not found");
            return;
        }
        if (!this.sourceRef.isEmpty()) {
            // empty if block
        }
        if (!this.targetRefs.isEmpty()) {
            // empty if block
        }
    }

    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public CaseFileItemDefinitionDefinition getCaseFileItemDefinition() {
        return this.typeDefinition;
    }

    @Override
    public boolean isUndefined(String string) {
        return super.isUndefined(string) && !this.getCaseFileItemDefinition().getProperties().containsKey(string);
    }

    public Path getPath() {
        return new Path(this);
    }

    public CaseFileItem createInstance(Case case_, CaseFileItemCollection<?> caseFileItemCollection) {
        if (this.multiplicity.isIterable()) {
            return new CaseFileItemArray(case_, this, caseFileItemCollection);
        }
        return new CaseFileItem(case_, this, caseFileItemCollection);
    }

    public void validatePropertyTypes(Value<?> value) throws CaseFileError {
        this.getCaseFileItemDefinition().getDefinitionType().validate(this, value);
    }

    public Collection<PropertyDefinition> getBusinessIdentifiers() {
        return this.getCaseFileItemDefinition().getBusinessIdentifiers();
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameCaseFileItem);
    }

    public boolean sameCaseFileItem(CaseFileItemDefinition caseFileItemDefinition) {
        return this.sameCollection(caseFileItemDefinition) && this.same(this.multiplicity, caseFileItemDefinition.multiplicity) && this.same(this.typeDefinition, caseFileItemDefinition.typeDefinition) && this.same(this.sourceRef, caseFileItemDefinition.sourceRef) && this.same(this.targetRefs, caseFileItemDefinition.targetRefs);
    }
}

