/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.extension.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.DefinitionElement;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.extension.workflow.ItemDefinitionReference;
import org.w3c.dom.Element;

public abstract class TaskPairingDefinition
extends CMMNElementDefinition {
    private final Collection<ItemDefinitionReference> stringReferences = new ArrayList<ItemDefinitionReference>();
    protected final Collection<ItemDefinition> directReferences = new ArrayList<ItemDefinition>();
    protected final Collection<ItemDefinition> allReferences = new ArrayList<ItemDefinition>();
    protected final ItemDefinition parent;

    protected TaskPairingDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.parse("task", ItemDefinitionReference.class, this.stringReferences);
        this.parent = (ItemDefinition)this.getParentElement();
    }

    @Override
    public String getContextDescription() {
        return this.getType() + " in " + this.getParentElement().getContextDescription();
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.stringReferences.forEach(ItemDefinitionReference::resolveReferences);
        this.stringReferences.forEach(itemDefinitionReference -> this.directReferences.add(itemDefinitionReference.getItemDefinition()));
        this.loadIndirectReferences();
    }

    protected abstract void loadIndirectReferences();

    @Override
    protected void validateElement() {
        super.validateElement();
        this.stringReferences.stream().map(ItemDefinitionReference::getItemDefinition).forEach(itemDefinition -> {
            TaskPairingDefinition taskPairingDefinition = this.getCounterPart((ItemDefinition)itemDefinition);
            if (taskPairingDefinition == null) {
                this.getModelDefinition().addDefinitionError(this.getContextDescription() + " refers to " + itemDefinition.getName() + ", but " + itemDefinition.getName() + " does not have " + this.getType() + " defined");
            } else if (!taskPairingDefinition.references((ItemDefinition)this.getParentElement())) {
                this.getModelDefinition().addDefinitionError(this.getContextDescription() + " refers to " + itemDefinition.getName() + ", but " + taskPairingDefinition.getContextDescription() + " does not refer to " + this.getParentElement().getContextDescription());
            }
        });
    }

    public String getAllReferredItemNames() {
        return this.getAllReferences().stream().map(DefinitionElement::getName).collect(Collectors.joining(", ", "[", "]"));
    }

    protected abstract TaskPairingDefinition getCounterPart(ItemDefinition var1);

    public boolean hasReferences() {
        return !this.stringReferences.isEmpty();
    }

    public boolean references(ItemDefinition itemDefinition) {
        return this.getAllReferences().contains(itemDefinition);
    }

    public Collection<ItemDefinition> getAllReferences() {
        return this.allReferences;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::samePairingDefinition);
    }

    private boolean samePairingDefinition(TaskPairingDefinition taskPairingDefinition) {
        return this.same(this.stringReferences, taskPairingDefinition.stringReferences);
    }
}

