/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.sentry;

import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.DefinitionElement;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.sentry.SentryDefinition;
import org.cafienne.cmmn.instance.Transition;
import org.w3c.dom.Element;

public abstract class CriterionDefinition
extends CMMNElementDefinition {
    private final String sentryRef = this.parseAttribute("sentryRef", true, new String[0]);
    private SentryDefinition sentry;

    protected CriterionDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
    }

    public SentryDefinition getSentryDefinition() {
        if (this.sentry == null) {
            this.resolveReferences();
        }
        return this.sentry;
    }

    public abstract Transition getTransition();

    @Override
    public String toString() {
        String string = this.getSentryDefinition().getOnParts().stream().map(DefinitionElement::getContextDescription).collect(Collectors.joining(","));
        return this.getType() + " for " + this.getParentElement() + " on " + string;
    }

    public String getTarget() {
        return this.getPlanItemName();
    }

    public String getPlanItemName() {
        return ((XMLElementDefinition)this.getParentElement()).getName();
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.sentry = this.getSurroundingStage().getSentry(this.sentryRef);
        if (this.sentry == null) {
            this.getCaseDefinition().addReferenceError("A sentry with name " + this.sentryRef + " is referenced from a plan item, but it cannot be found in the case plan");
        }
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameCriterion);
    }

    public boolean sameCriterion(CriterionDefinition criterionDefinition) {
        return this.same(this.sentry, criterionDefinition.sentry) && this.same(this.getTransition(), criterionDefinition.getTransition());
    }
}

