/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.team;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.util.XMLHelper;
import org.w3c.dom.Element;

public class CaseRoleDefinition
extends CMMNElementDefinition {
    private static final String emptyRoleIdentifier = "all_across_empty_role";
    private final boolean isEmptyRole;

    public CaseRoleDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        this(element, modelDefinition, cMMNElementDefinition, false);
    }

    private boolean isDefaultEmptyRole() {
        return this.isEmptyRole || this.getId().equals(emptyRoleIdentifier);
    }

    private CaseRoleDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition, boolean bl) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.isEmptyRole = bl;
        if ((this.getName() == null || this.getName().isBlank()) && !this.isDefaultEmptyRole()) {
            modelDefinition.addDefinitionError("A role element without a name was encountered. Role is not added to the case definition. XML element:\n" + XMLHelper.printXMLNode(element));
        }
    }

    static CaseRoleDefinition createEmptyDefinition(CMMNElementDefinition cMMNElementDefinition) {
        Element element = cMMNElementDefinition.getElement().getOwnerDocument().createElement("caseRole");
        element.setAttribute("id", emptyRoleIdentifier);
        element.setAttribute("name", "");
        element.setAttribute("description", "");
        return new CaseRoleDefinition(element, cMMNElementDefinition.getModelDefinition(), cMMNElementDefinition, true);
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameRole);
    }

    public boolean sameRole(CaseRoleDefinition caseRoleDefinition) {
        return this.sameIdentifiers(caseRoleDefinition);
    }
}

