/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.team;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.util.XMLHelper;
import org.w3c.dom.Element;

public class CaseTeamDefinition
extends CMMNElementDefinition {
    private final Collection<CaseRoleDefinition> caseRoles = new ArrayList<CaseRoleDefinition>();

    public CaseTeamDefinition(CaseDefinition caseDefinition) {
        super(caseDefinition.getElement(), (ModelDefinition)caseDefinition, caseDefinition, new boolean[0]);
        List list;
        Object object;
        this.parse("caseRole", CaseRoleDefinition.class, this.caseRoles);
        List<Element> list2 = XMLHelper.getChildrenWithTagName(this.getElement(), "caseRoles");
        if (list2.size() != 1) {
            this.parse("caseRoles", CaseRoleDefinition.class, this.caseRoles);
        } else {
            object = (Element)list2.iterator().next();
            if (object.getAttribute("name").isEmpty()) {
                this.parseGrandChildren("caseRoles", "role", CaseRoleDefinition.class, this.caseRoles);
            } else {
                this.parse("caseRoles", CaseRoleDefinition.class, this.caseRoles);
            }
        }
        object = this.caseRoles.stream().map(XMLElementDefinition::getName).collect(Collectors.toList());
        if (!object.contains("")) {
            this.caseRoles.add(CaseRoleDefinition.createEmptyDefinition(this));
        }
        if ((list = object.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(entry -> {
            String string = (String)entry.getKey();
            Long l = (Long)entry.getValue();
            return "'" + string + "' occurs " + l + " times";
        }).collect(Collectors.toList())).size() > 0) {
            this.getCaseDefinition().addDefinitionError("Cannot have duplicate case role names " + list);
        }
    }

    public Collection<CaseRoleDefinition> getCaseRoles() {
        return this.caseRoles;
    }

    public CaseRoleDefinition getCaseRole(String string) {
        return this.caseRoles.stream().filter(caseRoleDefinition -> caseRoleDefinition.getName().equals(string) || caseRoleDefinition.getId().equals(string)).findFirst().orElse(null);
    }

    public void resolveRoleReferences(String string, Collection<CaseRoleDefinition> collection, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            CaseRoleDefinition caseRoleDefinition = this.resolveRoleReference(string3, string2);
            if (caseRoleDefinition == null) continue;
            collection.add(caseRoleDefinition);
        }
    }

    public CaseRoleDefinition resolveRoleReference(String string, String string2) {
        CaseRoleDefinition caseRoleDefinition = this.getCaseRole(string);
        if (caseRoleDefinition != null) {
            return caseRoleDefinition;
        }
        this.getModelDefinition().addDefinitionError("A role '" + string + "' is referenced from " + string2 + ", but it cannot be found in the case definition");
        return null;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameTeam);
    }

    public boolean sameTeam(CaseTeamDefinition caseTeamDefinition) {
        return this.same(this.caseRoles, caseTeamDefinition.caseRoles);
    }
}

